/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

import io.sentry.core.transport.Retryable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class RetryingThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private final int maxQueueSize;
    private final AtomicInteger currentlyRunning;
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    static final long HTTP_RETRY_AFTER_DEFAULT_DELAY_MS = 60000L;
    private final AtomicBoolean retryAfter = new AtomicBoolean(false);
    private final Timer timer = new Timer(true);
    private TimerTask timerTaskRetryAfter;

    public RetryingThreadPoolExecutor(int corePoolSize, int maxQueueSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, threadFactory, rejectedExecutionHandler);
        this.maxQueueSize = maxQueueSize;
        this.currentlyRunning = new AtomicInteger();
    }

    public void submit(Retryable task) {
        if (this.isSchedulingAllowed()) {
            super.submit(task);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.isSchedulingAllowed()) {
            return super.submit(task);
        }
        return new CancelledFuture();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this.isSchedulingAllowed()) {
            return super.submit(task, result);
        }
        return new CancelledFuture();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.isSchedulingAllowed()) {
            return super.submit(task);
        }
        return new CancelledFuture();
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        if (runnable instanceof NextAttempt) {
            runnable = ((NextAttempt)runnable).runnable;
        }
        return new AttemptedRunnable(task, runnable);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.currentlyRunning.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
            if (!(r instanceof AttemptedRunnable)) {
                return;
            }
            AttemptedRunnable ar = (AttemptedRunnable)r;
            if (t == null) {
                try {
                    ar.get();
                }
                catch (CancellationException ce) {
                    t = ce;
                }
                catch (ExecutionException ee) {
                    t = ee.getCause();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.currentlyRunning.decrementAndGet();
                    return;
                }
            }
            if (t != null) {
                long delayMillis = -1L;
                int responseCode = -1;
                if (ar.suppliedAction instanceof Retryable) {
                    delayMillis = ((Retryable)ar.suppliedAction).getSuggestedRetryDelayMillis();
                    responseCode = ((Retryable)ar.suppliedAction).getResponseCode();
                }
                if (responseCode == 429) {
                    if (delayMillis <= 0L) {
                        delayMillis = 60000L;
                    }
                    this.scheduleRetryAfterDelay(delayMillis);
                    this.getQueue().clear();
                }
            }
        }
        finally {
            this.currentlyRunning.decrementAndGet();
        }
    }

    private void scheduleRetryAfterDelay(long delayMillis) {
        if (!this.retryAfter.getAndSet(true)) {
            if (this.timerTaskRetryAfter != null) {
                this.timerTaskRetryAfter.cancel();
            }
            this.timerTaskRetryAfter = new TimerTask(){

                @Override
                public void run() {
                    RetryingThreadPoolExecutor.this.retryAfter.set(false);
                }
            };
            this.timer.schedule(this.timerTaskRetryAfter, delayMillis);
        }
    }

    private boolean isSchedulingAllowed() {
        return this.getQueue().size() + this.currentlyRunning.get() < this.maxQueueSize && !this.retryAfter.get();
    }

    private static final class CancelledFuture<T>
    implements Future<T> {
        private CancelledFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            throw new CancellationException();
        }

        @Override
        public T get(long timeout, @NotNull TimeUnit unit) {
            throw new CancellationException();
        }
    }

    private static final class AttemptedRunnable<V>
    implements RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<?> task;
        private final Runnable suppliedAction;

        AttemptedRunnable(RunnableScheduledFuture<?> task, Runnable suppliedAction) {
            this.task = task;
            this.suppliedAction = suppliedAction;
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public int compareTo(@NotNull Delayed o) {
            return this.task.compareTo(o);
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.task.get();
            return null;
        }

        @Override
        public V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.task.get(timeout, unit);
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttemptedRunnable that = (AttemptedRunnable)o;
            return this.task.equals(that.task);
        }

        public int hashCode() {
            return this.task.hashCode();
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static final class NextAttempt
    implements Runnable {
        private final Runnable runnable;

        private NextAttempt(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

