/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.Dsn;
import io.sentry.core.Hub;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISentryClient;
import io.sentry.core.NoOpHub;
import io.sentry.core.OptionsContainer;
import io.sentry.core.ScopeCallback;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.SentryId;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Sentry {
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    private static volatile IHub mainHub = NoOpHub.getInstance();

    private Sentry() {
    }

    private static IHub getCurrentHub() {
        IHub hub = currentHub.get();
        if (hub == null) {
            currentHub.set(mainHub.clone());
        }
        return currentHub.get();
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init() {
        Sentry.init(new SentryOptions());
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        SentryOptions options = (SentryOptions)clazz.createInstance();
        optionsConfiguration.configure(options);
        Sentry.init(options);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration) {
        SentryOptions options = new SentryOptions();
        optionsConfiguration.configure(options);
        Sentry.init(options);
    }

    private static synchronized <T extends SentryOptions> void init(@NotNull T options) {
        String dsn = options.getDsn();
        if (dsn == null || dsn.isEmpty()) {
            Sentry.close();
            return;
        }
        Dsn parsedDsn = new Dsn(dsn);
        ILogger logger = options.getLogger();
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        IHub hub = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        hub.close();
    }

    public static synchronized void close() {
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        hub.close();
    }

    public static SentryId captureEvent(SentryEvent event) {
        return Sentry.getCurrentHub().captureEvent(event);
    }

    public static SentryId captureEvent(SentryEvent event, @Nullable Object hint) {
        return Sentry.getCurrentHub().captureEvent(event, hint);
    }

    public static SentryId captureMessage(String message) {
        return Sentry.getCurrentHub().captureMessage(message);
    }

    public static SentryId captureException(Throwable throwable) {
        return Sentry.getCurrentHub().captureException(throwable);
    }

    public static SentryId captureException(Throwable throwable, @Nullable Object hint) {
        return Sentry.getCurrentHub().captureException(throwable, hint);
    }

    public static void addBreadcrumb(Breadcrumb breadcrumb, @Nullable Object hint) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb, hint);
    }

    public static SentryId getLastEventId() {
        return Sentry.getCurrentHub().getLastEventId();
    }

    public static void pushScope() {
        Sentry.getCurrentHub().pushScope();
    }

    public static void popScope() {
        Sentry.getCurrentHub().popScope();
    }

    public static void withScope(ScopeCallback callback) {
        Sentry.getCurrentHub().withScope(callback);
    }

    public static void configureScope(ScopeCallback callback) {
        Sentry.getCurrentHub().configureScope(callback);
    }

    public static void bindClient(ISentryClient client) {
        Sentry.getCurrentHub().bindClient(client);
    }

    public static void flush(int timeoutMills) {
        Sentry.getCurrentHub().flush(timeoutMills);
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(T var1);
    }
}

