/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

final class SendCachedEventFireAndForgetIntegration
implements Integration {
    private SendFireAndForgetFactory factory;

    SendCachedEventFireAndForgetIntegration(SendFireAndForgetFactory factory) {
        this.factory = factory;
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        String cachedDir = options.getCacheDirPath();
        if (cachedDir == null) {
            ILogger.logIfNotNull(options.getLogger(), SentryLevel.WARNING, "No cache dir path is defined in options.", new Object[0]);
            return;
        }
        SendFireAndForget sender = this.factory.create(hub, options);
        try {
            ExecutorService es = Executors.newSingleThreadExecutor();
            es.submit(() -> {
                try {
                    sender.send();
                    ILogger.logIfNotNull(options.getLogger(), SentryLevel.DEBUG, "Finished processing cached files from %s", cachedDir);
                }
                catch (Exception e) {
                    ILogger.logIfNotNull(options.getLogger(), SentryLevel.ERROR, "Failed trying to send cached events.", e);
                }
            });
            ILogger.logIfNotNull(options.getLogger(), SentryLevel.DEBUG, "Scheduled sending cached files from %s", cachedDir);
            es.shutdown();
        }
        catch (Exception e) {
            ILogger.logIfNotNull(options.getLogger(), SentryLevel.ERROR, "Failed to call the executor. Cached events will not be sent", e);
        }
    }

    static interface SendFireAndForgetFactory {
        public SendFireAndForget create(IHub var1, SentryOptions var2);
    }

    static interface SendFireAndForget {
        public void send();
    }
}

