/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.CircularFifoQueue;
import io.sentry.core.SentryLevel;
import io.sentry.core.SynchronizedQueue;
import io.sentry.core.protocol.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class Scope
implements Cloneable {
    private SentryLevel level;
    private String transaction;
    private User user;
    private List<String> fingerprint = new ArrayList<String>();
    private Queue<Breadcrumb> breadcrumbs;
    private Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private Map<String, Object> extra = new ConcurrentHashMap<String, Object>();
    private int maxBreadcrumb;

    public Scope(int maxBreadcrumb) {
        this.maxBreadcrumb = maxBreadcrumb;
        this.breadcrumbs = this.createBreadcrumbsList(this.maxBreadcrumb);
    }

    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(SentryLevel level) {
        this.level = level;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public List<String> getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(List<String> fingerprint) {
        this.fingerprint = fingerprint;
    }

    Queue<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.breadcrumbs.add(breadcrumb);
    }

    public void clearBreadcrumbs() {
        this.breadcrumbs.clear();
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTag(String key, String value) {
        this.tags.put(key, value);
    }

    public Map<String, Object> getExtras() {
        return this.extra;
    }

    public void setExtra(String key, String value) {
        this.extra.put(key, value);
    }

    private Queue<Breadcrumb> createBreadcrumbsList(int maxBreadcrumb) {
        return SynchronizedQueue.synchronizedQueue(new CircularFifoQueue(maxBreadcrumb));
    }

    public Scope clone() throws CloneNotSupportedException {
        Scope clone = (Scope)super.clone();
        clone.level = this.level != null ? SentryLevel.valueOf(this.level.name().toUpperCase(Locale.ROOT)) : null;
        clone.user = this.user != null ? this.user.clone() : null;
        ArrayList<String> arrayList = clone.fingerprint = this.fingerprint != null ? new ArrayList<String>(this.fingerprint) : null;
        if (this.breadcrumbs != null) {
            Queue<Breadcrumb> breadcrumbsClone = this.createBreadcrumbsList(this.maxBreadcrumb);
            for (Breadcrumb breadcrumb : this.breadcrumbs) {
                Breadcrumb breadcrumbClone = breadcrumb.clone();
                breadcrumbsClone.add(breadcrumbClone);
            }
            clone.breadcrumbs = breadcrumbsClone;
        } else {
            clone.breadcrumbs = null;
        }
        if (this.tags != null) {
            ConcurrentHashMap<String, String> tagsClone = new ConcurrentHashMap<String, String>();
            for (Map.Entry entry : this.tags.entrySet()) {
                if (entry == null) continue;
                tagsClone.put((String)entry.getKey(), (String)entry.getValue());
            }
            clone.tags = tagsClone;
        } else {
            clone.tags = null;
        }
        if (this.extra != null) {
            HashMap<String, Object> extraClone = new HashMap<String, Object>();
            for (Map.Entry entry : this.extra.entrySet()) {
                if (entry == null) continue;
                extraClone.put((String)entry.getKey(), entry.getValue());
            }
            clone.extra = extraClone;
        } else {
            clone.extra = null;
        }
        return clone;
    }
}

