/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.EventProcessor;
import io.sentry.core.ILogger;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryExceptionFactory;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.SentryStackTraceFactory;
import io.sentry.core.SentryThreadFactory;
import io.sentry.core.hints.Cached;
import io.sentry.core.protocol.SentryException;
import io.sentry.core.util.Objects;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class MainEventProcessor
implements EventProcessor {
    private final SentryOptions options;
    private final SentryThreadFactory sentryThreadFactory;
    private final SentryExceptionFactory sentryExceptionFactory;

    MainEventProcessor(SentryOptions options) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        SentryStackTraceFactory sentryStackTraceFactory = new SentryStackTraceFactory(options.getInAppExcludes(), options.getInAppIncludes());
        this.sentryExceptionFactory = new SentryExceptionFactory(sentryStackTraceFactory);
        this.sentryThreadFactory = new SentryThreadFactory(sentryStackTraceFactory);
    }

    MainEventProcessor(SentryOptions options, SentryThreadFactory sentryThreadFactory, SentryExceptionFactory sentryExceptionFactory) {
        this.options = Objects.requireNonNull(options, "The SentryOptions is required.");
        this.sentryThreadFactory = Objects.requireNonNull(sentryThreadFactory, "The SentryThreadFactory is required.");
        this.sentryExceptionFactory = Objects.requireNonNull(sentryExceptionFactory, "The SentryExceptionFactory is required.");
    }

    @Override
    public SentryEvent process(SentryEvent event, @Nullable Object hint) {
        Throwable throwable;
        if (event.getRelease() == null) {
            event.setRelease(this.options.getRelease());
        }
        if (event.getEnvironment() == null) {
            event.setEnvironment(this.options.getEnvironment());
        }
        if (event.getPlatform() == null) {
            event.setPlatform("java");
        }
        if ((throwable = event.getThrowable()) != null) {
            event.setExceptions(this.sentryExceptionFactory.getSentryExceptions(throwable));
        }
        if (event.getThreads() == null) {
            if (!(hint instanceof Cached)) {
                Long crashedThreadId = null;
                List<SentryException> exceptions = event.getExceptions();
                if (event.getExceptions() != null && !exceptions.isEmpty()) {
                    for (SentryException exception : exceptions) {
                        if (exception == null || exception.getMechanism() == null || !Boolean.FALSE.equals(exception.getMechanism().isHandled())) continue;
                        crashedThreadId = exception.getThreadId();
                        break;
                    }
                }
                event.setThreads(this.sentryThreadFactory.getCurrentThreads(crashedThreadId));
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "Event was cached so not applying threads: %s", event.getEventId());
            }
        }
        return event;
    }
}

