/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateUtils {
    private static final String UTC = "UTC";
    private static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private DateUtils() {
    }

    public static String getTimestampIsoFormat(Date date) {
        TimeZone tz = TimeZone.getTimeZone(UTC);
        SimpleDateFormat df = new SimpleDateFormat(ISO_FORMAT, Locale.US);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static Date getCurrentDateTime() {
        String timestampIsoFormat = DateUtils.getTimestampIsoFormat(new Date());
        return DateUtils.getDateTime(timestampIsoFormat);
    }

    public static Date getDateTime(String timestamp) throws IllegalArgumentException {
        SimpleDateFormat df = new SimpleDateFormat(ISO_FORMAT, Locale.US);
        try {
            return df.parse(timestamp);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("timestamp is not ISO format " + timestamp);
        }
    }

    public static String getTimestamp(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(ISO_FORMAT, Locale.US);
        return df.format(date);
    }
}

