/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

import io.sentry.core.ILogger;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.cache.IEventCache;
import io.sentry.core.hints.Cached;
import io.sentry.core.hints.Flushable;
import io.sentry.core.transport.Connection;
import io.sentry.core.transport.IBackOffIntervalStrategy;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.ITransportGate;
import io.sentry.core.transport.NoOpEventCache;
import io.sentry.core.transport.Retryable;
import io.sentry.core.transport.RetryingThreadPoolExecutor;
import io.sentry.core.transport.TransportResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncConnection
implements Closeable,
Connection {
    private final ITransport transport;
    private final ITransportGate transportGate;
    private final ExecutorService executor;
    private final IEventCache eventCache;
    private final SentryOptions options;

    public AsyncConnection(ITransport transport, ITransportGate transportGate, IBackOffIntervalStrategy backOffIntervalStrategy, IEventCache eventCache, int maxRetries, int maxQueueSize, SentryOptions options) {
        this(transport, transportGate, eventCache, AsyncConnection.initExecutor(maxRetries, maxQueueSize, backOffIntervalStrategy, eventCache), options);
    }

    AsyncConnection(ITransport transport, ITransportGate transportGate, IEventCache eventCache, ExecutorService executorService, SentryOptions options) {
        this.transport = transport;
        this.transportGate = transportGate;
        this.eventCache = eventCache;
        this.options = options;
        this.executor = executorService;
    }

    private static RetryingThreadPoolExecutor initExecutor(int maxRetries, int maxQueueSize, IBackOffIntervalStrategy backOffIntervalStrategy, IEventCache eventCache) {
        RejectedExecutionHandler storeEvents = (r, executor) -> {
            if (r instanceof EventSender) {
                eventCache.store(((EventSender)r).event);
            }
        };
        return new RetryingThreadPoolExecutor(1, maxRetries, maxQueueSize, new AsyncConnectionThreadFactory(), backOffIntervalStrategy, storeEvents);
    }

    @Override
    public void send(SentryEvent event, @Nullable Object hint) throws IOException {
        IEventCache currentEventCache = this.eventCache;
        if (hint instanceof Cached) {
            currentEventCache = NoOpEventCache.getInstance();
        }
        this.executor.submit(new EventSender(event, hint, currentEventCache));
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Failed to shutdown the async connection async sender within 1 minute. Trying to force it now.", new Object[0]);
                this.executor.shutdownNow();
            }
            this.transport.close();
        }
        catch (InterruptedException e) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "Thread interrupted while closing the connection.", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    private final class EventSender
    implements Retryable {
        final SentryEvent event;
        private Object hint;
        private IEventCache eventCache;
        long suggestedRetryDelay;

        EventSender(SentryEvent event, Object hint, IEventCache eventCache) {
            this.event = event;
            this.hint = hint;
            this.eventCache = eventCache;
        }

        @Override
        public void run() {
            try {
                this.flush();
            }
            finally {
                if (this.hint instanceof Flushable) {
                    ((Flushable)this.hint).flushed();
                }
            }
        }

        private void flush() {
            if (AsyncConnection.this.transportGate.isSendingAllowed()) {
                try {
                    this.eventCache.store(this.event);
                    TransportResult result = AsyncConnection.this.transport.send(this.event);
                    if (!result.isSuccess()) {
                        this.suggestedRetryDelay = result.getRetryMillis();
                        String message = "The transport failed to send the event with response code " + result.getResponseCode() + ". Retrying in " + this.suggestedRetryDelay + "ms.";
                        if (AsyncConnection.this.options.isDebug()) {
                            AsyncConnection.this.options.getLogger().log(SentryLevel.ERROR, message, new Object[0]);
                        }
                        throw new IllegalStateException(message);
                    }
                    this.eventCache.discard(this.event);
                }
                catch (IOException e) {
                    this.eventCache.store(this.event);
                    if (this.hint instanceof io.sentry.core.hints.Retryable) {
                        ((io.sentry.core.hints.Retryable)this.hint).setRetry(true);
                    }
                    throw new IllegalStateException("Sending the event failed.", e);
                }
            } else {
                this.eventCache.store(this.event);
                if (this.hint instanceof io.sentry.core.hints.Retryable) {
                    ((io.sentry.core.hints.Retryable)this.hint).setRetry(true);
                }
            }
        }

        @Override
        public long getSuggestedRetryDelayMillis() {
            return this.suggestedRetryDelay;
        }
    }

    private static final class AsyncConnectionThreadFactory
    implements ThreadFactory {
        private int cnt;

        private AsyncConnectionThreadFactory() {
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread ret = new Thread(r, "SentryAsyncConnection-" + this.cnt++);
            ret.setDaemon(true);
            return ret;
        }
    }
}

