/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.DiagnosticLogger;
import io.sentry.core.EventProcessor;
import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.Integration;
import io.sentry.core.MainEventProcessor;
import io.sentry.core.NoOpLogger;
import io.sentry.core.SendCachedEventFireAndForgetIntegration;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.UncaughtExceptionHandlerIntegration;
import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryOptions {
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    private List<EventProcessor> eventProcessors = new ArrayList<EventProcessor>();
    private List<Integration> integrations = new ArrayList<Integration>();
    private String dsn;
    private long shutdownTimeoutMills = 5000L;
    private boolean debug;
    private boolean enableNdk = true;
    @NotNull
    private ILogger logger = NoOpLogger.getInstance();
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    private ISerializer serializer;
    private String sentryClientName;
    private BeforeSendCallback beforeSend;
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    private String cacheDirPath;
    private int cacheDirSize = 10;
    private int maxBreadcrumbs = 100;
    private String release;
    private String environment;
    private Proxy proxy;
    private Double sampling;
    private List<String> inAppExcludes = new ArrayList<String>();
    private List<String> inAppIncludes;

    public void addEventProcessor(EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    public List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addIntegration(Integration integration) {
        this.integrations.add(integration);
    }

    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @NotNull
    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable ILogger logger) {
        this.logger = logger == null ? NoOpLogger.getInstance() : new DiagnosticLogger(this, logger);
    }

    public SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public void setDiagnosticLevel(SentryLevel diagnosticLevel) {
        if (diagnosticLevel == null) {
            diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
        }
        this.diagnosticLevel = diagnosticLevel;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public boolean isEnableNdk() {
        return this.enableNdk;
    }

    public void setEnableNdk(boolean enableNdk) {
        this.enableNdk = enableNdk;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeoutMills;
    }

    public void setShutdownTimeout(long shutdownTimeoutMills) {
        this.shutdownTimeoutMills = shutdownTimeoutMills;
    }

    public String getSentryClientName() {
        return this.sentryClientName;
    }

    public void setSentryClientName(String sentryClientName) {
        this.sentryClientName = sentryClientName;
    }

    public BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    public void setBeforeSend(BeforeSendCallback beforeSend) {
        this.beforeSend = beforeSend;
    }

    public BeforeBreadcrumbCallback getBeforeBreadcrumb() {
        return this.beforeBreadcrumb;
    }

    public void setBeforeBreadcrumb(BeforeBreadcrumbCallback beforeBreadcrumb) {
        this.beforeBreadcrumb = beforeBreadcrumb;
    }

    public String getCacheDirPath() {
        return this.cacheDirPath;
    }

    public String getOutboxPath() {
        return this.cacheDirPath + File.separator + "outbox";
    }

    public void setCacheDirPath(String cacheDirPath) {
        this.cacheDirPath = cacheDirPath;
    }

    public int getCacheDirSize() {
        return this.cacheDirSize;
    }

    public void setCacheDirSize(int cacheDirSize) {
        this.cacheDirSize = cacheDirSize;
    }

    public int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        this.maxBreadcrumbs = maxBreadcrumbs;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Double getSampling() {
        return this.sampling;
    }

    public void setSampling(Double sampling) {
        if (sampling != null && (sampling > 1.0 || sampling <= 0.0)) {
            throw new IllegalArgumentException("The value " + sampling + " is not valid. Use null to disable or values between 0.01 (inclusive) and 1.0 (exclusive).");
        }
        this.sampling = sampling;
    }

    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public void addInAppExclude(String exclude) {
        if (this.inAppExcludes == null) {
            this.inAppExcludes = new ArrayList<String>();
        }
        this.inAppExcludes.add(exclude);
    }

    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public void addInAppInclude(String include) {
        if (this.inAppIncludes == null) {
            this.inAppIncludes = new ArrayList<String>();
        }
        this.inAppIncludes.add(include);
    }

    public SentryOptions() {
        this.inAppExcludes.add("io.sentry.");
        this.inAppExcludes.add("java.");
        this.inAppExcludes.add("javax.");
        this.inAppExcludes.add("sun.");
        this.inAppExcludes.add("com.oracle.");
        this.inAppExcludes.add("oracle.");
        this.inAppExcludes.add("org.jetbrains.");
        this.eventProcessors.add(new MainEventProcessor(this));
        this.integrations.add(new SendCachedEventFireAndForgetIntegration());
        this.integrations.add(new UncaughtExceptionHandlerIntegration());
    }

    public static interface BeforeBreadcrumbCallback {
        public Breadcrumb execute(Breadcrumb var1, @Nullable Object var2);
    }

    public static interface BeforeSendCallback {
        public SentryEvent execute(SentryEvent var1, @Nullable Object var2);
    }
}

