/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose.gestures;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.compose.SentryComposeHelper;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import io.sentry.util.AutoClosableReentrantLock;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposeGestureTargetLocator
implements GestureTargetLocator {
    private static final String ORIGIN = "jetpack_compose";
    @NotNull
    private final ILogger logger;
    @Nullable
    private volatile SentryComposeHelper composeHelper;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    public ComposeGestureTargetLocator(@NotNull ILogger logger) {
        this.logger = logger;
        SentryIntegrationPackageStorage.getInstance().addIntegration("ComposeUserInteraction");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-compose", "8.2.0");
    }

    @Nullable
    public UiElement locate(@Nullable Object root, float x, float y, UiElement.Type targetType) {
        if (this.composeHelper == null) {
            try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
                if (this.composeHelper == null) {
                    this.composeHelper = new SentryComposeHelper(this.logger);
                }
            }
        }
        if (!(root instanceof Owner)) {
            return null;
        }
        @NotNull LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
        queue.add(((Owner)root).getRoot());
        String targetTag = null;
        String lastKnownTag = null;
        while (!queue.isEmpty()) {
            @Nullable LayoutNode node = (LayoutNode)queue.poll();
            if (node == null) continue;
            if (node.isPlaced() && ComposeGestureTargetLocator.layoutNodeBoundsContain(this.composeHelper, node, x, y)) {
                boolean isClickable = false;
                boolean isScrollable = false;
                List modifiers = node.getModifierInfo();
                for (ModifierInfo modifierInfo : modifiers) {
                    if (modifierInfo.getModifier() instanceof SemanticsModifier) {
                        SemanticsModifier semanticsModifierCore = (SemanticsModifier)modifierInfo.getModifier();
                        SemanticsConfiguration semanticsConfiguration = semanticsModifierCore.getSemanticsConfiguration();
                        for (Map.Entry entry : semanticsConfiguration) {
                            @Nullable String key = ((SemanticsPropertyKey)entry.getKey()).getName();
                            if ("ScrollBy".equals(key)) {
                                isScrollable = true;
                                continue;
                            }
                            if ("OnClick".equals(key)) {
                                isClickable = true;
                                continue;
                            }
                            if (!"SentryTag".equals(key) && !"TestTag".equals(key) || !(entry.getValue() instanceof String)) continue;
                            lastKnownTag = (String)entry.getValue();
                        }
                        continue;
                    }
                    @NotNull Modifier modifier = modifierInfo.getModifier();
                    @Nullable String type = modifier.getClass().getCanonicalName();
                    if ("androidx.compose.foundation.ClickableElement".equals(type) || "androidx.compose.foundation.CombinedClickableElement".equals(type)) {
                        isClickable = true;
                        continue;
                    }
                    if ("androidx.compose.foundation.ScrollingLayoutElement".equals(type)) {
                        isScrollable = true;
                        continue;
                    }
                    if (!"androidx.compose.ui.platform.TestTagElement".equals(type)) continue;
                    try {
                        Field tagField = modifier.getClass().getDeclaredField("tag");
                        tagField.setAccessible(true);
                        @Nullable Object value = tagField.get(modifier);
                        if (!(value instanceof String)) continue;
                        lastKnownTag = (String)value;
                    }
                    catch (Throwable throwable) {
                    }
                }
                if (isClickable && targetType == UiElement.Type.CLICKABLE) {
                    targetTag = lastKnownTag;
                }
                if (isScrollable && targetType == UiElement.Type.SCROLLABLE) {
                    targetTag = lastKnownTag;
                    break;
                }
            }
            queue.addAll(node.getZSortedChildren().asMutableList());
        }
        if (targetTag == null) {
            return null;
        }
        return new UiElement(null, null, null, targetTag, ORIGIN);
    }

    private static boolean layoutNodeBoundsContain(@NotNull SentryComposeHelper composeHelper, @NotNull LayoutNode node, float x, float y) {
        @Nullable Rect bounds = composeHelper.getLayoutNodeBoundsInWindow(node);
        if (bounds == null) {
            return false;
        }
        return x >= bounds.getLeft() && x <= bounds.getRight() && y >= bounds.getTop() && y <= bounds.getBottom();
    }
}

