/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose.viewhierarchy;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.compose.SentryComposeHelper;
import io.sentry.internal.viewhierarchy.ViewHierarchyExporter;
import io.sentry.protocol.ViewHierarchyNode;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/sentry/compose/viewhierarchy/ComposeViewHierarchyExporter;", "Lio/sentry/internal/viewhierarchy/ViewHierarchyExporter;", "logger", "Lio/sentry/ILogger;", "(Lio/sentry/ILogger;)V", "composeHelper", "Lio/sentry/compose/SentryComposeHelper;", "lock", "Lio/sentry/util/AutoClosableReentrantLock;", "addChild", "", "parent", "Lio/sentry/protocol/ViewHierarchyNode;", "rootNode", "Landroidx/compose/ui/node/LayoutNode;", "node", "export", "", "element", "", "setBounds", "vhNode", "setTag", "helper", "sentry-compose_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposeViewHierarchyExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeViewHierarchyExporter.kt\nio/sentry/compose/viewhierarchy/ComposeViewHierarchyExporter\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,85:1\n523#2:86\n*S KotlinDebug\n*F\n+ 1 ComposeViewHierarchyExporter.kt\nio/sentry/compose/viewhierarchy/ComposeViewHierarchyExporter\n*L\n58#1:86\n*E\n"})
public final class ComposeViewHierarchyExporter
implements ViewHierarchyExporter {
    @NotNull
    private final ILogger logger;
    @Nullable
    private volatile SentryComposeHelper composeHelper;
    @NotNull
    private final AutoClosableReentrantLock lock;
    public static final int $stable = 8;

    public ComposeViewHierarchyExporter(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.lock = new AutoClosableReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(@NotNull ViewHierarchyNode parent, @NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof Owner)) {
            return false;
        }
        if (this.composeHelper == null) {
            AutoCloseable autoCloseable = (AutoCloseable)this.lock.acquire();
            Throwable throwable = null;
            try {
                ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                boolean bl = false;
                if (this.composeHelper == null) {
                    this.composeHelper = new SentryComposeHelper(this.logger);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        LayoutNode rootNode = ((Owner)element).getRoot();
        SentryComposeHelper sentryComposeHelper = this.composeHelper;
        Intrinsics.checkNotNull((Object)sentryComposeHelper);
        this.addChild(sentryComposeHelper, parent, rootNode, rootNode);
        return true;
    }

    private final void addChild(SentryComposeHelper composeHelper, ViewHierarchyNode parent, LayoutNode rootNode, LayoutNode node) {
        if (node.isPlaced()) {
            ViewHierarchyNode vhNode = new ViewHierarchyNode();
            this.setTag(composeHelper, node, vhNode);
            this.setBounds(node, vhNode);
            String string = vhNode.getTag();
            if (string == null) {
                string = "@Composable";
            }
            vhNode.setType(string);
            if (parent.getChildren() == null) {
                parent.setChildren((List)new ArrayList());
            }
            List list = parent.getChildren();
            Intrinsics.checkNotNull((Object)list);
            list.add(vhNode);
            MutableVector children = node.getZSortedChildren();
            int childrenCount = children.getSize();
            for (int i = 0; i < childrenCount; ++i) {
                MutableVector this_$iv = children;
                boolean $i$f$get = false;
                LayoutNode child = (LayoutNode)this_$iv.getContent()[i];
                this.addChild(composeHelper, vhNode, rootNode, child);
            }
        }
    }

    private final void setTag(SentryComposeHelper helper, LayoutNode node, ViewHierarchyNode vhNode) {
        List modifiers = node.getModifierInfo();
        for (ModifierInfo modifierInfo : modifiers) {
            String tag = helper.extractTag(modifierInfo.getModifier());
            if (tag == null) continue;
            vhNode.setTag(tag);
        }
    }

    private final void setBounds(LayoutNode node, ViewHierarchyNode vhNode) {
        Rect bounds = LayoutCoordinatesKt.boundsInParent((LayoutCoordinates)node.getCoordinates());
        vhNode.setX(Double.valueOf(bounds.getLeft()));
        vhNode.setY(Double.valueOf(bounds.getTop()));
        vhNode.setHeight(Double.valueOf(bounds.getHeight()));
        vhNode.setWidth(Double.valueOf(bounds.getWidth()));
    }
}

