/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.timber;

import io.sentry.Breadcrumb;
import io.sentry.IScopes;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryLogLevel;
import io.sentry.logger.SentryLogParameters;
import io.sentry.protocol.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002JA\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J,\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J/\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J9\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010 J/\u0010!\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010!\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J9\u0010!\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J/\u0010&\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010&\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J9\u0010&\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0002J7\u0010+\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010,J,\u0010+\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0014J\u001a\u0010+\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016JA\u0010+\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010-JA\u0010.\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010-J\n\u0010/\u001a\u0004\u0018\u00010\fH\u0002J/\u00100\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u00100\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J9\u00100\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010 J/\u00101\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u00101\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J9\u00101\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010 J/\u00102\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u00102\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J9\u00102\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/sentry/android/timber/SentryTimberTree;", "Ltimber/log/Timber$Tree;", "scopes", "Lio/sentry/IScopes;", "minEventLevel", "Lio/sentry/SentryLevel;", "minBreadcrumbLevel", "minLogLevel", "Lio/sentry/SentryLogLevel;", "(Lio/sentry/IScopes;Lio/sentry/SentryLevel;Lio/sentry/SentryLevel;Lio/sentry/SentryLogLevel;)V", "pendingTag", "Ljava/lang/ThreadLocal;", "", "addBreadcrumb", "", "sentryLevel", "msg", "Lio/sentry/protocol/Message;", "throwable", "", "addLog", "sentryLogLevel", "args", "", "", "(Lio/sentry/SentryLogLevel;Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "captureEvent", "tag", "d", "message", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "getSentryLevel", "priority", "", "getSentryLogLevel", "i", "isLoggable", "", "level", "minLevel", "log", "(ILjava/lang/String;[Ljava/lang/Object;)V", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "logWithSentry", "retrieveTag", "v", "w", "wtf", "sentry-android-timber_release"})
@SourceDebugExtension(value={"SMAP\nSentryTimberTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryTimberTree.kt\nio/sentry/android/timber/SentryTimberTree\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n11065#2:287\n11400#2,3:288\n1#3:291\n*S KotlinDebug\n*F\n+ 1 SentryTimberTree.kt\nio/sentry/android/timber/SentryTimberTree\n*L\n181#1:287\n181#1:288,3\n*E\n"})
public final class SentryTimberTree
extends Timber.Tree {
    @NotNull
    private final IScopes scopes;
    @NotNull
    private final SentryLevel minEventLevel;
    @NotNull
    private final SentryLevel minBreadcrumbLevel;
    @NotNull
    private final SentryLogLevel minLogLevel;
    @NotNull
    private final ThreadLocal<String> pendingTag;

    public SentryTimberTree(@NotNull IScopes scopes, @NotNull SentryLevel minEventLevel, @NotNull SentryLevel minBreadcrumbLevel, @NotNull SentryLogLevel minLogLevel) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)minEventLevel, (String)"minEventLevel");
        Intrinsics.checkNotNullParameter((Object)minBreadcrumbLevel, (String)"minBreadcrumbLevel");
        Intrinsics.checkNotNullParameter((Object)minLogLevel, (String)"minLogLevel");
        this.scopes = scopes;
        this.minEventLevel = minEventLevel;
        this.minBreadcrumbLevel = minBreadcrumbLevel;
        this.minLogLevel = minLogLevel;
        this.pendingTag = new ThreadLocal();
    }

    public /* synthetic */ SentryTimberTree(IScopes iScopes, SentryLevel sentryLevel, SentryLevel sentryLevel2, SentryLogLevel sentryLogLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sentryLogLevel = SentryLogLevel.INFO;
        }
        this(iScopes, sentryLevel, sentryLevel2, sentryLogLevel);
    }

    private final String retrieveTag() {
        String tag = this.pendingTag.get();
        if (tag != null) {
            this.pendingTag.remove();
        }
        return tag;
    }

    public void v(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.v(message, Arrays.copyOf(args, args.length));
        this.logWithSentry(2, null, message, Arrays.copyOf(args, args.length));
    }

    public void v(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.v(t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(2, t, message, Arrays.copyOf(args, args.length));
    }

    public void v(@Nullable Throwable t) {
        super.v(t);
        this.logWithSentry(2, t, null, new Object[0]);
    }

    public void d(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.d(message, Arrays.copyOf(args, args.length));
        this.logWithSentry(3, null, message, Arrays.copyOf(args, args.length));
    }

    public void d(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.d(t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(3, t, message, Arrays.copyOf(args, args.length));
    }

    public void d(@Nullable Throwable t) {
        super.d(t);
        this.logWithSentry(3, t, null, new Object[0]);
    }

    public void i(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.d(message, Arrays.copyOf(args, args.length));
        this.logWithSentry(4, null, message, Arrays.copyOf(args, args.length));
    }

    public void i(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.i(t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(4, t, message, Arrays.copyOf(args, args.length));
    }

    public void i(@Nullable Throwable t) {
        super.i(t);
        this.logWithSentry(4, t, null, new Object[0]);
    }

    public void w(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.w(message, Arrays.copyOf(args, args.length));
        this.logWithSentry(5, null, message, Arrays.copyOf(args, args.length));
    }

    public void w(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.w(t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(5, t, message, Arrays.copyOf(args, args.length));
    }

    public void w(@Nullable Throwable t) {
        super.w(t);
        this.logWithSentry(5, t, null, new Object[0]);
    }

    public void e(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.e(message, Arrays.copyOf(args, args.length));
        this.logWithSentry(6, null, message, Arrays.copyOf(args, args.length));
    }

    public void e(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.e(t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(6, t, message, Arrays.copyOf(args, args.length));
    }

    public void e(@Nullable Throwable t) {
        super.e(t);
        this.logWithSentry(6, t, null, new Object[0]);
    }

    public void wtf(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.wtf(message, Arrays.copyOf(args, args.length));
        this.logWithSentry(7, null, message, Arrays.copyOf(args, args.length));
    }

    public void wtf(@Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.wtf(t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(7, t, message, Arrays.copyOf(args, args.length));
    }

    public void wtf(@Nullable Throwable t) {
        super.wtf(t);
        this.logWithSentry(7, t, null, new Object[0]);
    }

    public void log(int priority, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.log(priority, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(priority, null, message, Arrays.copyOf(args, args.length));
    }

    public void log(int priority, @Nullable Throwable t, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super.log(priority, t, message, Arrays.copyOf(args, args.length));
        this.logWithSentry(priority, t, message, Arrays.copyOf(args, args.length));
    }

    public void log(int priority, @Nullable Throwable t) {
        super.log(priority, t);
        this.logWithSentry(priority, t, null, new Object[0]);
    }

    protected void log(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.pendingTag.set(tag);
    }

    /*
     * WARNING - void declaration
     */
    private final void logWithSentry(int priority, Throwable throwable, String message, Object ... args) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Message message2;
        String tag = this.retrieveTag();
        CharSequence charSequence = message;
        if ((charSequence == null || charSequence.length() == 0) && throwable == null) {
            return;
        }
        SentryLevel level = this.getSentryLevel(priority);
        SentryLogLevel logLevel = this.getSentryLogLevel(priority);
        Message $this$logWithSentry_u24lambda_u241 = message2 = new Message();
        boolean bl = false;
        $this$logWithSentry_u24lambda_u241.setMessage(message);
        Object[] objectArray = (Object[])message;
        if (!(objectArray == null || objectArray.length() == 0) && !(args.length == 0)) {
            Object[] objectArray2 = Arrays.copyOf(args, args.length);
            String string = String.format(message, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            $this$logWithSentry_u24lambda_u241.setFormatted(string);
        }
        objectArray = args;
        Message message3 = $this$logWithSentry_u24lambda_u241;
        boolean $i$f$map = false;
        void var15_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var21_20 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(String.valueOf(it));
        }
        message3.setParams((List)destination$iv$iv);
        Message sentryMessage = message2;
        this.captureEvent(level, tag, sentryMessage, throwable);
        this.addBreadcrumb(level, sentryMessage, throwable);
        this.addLog(logLevel, message, throwable, Arrays.copyOf(args, args.length));
    }

    private final boolean isLoggable(SentryLevel level, SentryLevel minLevel) {
        return level.ordinal() >= minLevel.ordinal();
    }

    private final boolean isLoggable(SentryLogLevel level, SentryLogLevel minLevel) {
        return level.ordinal() >= minLevel.ordinal();
    }

    private final void captureEvent(SentryLevel sentryLevel, String tag, Message msg, Throwable throwable) {
        if (this.isLoggable(sentryLevel, this.minEventLevel)) {
            Object it;
            SentryEvent sentryEvent;
            SentryEvent $this$captureEvent_u24lambda_u244 = sentryEvent = new SentryEvent();
            boolean bl = false;
            $this$captureEvent_u24lambda_u244.setLevel(sentryLevel);
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                it = throwable2;
                boolean bl2 = false;
                $this$captureEvent_u24lambda_u244.setThrowable((Throwable)it);
            }
            String string = tag;
            if (string != null) {
                it = string;
                boolean bl3 = false;
                $this$captureEvent_u24lambda_u244.setTag("TimberTag", (String)it);
            }
            $this$captureEvent_u24lambda_u244.setMessage(msg);
            $this$captureEvent_u24lambda_u244.setLogger("Timber");
            SentryEvent sentryEvent2 = sentryEvent;
            this.scopes.captureEvent(sentryEvent2);
        }
    }

    private final void addBreadcrumb(SentryLevel sentryLevel, Message msg, Throwable throwable) {
        block6: {
            Breadcrumb breadCrumb;
            Breadcrumb breadcrumb;
            Breadcrumb breadcrumb2;
            if (!this.isLoggable(sentryLevel, this.minBreadcrumbLevel)) break block6;
            Throwable throwable2 = throwable;
            String throwableMsg = throwable2 != null ? throwable2.getMessage() : null;
            if (msg.getMessage() != null) {
                Breadcrumb $this$addBreadcrumb_u24lambda_u245 = breadcrumb2 = new Breadcrumb();
                boolean bl = false;
                $this$addBreadcrumb_u24lambda_u245.setLevel(sentryLevel);
                $this$addBreadcrumb_u24lambda_u245.setCategory("Timber");
                String string = msg.getFormatted();
                if (string == null) {
                    string = msg.getMessage();
                }
                $this$addBreadcrumb_u24lambda_u245.setMessage(string);
                breadcrumb = breadcrumb2;
            } else {
                String string = throwableMsg;
                if (string != null) {
                    Breadcrumb $this$addBreadcrumb_u24lambda_u246 = breadcrumb2 = Breadcrumb.error((String)string);
                    boolean bl = false;
                    $this$addBreadcrumb_u24lambda_u246.setCategory("exception");
                    breadcrumb = breadcrumb2;
                } else {
                    breadcrumb = null;
                }
            }
            Breadcrumb breadcrumb3 = breadCrumb = breadcrumb;
            if (breadcrumb3 != null) {
                Breadcrumb it = breadcrumb3;
                boolean bl = false;
                this.scopes.addBreadcrumb(it);
            }
        }
    }

    private final void addLog(SentryLogLevel sentryLogLevel, String msg, Throwable throwable, Object ... args) {
        if (this.isLoggable(sentryLogLevel, this.minLogLevel)) {
            SentryLogParameters params = new SentryLogParameters();
            params.setOrigin("auto.log.timber");
            Throwable throwable2 = throwable;
            String throwableMsg = throwable2 != null ? throwable2.getMessage() : null;
            if (msg != null && throwableMsg != null) {
                this.scopes.logger().log(sentryLogLevel, params, msg + '\n' + throwableMsg, Arrays.copyOf(args, args.length));
            } else if (msg != null) {
                this.scopes.logger().log(sentryLogLevel, params, msg, Arrays.copyOf(args, args.length));
            } else if (throwableMsg != null) {
                this.scopes.logger().log(sentryLogLevel, params, throwableMsg, Arrays.copyOf(args, args.length));
            }
        }
    }

    private final SentryLevel getSentryLevel(int priority) {
        SentryLevel sentryLevel;
        switch (priority) {
            case 7: {
                sentryLevel = SentryLevel.FATAL;
                break;
            }
            case 6: {
                sentryLevel = SentryLevel.ERROR;
                break;
            }
            case 5: {
                sentryLevel = SentryLevel.WARNING;
                break;
            }
            case 4: {
                sentryLevel = SentryLevel.INFO;
                break;
            }
            case 3: {
                sentryLevel = SentryLevel.DEBUG;
                break;
            }
            case 2: {
                sentryLevel = SentryLevel.DEBUG;
                break;
            }
            default: {
                sentryLevel = SentryLevel.DEBUG;
            }
        }
        return sentryLevel;
    }

    private final SentryLogLevel getSentryLogLevel(int priority) {
        SentryLogLevel sentryLogLevel;
        switch (priority) {
            case 7: {
                sentryLogLevel = SentryLogLevel.FATAL;
                break;
            }
            case 6: {
                sentryLogLevel = SentryLogLevel.ERROR;
                break;
            }
            case 5: {
                sentryLogLevel = SentryLogLevel.WARN;
                break;
            }
            case 4: {
                sentryLogLevel = SentryLogLevel.INFO;
                break;
            }
            case 3: {
                sentryLogLevel = SentryLogLevel.DEBUG;
                break;
            }
            case 2: {
                sentryLogLevel = SentryLogLevel.TRACE;
                break;
            }
            default: {
                sentryLogLevel = SentryLogLevel.DEBUG;
            }
        }
        return sentryLogLevel;
    }
}

