/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.util;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/sentry/android/replay/util/DebugOverlayDrawable;", "Landroid/graphics/drawable/Drawable;", "()V", "masks", "", "Landroid/graphics/Rect;", "padding", "", "paint", "Landroid/graphics/Paint;", "tmpRect", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawTextWithOutline", "bottomRightLabel", "", "x", "y", "getOpacity", "", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "updateMasks", "Companion", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
public final class DebugOverlayDrawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint paint = new Paint(1);
    private final float padding;
    @NotNull
    private final Rect tmpRect = new Rect();
    @NotNull
    private List<Rect> masks = CollectionsKt.emptyList();
    public static final int $stable = 8;
    private static final int maskBackgroundColor = Color.argb((int)32, (int)255, (int)20, (int)20);
    private static final int maskBorderColor = Color.argb((int)128, (int)255, (int)20, (int)20);
    private static final int TEXT_COLOR = -16777216;
    private static final int TEXT_OUTLINE_COLOR = -1;
    private static final float STROKE_WIDTH = 6.0f;
    private static final float TEXT_SIZE = 32.0f;

    public DebugOverlayDrawable() {
        this.padding = 6.0f;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.paint.setTextSize(32.0f);
        this.paint.setColor(-16777216);
        this.paint.setStrokeWidth(6.0f);
        for (Rect mask : this.masks) {
            this.paint.setColor(maskBackgroundColor);
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(mask, this.paint);
            this.paint.setColor(maskBorderColor);
            this.paint.setStyle(Paint.Style.STROKE);
            canvas.drawRect(mask, this.paint);
            String topLeftLabel = "" + mask.left + '/' + mask.top;
            this.paint.getTextBounds(topLeftLabel, 0, topLeftLabel.length(), this.tmpRect);
            this.drawTextWithOutline(canvas, topLeftLabel, mask.left, mask.top);
            String bottomRightLabel = "" + mask.right + '/' + mask.bottom;
            this.paint.getTextBounds(bottomRightLabel, 0, bottomRightLabel.length(), this.tmpRect);
            this.drawTextWithOutline(canvas, bottomRightLabel, (float)mask.right - (float)this.tmpRect.width(), (float)mask.bottom + (float)this.tmpRect.height());
        }
    }

    private final void drawTextWithOutline(Canvas canvas, String bottomRightLabel, float x, float y) {
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.STROKE);
        canvas.drawText(bottomRightLabel, x, y, this.paint);
        this.paint.setColor(-16777216);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawText(bottomRightLabel, x, y, this.paint);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        return -3;
    }

    public final void updateMasks(@NotNull List<Rect> masks) {
        Intrinsics.checkNotNullParameter(masks, (String)"masks");
        this.masks = masks;
        this.invalidateSelf();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/sentry/android/replay/util/DebugOverlayDrawable$Companion;", "", "()V", "STROKE_WIDTH", "", "TEXT_COLOR", "", "TEXT_OUTLINE_COLOR", "TEXT_SIZE", "maskBackgroundColor", "maskBorderColor", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

