/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.util;

import android.text.Layout;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.android.replay.util.TextLayout;
import io.sentry.android.replay.util.ViewsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/sentry/android/replay/util/AndroidTextLayout;", "Lio/sentry/android/replay/util/TextLayout;", "layout", "Landroid/text/Layout;", "(Landroid/text/Layout;)V", "dominantTextColor", "", "getDominantTextColor", "()Ljava/lang/Integer;", "lineCount", "getLineCount", "()I", "getEllipsisCount", "line", "getLineBottom", "getLineStart", "getLineTop", "getLineVisibleEnd", "getPrimaryHorizontal", "", "offset", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
public final class AndroidTextLayout
implements TextLayout {
    @NotNull
    private final Layout layout;
    public static final int $stable = 8;

    public AndroidTextLayout(@NotNull Layout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.layout = layout;
    }

    @Override
    public int getLineCount() {
        return this.layout.getLineCount();
    }

    @Override
    @Nullable
    public Integer getDominantTextColor() {
        if (!(this.layout.getText() instanceof Spanned)) {
            return null;
        }
        CharSequence charSequence = this.layout.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        ForegroundColorSpan[] spans = (ForegroundColorSpan[])((Spanned)charSequence).getSpans(0, this.layout.getText().length(), ForegroundColorSpan.class);
        int longestSpan = Integer.MIN_VALUE;
        Integer dominantColor = null;
        Intrinsics.checkNotNull((Object)spans);
        for (ForegroundColorSpan span : spans) {
            int spanLength;
            CharSequence charSequence2 = this.layout.getText();
            Intrinsics.checkNotNull((Object)charSequence2, (String)"null cannot be cast to non-null type android.text.Spanned");
            int spanStart = ((Spanned)charSequence2).getSpanStart((Object)span);
            CharSequence charSequence3 = this.layout.getText();
            Intrinsics.checkNotNull((Object)charSequence3, (String)"null cannot be cast to non-null type android.text.Spanned");
            int spanEnd = ((Spanned)charSequence3).getSpanEnd((Object)span);
            if (spanStart == -1 || spanEnd == -1 || (spanLength = spanEnd - spanStart) <= longestSpan) continue;
            longestSpan = spanLength;
            dominantColor = span.getForegroundColor();
        }
        Integer n = dominantColor;
        return n != null ? Integer.valueOf(ViewsKt.toOpaque(n)) : null;
    }

    @Override
    public float getPrimaryHorizontal(int line, int offset) {
        return this.layout.getPrimaryHorizontal(offset);
    }

    @Override
    public int getEllipsisCount(int line) {
        return this.layout.getEllipsisCount(line);
    }

    @Override
    public int getLineVisibleEnd(int line) {
        return this.layout.getLineVisibleEnd(line);
    }

    @Override
    public int getLineTop(int line) {
        return this.layout.getLineTop(line);
    }

    @Override
    public int getLineBottom(int line) {
        return this.layout.getLineBottom(line);
    }

    @Override
    public int getLineStart(int line) {
        return this.layout.getLineStart(line);
    }
}

