/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.DateUtils;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ReplayRecording;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.GeneratedVideo;
import io.sentry.android.replay.LastSegmentData;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayFrame;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.video.MuxerConfig;
import io.sentry.android.replay.video.SimpleVideoEncoder;
import io.sentry.protocol.SentryId;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b'J\"\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0015J\b\u0010)\u001a\u00020!H\u0016JJ\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020/2\b\b\u0002\u00104\u001a\u00020\u0018J\u0010\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u0018H\u0002J\u0012\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\rH\u0002J\u001f\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\u00152\b\u0010<\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b=J\u0017\u0010>\u001a\u0004\u0018\u00010\u00152\u0006\u0010?\u001a\u00020%H\u0000\u00a2\u0006\u0002\b@R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00188@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lio/sentry/android/replay/ReplayCache;", "Ljava/io/Closeable;", "options", "Lio/sentry/SentryOptions;", "replayId", "Lio/sentry/protocol/SentryId;", "(Lio/sentry/SentryOptions;Lio/sentry/protocol/SentryId;)V", "encoder", "Lio/sentry/android/replay/video/SimpleVideoEncoder;", "encoderLock", "Lio/sentry/util/AutoClosableReentrantLock;", "frames", "", "Lio/sentry/android/replay/ReplayFrame;", "getFrames$sentry_android_replay_release", "()Ljava/util/List;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "ongoingSegment", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "ongoingSegmentFile", "Ljava/io/File;", "getOngoingSegmentFile$sentry_android_replay_release", "()Ljava/io/File;", "ongoingSegmentFile$delegate", "Lkotlin/Lazy;", "replayCacheDir", "getReplayCacheDir$sentry_android_replay_release", "replayCacheDir$delegate", "addFrame", "", "bitmap", "Landroid/graphics/Bitmap;", "frameTimestamp", "", "screen", "addFrame$sentry_android_replay_release", "screenshot", "close", "createVideoOf", "Lio/sentry/android/replay/GeneratedVideo;", "duration", "from", "segmentId", "", "height", "width", "frameRate", "bitRate", "videoFile", "deleteFile", "file", "encode", "", "frame", "persistSegmentValues", "key", "value", "persistSegmentValues$sentry_android_replay_release", "rotate", "until", "rotate$sentry_android_replay_release", "Companion", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReplayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,456:1\n1#2:457\n1#2:463\n284#3,5:458\n747#4,4:464\n*S KotlinDebug\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache\n*L\n273#1:463\n273#1:458,5\n274#1:464,4\n*E\n"})
public final class ReplayCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryId replayId;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final AutoClosableReentrantLock encoderLock;
    @NotNull
    private final AutoClosableReentrantLock lock;
    @Nullable
    private SimpleVideoEncoder encoder;
    @NotNull
    private final Lazy replayCacheDir$delegate;
    @NotNull
    private final List<ReplayFrame> frames;
    @NotNull
    private final LinkedHashMap<String, String> ongoingSegment;
    @NotNull
    private final Lazy ongoingSegmentFile$delegate;
    public static final int $stable = 8;
    @NotNull
    public static final String ONGOING_SEGMENT = ".ongoing_segment";
    @NotNull
    public static final String SEGMENT_KEY_HEIGHT = "config.height";
    @NotNull
    public static final String SEGMENT_KEY_WIDTH = "config.width";
    @NotNull
    public static final String SEGMENT_KEY_FRAME_RATE = "config.frame-rate";
    @NotNull
    public static final String SEGMENT_KEY_BIT_RATE = "config.bit-rate";
    @NotNull
    public static final String SEGMENT_KEY_TIMESTAMP = "segment.timestamp";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_ID = "replay.id";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_TYPE = "replay.type";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_SCREEN_AT_START = "replay.screen-at-start";
    @NotNull
    public static final String SEGMENT_KEY_REPLAY_RECORDING = "replay.recording";
    @NotNull
    public static final String SEGMENT_KEY_ID = "segment.id";

    public ReplayCache(@NotNull SentryOptions options, @NotNull SentryId replayId) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        this.options = options;
        this.replayId = replayId;
        this.isClosed = new AtomicBoolean(false);
        this.encoderLock = new AutoClosableReentrantLock();
        this.lock = new AutoClosableReentrantLock();
        this.replayCacheDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ReplayCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                return ReplayCache.Companion.makeReplayCacheDir(ReplayCache.access$getOptions$p(this.this$0), ReplayCache.access$getReplayId$p(this.this$0));
            }
        }));
        this.frames = new ArrayList();
        this.ongoingSegment = new LinkedHashMap();
        this.ongoingSegmentFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ReplayCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                if (this.this$0.getReplayCacheDir$sentry_android_replay_release() == null) {
                    return null;
                }
                File file = new File(this.this$0.getReplayCacheDir$sentry_android_replay_release(), ".ongoing_segment");
                if (!file.exists()) {
                    file.createNewFile();
                }
                return file;
            }
        }));
    }

    @Nullable
    public final File getReplayCacheDir$sentry_android_replay_release() {
        Lazy lazy = this.replayCacheDir$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final List<ReplayFrame> getFrames$sentry_android_replay_release() {
        return this.frames;
    }

    @Nullable
    public final File getOngoingSegmentFile$sentry_android_replay_release() {
        Lazy lazy = this.ongoingSegmentFile$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFrame$sentry_android_replay_release(@NotNull Bitmap bitmap, long frameTimestamp, @Nullable String screen) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.getReplayCacheDir$sentry_android_replay_release() == null || bitmap.isRecycled()) {
            return;
        }
        File file = this.getReplayCacheDir$sentry_android_replay_release();
        if (file != null) {
            file.mkdirs();
        }
        Object object = new File(this.getReplayCacheDir$sentry_android_replay_release(), frameTimestamp + ".jpg");
        File it = object;
        boolean bl = false;
        it.createNewFile();
        File screenshot = object;
        object = new FileOutputStream(screenshot);
        Throwable throwable = null;
        try {
            FileOutputStream it2 = (FileOutputStream)object;
            boolean bl2 = false;
            bitmap.compress(Bitmap.CompressFormat.JPEG, this.options.getSessionReplay().getQuality().screenshotQuality, (OutputStream)it2);
            it2.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this.addFrame(screenshot, frameTimestamp, screen);
    }

    public static /* synthetic */ void addFrame$sentry_android_replay_release$default(ReplayCache replayCache, Bitmap bitmap, long l, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        replayCache.addFrame$sentry_android_replay_release(bitmap, l, string);
    }

    public final void addFrame(@NotNull File screenshot, long frameTimestamp, @Nullable String screen) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        ReplayFrame frame = new ReplayFrame(screenshot, frameTimestamp, screen);
        ((Collection)this.frames).add(frame);
    }

    public static /* synthetic */ void addFrame$default(ReplayCache replayCache, File file, long l, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        replayCache.addFrame(file, l, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final GeneratedVideo createVideoOf(long duration, long from, int segmentId, int height, int width, int frameRate, int bitRate, @NotNull File videoFile) {
        SimpleVideoEncoder simpleVideoEncoder;
        Object it;
        Intrinsics.checkNotNullParameter((Object)videoFile, (String)"videoFile");
        if (videoFile.exists() && videoFile.length() > 0L) {
            videoFile.delete();
        }
        if (this.frames.isEmpty()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "No captured frames, skipping generating a video segment", new Object[0]);
            return null;
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.encoderLock.acquire();
        ReplayCache replayCache = this;
        Throwable throwable = null;
        try {
            it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            SimpleVideoEncoder it2 = simpleVideoEncoder = new SimpleVideoEncoder(this.options, new MuxerConfig(videoFile, width, height, frameRate, bitRate, null, 32, null), null, 4, null);
            boolean bl2 = false;
            it2.start();
            it = simpleVideoEncoder;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        replayCache.encoder = it;
        long step = (long)1000 / (long)frameRate;
        int frameCount = 0;
        ReplayFrame lastFrame = (ReplayFrame)CollectionsKt.first(this.frames);
        simpleVideoEncoder = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)from, (long)(from + duration))), (long)step);
        long timestamp = simpleVideoEncoder.getFirst();
        long l = simpleVideoEncoder.getLast();
        long l2 = simpleVideoEncoder.getStep();
        if (l2 > 0L && timestamp <= l || l2 < 0L && l <= timestamp) {
            while (true) {
                for (ReplayFrame frame : this.frames) {
                    long l3 = timestamp + step;
                    long l4 = frame.getTimestamp();
                    boolean bl = timestamp <= l4 ? l4 <= l3 : false;
                    if (bl) {
                        lastFrame = frame;
                        break;
                    }
                    if (frame.getTimestamp() <= timestamp + step) continue;
                }
                if (this.encode(lastFrame)) {
                    ++frameCount;
                } else if (lastFrame != null) {
                    this.deleteFile(lastFrame.getScreenshot());
                    this.frames.remove(lastFrame);
                    lastFrame = null;
                }
                if (timestamp == l) break;
                timestamp += l2;
            }
        }
        if (frameCount == 0) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Generated a video with no frames, not capturing a replay segment", new Object[0]);
            this.deleteFile(videoFile);
            return null;
        }
        long videoDuration = 0L;
        AutoCloseable autoCloseable2 = (AutoCloseable)this.encoderLock.acquire();
        Throwable throwable2 = null;
        try {
            ISentryLifecycleToken it3 = (ISentryLifecycleToken)autoCloseable2;
            boolean bl = false;
            SimpleVideoEncoder simpleVideoEncoder2 = this.encoder;
            if (simpleVideoEncoder2 != null) {
                simpleVideoEncoder2.release();
            }
            SimpleVideoEncoder simpleVideoEncoder3 = this.encoder;
            videoDuration = simpleVideoEncoder3 != null ? simpleVideoEncoder3.getDuration() : 0L;
            this.encoder = null;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
        }
        this.rotate$sentry_android_replay_release(from + duration);
        return new GeneratedVideo(videoFile, frameCount, videoDuration);
    }

    public static /* synthetic */ GeneratedVideo createVideoOf$default(ReplayCache replayCache, long l, long l2, int n, int n2, int n3, int n4, int n5, File file, int n6, Object object) {
        if ((n6 & 0x80) != 0) {
            file = new File(replayCache.getReplayCacheDir$sentry_android_replay_release(), n + ".mp4");
        }
        return replayCache.createVideoOf(l, l2, n, n2, n3, n4, n5, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean encode(ReplayFrame frame) {
        boolean bl;
        if (frame == null) {
            return false;
        }
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)frame.getScreenshot().getAbsolutePath());
            AutoCloseable autoCloseable = (AutoCloseable)this.encoderLock.acquire();
            Throwable throwable = null;
            try {
                Unit unit;
                ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                boolean bl2 = false;
                SimpleVideoEncoder simpleVideoEncoder = this.encoder;
                if (simpleVideoEncoder != null) {
                    Intrinsics.checkNotNull((Object)bitmap);
                    simpleVideoEncoder.encode(bitmap);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            bitmap.recycle();
            bl = true;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Unable to decode bitmap and encode it into a video, skipping frame", e);
            bl = false;
        }
        return bl;
    }

    private final void deleteFile(File file) {
        try {
            if (!file.delete()) {
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete replay frame: %s", objectArray);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to delete replay frame: %s", objectArray);
        }
    }

    @Nullable
    public final String rotate$sentry_android_replay_release(long until) {
        Ref.ObjectRef screen = new Ref.ObjectRef();
        CollectionsKt.removeAll(this.frames, (Function1)((Function1)new Function1<ReplayFrame, Boolean>(until, this, (Ref.ObjectRef<String>)screen){
            final /* synthetic */ long $until;
            final /* synthetic */ ReplayCache this$0;
            final /* synthetic */ Ref.ObjectRef<String> $screen;
            {
                this.$until = $until;
                this.this$0 = $receiver;
                this.$screen = $screen;
                super(1);
            }

            public final Boolean invoke(ReplayFrame it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getTimestamp() < this.$until) {
                    ReplayCache.access$deleteFile(this.this$0, it.getScreenshot());
                    return true;
                }
                if (this.$screen.element == null) {
                    this.$screen.element = it.getScreen();
                }
                return false;
            }
        }));
        return (String)screen.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AutoCloseable autoCloseable = (AutoCloseable)this.encoderLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            this.encoder = null;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.isClosed.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void persistSegmentValues$sentry_android_replay_release(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        AutoCloseable autoCloseable = (AutoCloseable)this.lock.acquire();
        Throwable throwable = null;
        try {
            Unit unit;
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            if (this.isClosed.get()) {
                return;
            }
            File file = this.getOngoingSegmentFile$sentry_android_replay_release();
            if (!(file != null ? file.exists() : false)) {
                File file2 = this.getOngoingSegmentFile$sentry_android_replay_release();
                if (file2 != null) {
                    file2.createNewFile();
                }
            }
            if (this.ongoingSegment.isEmpty()) {
                File file3 = this.getOngoingSegmentFile$sentry_android_replay_release();
                if (file3 != null) {
                    File $this$useLines_u24default$iv = file3;
                    Charset charset$iv = Charsets.UTF_8;
                    boolean $i$f$useLines = false;
                    Object object = $this$useLines_u24default$iv;
                    int n = 8192;
                    Object object2 = object;
                    object = (object2 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv)) instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    Throwable throwable2 = null;
                    try {
                        void $this$associateTo$iv;
                        BufferedReader it$iv = (BufferedReader)object;
                        boolean bl2 = false;
                        Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                        boolean bl3 = false;
                        Sequence sequence = lines;
                        Map destination$iv = this.ongoingSegment;
                        boolean $i$f$associateTo = false;
                        for (Object element$iv : $this$associateTo$iv) {
                            Map map = destination$iv;
                            String it2 = (String)element$iv;
                            boolean bl4 = false;
                            String[] stringArray = new String[]{"="};
                            List list = StringsKt.split$default((CharSequence)it2, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                            String k = (String)list.get(0);
                            String v = (String)list.get(1);
                            Pair pair = TuplesKt.to((Object)k, (Object)v);
                            map.put(pair.getFirst(), pair.getSecond());
                        }
                        object2 = (LinkedHashMap)destination$iv;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                }
            }
            if (value == null) {
                this.ongoingSegment.remove(key);
            } else {
                ((Map)this.ongoingSegment).put(key, value);
            }
            File file4 = this.getOngoingSegmentFile$sentry_android_replay_release();
            if (file4 != null) {
                Set<Map.Entry<String, String>> set = this.ongoingSegment.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                FilesKt.writeText$default((File)file4, (String)CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)persistSegmentValues.1.2.INSTANCE, (int)30, null), null, (int)2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ void access$deleteFile(ReplayCache $this, File file) {
        $this.deleteFile(file);
    }

    public static final /* synthetic */ SentryOptions access$getOptions$p(ReplayCache $this) {
        return $this.options;
    }

    public static final /* synthetic */ SentryId access$getReplayId$p(ReplayCache $this) {
        return $this.replayId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142%\b\u0002\u0010\u0015\u001a\u001f\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0016H\u0000\u00a2\u0006\u0002\b\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/sentry/android/replay/ReplayCache$Companion;", "", "()V", "ONGOING_SEGMENT", "", "SEGMENT_KEY_BIT_RATE", "SEGMENT_KEY_FRAME_RATE", "SEGMENT_KEY_HEIGHT", "SEGMENT_KEY_ID", "SEGMENT_KEY_REPLAY_ID", "SEGMENT_KEY_REPLAY_RECORDING", "SEGMENT_KEY_REPLAY_SCREEN_AT_START", "SEGMENT_KEY_REPLAY_TYPE", "SEGMENT_KEY_TIMESTAMP", "SEGMENT_KEY_WIDTH", "fromDisk", "Lio/sentry/android/replay/LastSegmentData;", "options", "Lio/sentry/SentryOptions;", "replayId", "Lio/sentry/protocol/SentryId;", "replayCacheProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lio/sentry/android/replay/ReplayCache;", "fromDisk$sentry_android_replay_release", "makeReplayCacheDir", "Ljava/io/File;", "sentry-android-replay_release"})
    @SourceDebugExtension(value={"SMAP\nReplayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,456:1\n1#2:457\n1#2:463\n284#3,5:458\n747#4,4:464\n1011#5,2:468\n1056#5:470\n*S KotlinDebug\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache$Companion\n*L\n328#1:463\n328#1:458,5\n329#1:464,4\n399#1:468,2\n432#1:470\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final File makeReplayCacheDir(@NotNull SentryOptions options, @NotNull SentryId replayId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
            Object object2 = options.getCacheDirPath();
            if (object2 == null || object2.length() == 0) {
                options.getLogger().log(SentryLevel.WARNING, "SentryOptions.cacheDirPath is not set, session replay is no-op", new Object[0]);
                object = null;
            } else {
                String string = options.getCacheDirPath();
                Intrinsics.checkNotNull((Object)string);
                Object it = object2 = new File(string, "replay_" + replayId);
                boolean bl = false;
                ((File)it).mkdirs();
                object = object2;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Nullable
        public final LastSegmentData fromDisk$sentry_android_replay_release(@NotNull SentryOptions options, @NotNull SentryId replayId, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
            block28: {
                block27: {
                    Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                    Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
                    replayCacheDir = this.makeReplayCacheDir(options, replayId);
                    lastSegmentFile = new File(replayCacheDir, ".ongoing_segment");
                    if (!lastSegmentFile.exists()) {
                        var6_6 = new Object[]{replayId};
                        options.getLogger().log(SentryLevel.DEBUG, "No ongoing segment found for replay: %s", var6_6);
                        FileUtils.deleteRecursively((File)replayCacheDir);
                        return null;
                    }
                    lastSegment = new LinkedHashMap<K, V>();
                    $this$useLines_u24default$iv = lastSegmentFile;
                    charset$iv = Charsets.UTF_8;
                    $i$f$useLines = false;
                    var10_12 = $this$useLines_u24default$iv;
                    var11_13 = 8192;
                    var12_15 = var10_12;
                    var10_12 = (var12_15 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)var12_15), charset$iv)) instanceof BufferedReader != false ? (BufferedReader)var12_15 : new BufferedReader((Reader)var12_15, var11_13);
                    var11_14 = null;
                    try {
                        it$iv = (BufferedReader)var10_12;
                        $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv = false;
                        lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                        $i$a$-useLines$default-ReplayCache$Companion$fromDisk$1 = false;
                        var16_28 = lines;
                        destination$iv = lastSegment;
                        $i$f$associateTo = false;
                        for (E element$iv : $this$associateTo$iv) {
                            var21_38 = destination$iv;
                            it = (String)element$iv;
                            $i$a$-associateTo-ReplayCache$Companion$fromDisk$1$1 = false;
                            var24_42 = new String[]{"="};
                            var25_43 = StringsKt.split$default((CharSequence)it, (String[])var24_42, (boolean)false, (int)2, (int)2, null);
                            k = (String)var25_43.get(0);
                            v = (String)var25_43.get(1);
                            it = TuplesKt.to((Object)k, (Object)v);
                            var21_38.put(it.getFirst(), it.getSecond());
                        }
                        it$iv = (LinkedHashMap)destination$iv;
                    }
                    catch (Throwable $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv) {
                        var11_14 = $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv;
                        throw $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var10_12, (Throwable)var11_14);
                    }
                    v0 = (String)lastSegment.get("config.height");
                    height = v0 != null ? StringsKt.toIntOrNull((String)v0) : null;
                    v1 = (String)lastSegment.get("config.width");
                    width = v1 != null ? StringsKt.toIntOrNull((String)v1) : null;
                    v2 = (String)lastSegment.get("config.frame-rate");
                    frameRate = v2 != null ? StringsKt.toIntOrNull((String)v2) : null;
                    v3 = (String)lastSegment.get("config.bit-rate");
                    bitRate = v3 != null ? StringsKt.toIntOrNull((String)v3) : null;
                    v4 = (String)lastSegment.get("segment.id");
                    segmentId = v4 != null ? StringsKt.toIntOrNull((String)v4) : null;
                    try {
                        v5 = (String)lastSegment.get("segment.timestamp");
                        if (v5 == null) {
                            v5 = "";
                        }
                        $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv = DateUtils.getDateTime((String)v5);
                    }
                    catch (Throwable e) {
                        $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv = null;
                    }
                    segmentTimestamp = $i$a$-use-FilesKt__FileReadWriteKt$useLines$1$iv;
                    try {
                        v6 = (String)lastSegment.get("replay.type");
                        if (v6 == null) {
                            v6 = "";
                        }
                        e = SentryReplayEvent.ReplayType.valueOf((String)v6);
                    }
                    catch (Throwable e) {
                        e = null;
                    }
                    replayType = e;
                    if (height == null || width == null || frameRate == null || bitRate == null || segmentId == null) break block27;
                    e = -1;
                    if (segmentId != e && segmentTimestamp != null && replayType != null) break block28;
                }
                e = new Object[]{replayId};
                options.getLogger().log(SentryLevel.DEBUG, "Incorrect segment values found for replay: %s, deleting the replay", e);
                FileUtils.deleteRecursively((File)replayCacheDir);
                return null;
            }
            recorderConfig = new ScreenshotRecorderConfig(width, height, 1.0f, 1.0f, frameRate, bitRate);
            v7 = replayCacheProvider;
            if (v7 == null || (v7 = (ReplayCache)v7.invoke((Object)replayId)) == null) {
                v7 = new ReplayCache(options, replayId);
            }
            cache = v7;
            v8 = cache.getReplayCacheDir$sentry_android_replay_release();
            if (v8 != null) {
                v8.listFiles((FilenameFilter)LambdaMetafactory.metafactory(null, null, null, (Ljava/io/File;Ljava/lang/String;)Z, fromDisk$lambda$3(io.sentry.android.replay.ReplayCache java.io.File java.lang.String ), (Ljava/io/File;Ljava/lang/String;)Z)((ReplayCache)cache));
            }
            if (cache.getFrames$sentry_android_replay_release().isEmpty()) {
                $this$associateTo$iv = new Object[]{replayId};
                options.getLogger().log(SentryLevel.DEBUG, "No frames found for replay: %s, deleting the replay", $this$associateTo$iv);
                FileUtils.deleteRecursively((File)replayCacheDir);
                return null;
            }
            $this$sortBy$iv = cache.getFrames$sentry_android_replay_release();
            $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ReplayFrame it = (ReplayFrame)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTimestamp());
                        it = (ReplayFrame)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                    }
                });
            }
            v9 = normalizedSegmentId = replayType == SentryReplayEvent.ReplayType.SESSION ? segmentId : 0;
            if (replayType == SentryReplayEvent.ReplayType.SESSION) {
                v10 = segmentTimestamp;
            } else {
                $i$f$associateTo = DateUtils.getDateTime((long)((ReplayFrame)CollectionsKt.first(cache.getFrames$sentry_android_replay_release())).getTimestamp());
                Intrinsics.checkNotNull((Object)$i$f$associateTo);
                v10 = $i$f$associateTo;
            }
            normalizedTimestamp = v10;
            duration = ((ReplayFrame)CollectionsKt.last(cache.getFrames$sentry_android_replay_release())).getTimestamp() - normalizedTimestamp.getTime() + (long)(1000 / frameRate);
            v11 = (String)lastSegment.get("replay.recording");
            if (v11 == null) ** GOTO lbl-1000
            it = v11;
            $i$a$-let-ReplayCache$Companion$fromDisk$events$1 = false;
            reader = new StringReader(it);
            v12 = recording = (ReplayRecording)options.getSerializer().deserialize((Reader)reader, ReplayRecording.class);
            if ((v12 != null ? v12.getPayload() : null) != null) {
                v13 = recording.getPayload();
                Intrinsics.checkNotNull((Object)v13);
                v14 = new LinkedList<E>(v13);
            } else {
                v14 = null;
            }
            v11 = v14;
            if (v14 != null) {
                v15 = (List)v11;
            } else lbl-1000:
            // 2 sources

            {
                v15 = CollectionsKt.emptyList();
            }
            events = v15;
            $this$sortedBy$iv = events;
            $i$f$sortedBy = false;
            return new LastSegmentData(recorderConfig, (ReplayCache)cache, normalizedTimestamp, normalizedSegmentId, duration, replayType, (String)lastSegment.get("replay.screen-at-start"), CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RRWebEvent it = (RRWebEvent)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (RRWebEvent)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            }));
        }

        public static /* synthetic */ LastSegmentData fromDisk$sentry_android_replay_release$default(Companion companion, SentryOptions sentryOptions, SentryId sentryId, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.fromDisk$sentry_android_replay_release(sentryOptions, sentryId, (Function1<? super SentryId, ReplayCache>)function1);
        }

        private static final boolean fromDisk$lambda$3(ReplayCache $cache, File dir, String name) {
            File file;
            Long timestamp;
            Intrinsics.checkNotNull((Object)name);
            if (StringsKt.endsWith$default((String)name, (String)".jpg", (boolean)false, (int)2, null) && (timestamp = StringsKt.toLongOrNull((String)FilesKt.getNameWithoutExtension((File)(file = new File(dir, name))))) != null) {
                ReplayCache.addFrame$default($cache, file, timestamp, null, 4, null);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

