/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.view.View;
import io.sentry.SentryOptions;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.RootViewsSpy;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.util.ExecutorsKt;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\r\u0010\u001f\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010 J\r\u0010!\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010 J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u001eR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/sentry/android/replay/WindowRecorder;", "Ljava/io/Closeable;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;)V", "capturer", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "capturingTask", "Ljava/util/concurrent/ScheduledFuture;", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onRootViewsChangedListener", "Lio/sentry/android/replay/OnRootViewsChangedListener;", "recorder", "Lio/sentry/android/replay/ScreenshotRecorder;", "rootViews", "Ljava/util/ArrayList;", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "rootViewsSpy", "Lio/sentry/android/replay/RootViewsSpy;", "getRootViewsSpy", "()Lio/sentry/android/replay/RootViewsSpy;", "rootViewsSpy$delegate", "Lkotlin/Lazy;", "close", "", "pause", "()Lkotlin/Unit;", "resume", "startRecording", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "stopRecording", "Companion", "RecorderExecutorServiceThreadFactory", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nWindowRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n*S KotlinDebug\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n*L\n75#1:99,2\n*E\n"})
public final class WindowRecorder
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final Lazy rootViewsSpy$delegate;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final ArrayList<WeakReference<View>> rootViews;
    @Nullable
    private ScreenshotRecorder recorder;
    @Nullable
    private ScheduledFuture<?> capturingTask;
    private final ScheduledExecutorService capturer;
    @NotNull
    private final OnRootViewsChangedListener onRootViewsChangedListener;
    @NotNull
    private static final String TAG = "WindowRecorder";

    public WindowRecorder(@NotNull SentryOptions options, @NotNull ScreenshotRecorderCallback screenshotRecorderCallback) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)screenshotRecorderCallback, (String)"screenshotRecorderCallback");
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.rootViewsSpy$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)rootViewsSpy.2.INSTANCE);
        this.isRecording = new AtomicBoolean(false);
        this.rootViews = new ArrayList();
        this.capturer = Executors.newSingleThreadScheduledExecutor(new RecorderExecutorServiceThreadFactory());
        this.onRootViewsChangedListener = (arg_0, arg_1) -> WindowRecorder.onRootViewsChangedListener$lambda$0(this, arg_0, arg_1);
    }

    private final RootViewsSpy getRootViewsSpy() {
        Lazy lazy = this.rootViewsSpy$delegate;
        return (RootViewsSpy)lazy.getValue();
    }

    public final void startRecording(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        if (this.isRecording.getAndSet(true)) {
            return;
        }
        this.recorder = new ScreenshotRecorder(recorderConfig, this.options, this.screenshotRecorderCallback);
        ((Collection)this.getRootViewsSpy().getListeners()).add(this.onRootViewsChangedListener);
        ScheduledExecutorService scheduledExecutorService = this.capturer;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        this.capturingTask = ExecutorsKt.scheduleAtFixedRateSafely(scheduledExecutorService, this.options, "WindowRecorder.capture", 0L, 1000L / (long)recorderConfig.getFrameRate(), TimeUnit.MILLISECONDS, () -> WindowRecorder.startRecording$lambda$1(this));
    }

    @Nullable
    public final Unit resume() {
        Unit unit;
        ScreenshotRecorder screenshotRecorder = this.recorder;
        if (screenshotRecorder != null) {
            screenshotRecorder.resume();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit pause() {
        Unit unit;
        ScreenshotRecorder screenshotRecorder = this.recorder;
        if (screenshotRecorder != null) {
            screenshotRecorder.pause();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void stopRecording() {
        ((Collection)this.getRootViewsSpy().getListeners()).remove(this.onRootViewsChangedListener);
        Iterable $this$forEach$iv = this.rootViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WeakReference it = (WeakReference)element$iv;
            boolean bl = false;
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) continue;
            screenshotRecorder.unbind((View)it.get());
        }
        ScreenshotRecorder screenshotRecorder = this.recorder;
        if (screenshotRecorder != null) {
            screenshotRecorder.close();
        }
        this.rootViews.clear();
        this.recorder = null;
        ScheduledFuture<?> scheduledFuture = this.capturingTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.capturingTask = null;
        this.isRecording.set(false);
    }

    @Override
    public void close() {
        this.stopRecording();
        ScheduledExecutorService scheduledExecutorService = this.capturer;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        ExecutorsKt.gracefullyShutdown(scheduledExecutorService, this.options);
    }

    private static final void onRootViewsChangedListener$lambda$0(WindowRecorder this$0, View root, boolean added) {
        block3: {
            View newRoot;
            block2: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (!added) break block2;
                this$0.rootViews.add(new WeakReference<View>(root));
                ScreenshotRecorder screenshotRecorder = this$0.recorder;
                if (screenshotRecorder == null) break block3;
                screenshotRecorder.bind(root);
                break block3;
            }
            ScreenshotRecorder screenshotRecorder = this$0.recorder;
            if (screenshotRecorder != null) {
                screenshotRecorder.unbind(root);
            }
            CollectionsKt.removeAll((List)this$0.rootViews, (Function1)((Function1)new Function1<WeakReference<View>, Boolean>(root){
                final /* synthetic */ View $root;
                {
                    this.$root = $root;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull WeakReference<View> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Intrinsics.areEqual(it.get(), (Object)this.$root);
                }
            }));
            WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this$0.rootViews);
            Object object = newRoot = weakReference != null ? (View)weakReference.get() : null;
            if (newRoot == null || Intrinsics.areEqual((Object)root, (Object)newRoot)) break block3;
            ScreenshotRecorder screenshotRecorder2 = this$0.recorder;
            if (screenshotRecorder2 != null) {
                screenshotRecorder2.bind(newRoot);
            }
        }
    }

    private static final void startRecording$lambda$1(WindowRecorder this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ScreenshotRecorder screenshotRecorder = this$0.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.capture();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/WindowRecorder$RecorderExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class RecorderExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryWindowRecorder-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/WindowRecorder$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

