/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001dJ\u0006\u0010&\u001a\u00020$J\u0006\u0010'\u001a\u00020$J\b\u0010(\u001a\u00020$H\u0016J\u0006\u0010)\u001a\u00020$J\u0006\u0010*\u001a\u00020$J\u0010\u0010+\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u001dJ\u0014\u0010,\u001a\u00020$*\u00020\u001d2\u0006\u0010-\u001a\u00020\u0018H\u0002J \u0010,\u001a\u00020$*\u00020\u00182\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020$0/H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/sentry/android/replay/ScreenshotRecorder;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;)V", "getConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "contentChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "handler", "Landroid/os/Handler;", "isCapturing", "lastScreenshot", "Landroid/graphics/Bitmap;", "maskingPaint", "Landroid/graphics/Paint;", "getOptions", "()Lio/sentry/SentryOptions;", "pendingViewHierarchy", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "prescaledMatrix", "Landroid/graphics/Matrix;", "rootView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "singlePixelBitmap", "singlePixelBitmapCanvas", "Landroid/graphics/Canvas;", "thread", "Landroid/os/HandlerThread;", "bind", "", "root", "capture", "close", "onDraw", "pause", "resume", "unbind", "traverse", "parentNode", "callback", "Lkotlin/Function1;", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nScreenshotRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotRecorder.kt\nio/sentry/android/replay/ScreenshotRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1#2:301\n1855#3,2:302\n*S KotlinDebug\n*F\n+ 1 ScreenshotRecorder.kt\nio/sentry/android/replay/ScreenshotRecorder\n*L\n211#1:302,2\n*E\n"})
public final class ScreenshotRecorder
implements ViewTreeObserver.OnDrawListener {
    @NotNull
    private final ScreenshotRecorderConfig config;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @Nullable
    private WeakReference<View> rootView;
    @NotNull
    private final HandlerThread thread;
    @NotNull
    private final Handler handler;
    @NotNull
    private final AtomicReference<ViewHierarchyNode> pendingViewHierarchy;
    @NotNull
    private final Paint maskingPaint;
    @NotNull
    private final Bitmap singlePixelBitmap;
    @NotNull
    private final Canvas singlePixelBitmapCanvas;
    @NotNull
    private final Matrix prescaledMatrix;
    @NotNull
    private final AtomicBoolean contentChanged;
    @NotNull
    private final AtomicBoolean isCapturing;
    @Nullable
    private Bitmap lastScreenshot;

    /*
     * WARNING - void declaration
     */
    public ScreenshotRecorder(@NotNull ScreenshotRecorderConfig config, @NotNull SentryOptions options, @NotNull ScreenshotRecorderCallback screenshotRecorderCallback) {
        void $this$prescaledMatrix_u24lambda_u241;
        HandlerThread it;
        HandlerThread handlerThread;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)screenshotRecorderCallback, (String)"screenshotRecorderCallback");
        this.config = config;
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("SentryReplayRecorder");
        ScreenshotRecorder screenshotRecorder = this;
        boolean bl = false;
        it.start();
        screenshotRecorder.thread = handlerThread;
        this.handler = new Handler(this.thread.getLooper());
        this.pendingViewHierarchy = new AtomicReference();
        this.maskingPaint = new Paint();
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n        1,\u2026ap.Config.ARGB_8888\n    )");
        this.singlePixelBitmap = bitmap;
        this.singlePixelBitmapCanvas = new Canvas(this.singlePixelBitmap);
        it = handlerThread = new Matrix();
        screenshotRecorder = this;
        boolean bl2 = false;
        $this$prescaledMatrix_u24lambda_u241.preScale(this.config.getScaleFactorX(), this.config.getScaleFactorY());
        screenshotRecorder.prescaledMatrix = handlerThread;
        this.contentChanged = new AtomicBoolean(false);
        this.isCapturing = new AtomicBoolean(true);
    }

    @NotNull
    public final ScreenshotRecorderConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final SentryOptions getOptions() {
        return this.options;
    }

    public final void capture() {
        View root;
        ViewHierarchyNode viewHierarchy = this.pendingViewHierarchy.getAndSet(null);
        if (!this.isCapturing.get()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ScreenshotRecorder is paused, not capturing screenshot", new Object[0]);
            return;
        }
        if (!this.contentChanged.get() && this.lastScreenshot != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Content hasn't changed, repeating last known frame", new Object[0]);
            Bitmap bitmap = this.lastScreenshot;
            if (bitmap != null) {
                Bitmap it = bitmap;
                boolean bl = false;
                Bitmap bitmap2 = it.copy(Bitmap.Config.ARGB_8888, false);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"it.copy(ARGB_8888, false)");
                this.screenshotRecorderCallback.onScreenshotRecorded(bitmap2);
            }
            return;
        }
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        Window window = WindowsKt.getPhoneWindow(root);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)root.getWidth(), (int)root.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026onfig.ARGB_8888\n        )");
        Bitmap bitmap3 = bitmap;
        new Handler(Looper.getMainLooper()).postAtFrontOfQueue(() -> ScreenshotRecorder.capture$lambda$4(window, bitmap3, this, viewHierarchy));
    }

    public void onDraw() {
        View root;
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        ViewHierarchyNode rootNode = ViewHierarchyNode.Companion.fromView(root, this.options);
        this.traverse(root, rootNode);
        this.pendingViewHierarchy.set(rootNode);
        this.contentChanged.set(true);
    }

    public final void bind(@NotNull View root) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            WeakReference<View> weakReference = this.rootView;
            this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
            WeakReference<View> weakReference2 = this.rootView;
            if (weakReference2 != null) {
                weakReference2.clear();
            }
            this.rootView = new WeakReference<View>(root);
            ViewTreeObserver viewTreeObserver = root.getViewTreeObserver();
            if (viewTreeObserver == null) break block1;
            viewTreeObserver.addOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
    }

    public final void unbind(@Nullable View root) {
        block0: {
            View view = root;
            if (view == null || (view = view.getViewTreeObserver()) == null) break block0;
            view.removeOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
    }

    public final void pause() {
        this.isCapturing.set(false);
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
    }

    public final void resume() {
        View view = this.rootView;
        if (view != null && (view = (View)view.get()) != null && (view = view.getViewTreeObserver()) != null) {
            view.addOnDrawListener((ViewTreeObserver.OnDrawListener)this);
        }
        this.isCapturing.set(true);
    }

    public final void close() {
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        Bitmap bitmap = this.lastScreenshot;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.pendingViewHierarchy.set(null);
        this.isCapturing.set(false);
        this.thread.quitSafely();
    }

    private final void traverse(ViewHierarchyNode $this$traverse, Function1<? super ViewHierarchyNode, Unit> callback) {
        callback.invoke((Object)$this$traverse);
        if ($this$traverse.getChildren() != null) {
            List<ViewHierarchyNode> list = $this$traverse.getChildren();
            Intrinsics.checkNotNull(list);
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewHierarchyNode it = (ViewHierarchyNode)element$iv;
                boolean bl = false;
                this.traverse(it, callback);
            }
        }
    }

    private final void traverse(View $this$traverse, ViewHierarchyNode parentNode) {
        if (!($this$traverse instanceof ViewGroup)) {
            return;
        }
        if (((ViewGroup)$this$traverse).getChildCount() == 0) {
            return;
        }
        ArrayList<ViewHierarchyNode> childNodes = new ArrayList<ViewHierarchyNode>(((ViewGroup)$this$traverse).getChildCount());
        int n = ((ViewGroup)$this$traverse).getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = ((ViewGroup)$this$traverse).getChildAt(i);
            if (child == null) continue;
            ViewHierarchyNode childNode = ViewHierarchyNode.Companion.fromView(child, this.options);
            childNodes.add(childNode);
            this.traverse(child, childNode);
        }
        parentNode.setChildren((List<ViewHierarchyNode>)childNodes);
    }

    private static final void capture$lambda$4$lambda$3(ScreenshotRecorder this$0, Bitmap $bitmap, ViewHierarchyNode $viewHierarchy, int copyResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        if (copyResult != 0) {
            Object[] objectArray = new Object[]{copyResult};
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to capture replay recording: %d", objectArray);
            $bitmap.recycle();
            return;
        }
        Bitmap scaledBitmap = null;
        if ($viewHierarchy == null) {
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to determine view hierarchy, not capturing", new Object[0]);
            $bitmap.recycle();
            return;
        }
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$bitmap, (int)this$0.config.getRecordingWidth(), (int)this$0.config.getRecordingHeight(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(\n    \u2026                        )");
        scaledBitmap = bitmap;
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(this$0.prescaledMatrix);
        this$0.traverse($viewHierarchy, (Function1<? super ViewHierarchyNode, Unit>)((Function1)new Function1<ViewHierarchyNode, Unit>(this$0, $bitmap, canvas){
            final /* synthetic */ ScreenshotRecorder this$0;
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Canvas $canvas;
            {
                this.this$0 = $receiver;
                this.$bitmap = $bitmap;
                this.$canvas = $canvas;
                super(1);
            }

            public final void invoke(@NotNull ViewHierarchyNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getShouldRedact() && it.getWidth() > 0 && it.getHeight() > 0) {
                    int n;
                    if (it.getVisibleRect() == null) {
                        return;
                    }
                    if (it.getDominantColor() == null) {
                        ScreenshotRecorder.access$getSinglePixelBitmapCanvas$p(this.this$0).drawBitmap(this.$bitmap, it.getVisibleRect(), new Rect(0, 0, 1, 1), null);
                        n = ScreenshotRecorder.access$getSinglePixelBitmap$p(this.this$0).getPixel(0, 0);
                    } else {
                        n = it.getDominantColor();
                    }
                    int color = n;
                    ScreenshotRecorder.access$getMaskingPaint$p(this.this$0).setColor(color);
                    this.$canvas.drawRoundRect(new RectF(it.getVisibleRect()), 10.0f, 10.0f, ScreenshotRecorder.access$getMaskingPaint$p(this.this$0));
                }
            }
        }));
        Bitmap screenshot = scaledBitmap.copy(Bitmap.Config.ARGB_8888, false);
        ScreenshotRecorderCallback screenshotRecorderCallback = this$0.screenshotRecorderCallback;
        Intrinsics.checkNotNullExpressionValue((Object)screenshot, (String)"screenshot");
        screenshotRecorderCallback.onScreenshotRecorded(screenshot);
        Bitmap bitmap2 = this$0.lastScreenshot;
        if (bitmap2 != null) {
            bitmap2.recycle();
        }
        this$0.lastScreenshot = screenshot;
        this$0.contentChanged.set(false);
        scaledBitmap.recycle();
        $bitmap.recycle();
    }

    private static final void capture$lambda$4(Window $window, Bitmap $bitmap, ScreenshotRecorder this$0, ViewHierarchyNode $viewHierarchy) {
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            PixelCopy.request((Window)$window, (Bitmap)$bitmap, arg_0 -> ScreenshotRecorder.capture$lambda$4$lambda$3(this$0, $bitmap, $viewHierarchy, arg_0), (Handler)this$0.handler);
        }
        catch (Throwable e) {
            this$0.options.getLogger().log(SentryLevel.WARNING, "Failed to capture replay recording", e);
            $bitmap.recycle();
        }
    }

    public static final /* synthetic */ Canvas access$getSinglePixelBitmapCanvas$p(ScreenshotRecorder $this) {
        return $this.singlePixelBitmapCanvas;
    }

    public static final /* synthetic */ Bitmap access$getSinglePixelBitmap$p(ScreenshotRecorder $this) {
        return $this.singlePixelBitmap;
    }

    public static final /* synthetic */ Paint access$getMaskingPaint$p(ScreenshotRecorder $this) {
        return $this.maskingPaint;
    }
}

