/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.Integration;
import io.sentry.ReplayController;
import io.sentry.ReplayRecording;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.SentryReplayOptions;
import io.sentry.android.replay.GeneratedVideo;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayFrame;
import io.sentry.android.replay.ReplayIntegration;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.protocol.SentryId;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebMetaEvent;
import io.sentry.rrweb.RRWebVideoEvent;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import io.sentry.util.IntegrationUtils;
import java.io.Closeable;
import java.io.File;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 V2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002VWB\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\\\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<H\u0002J\b\u0010=\u001a\u00020/H\u0016JU\u0010>\u001a\u0004\u0018\u0001082\u0006\u00107\u001a\u0002082\u0006\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020\u000f2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\b\b\u0002\u00109\u001a\u00020:2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<H\u0002\u00a2\u0006\u0002\u0010AJ\b\u0010\u0018\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020/H\u0016J\u0010\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020/H\u0016J\u0018\u0010K\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010L\u001a\u00020/H\u0016J\u0017\u0010M\u001a\u00020B2\b\u0010N\u001a\u0004\u0018\u00010OH\u0002\u00a2\u0006\u0002\u0010PJ\u0018\u0010Q\u001a\u00020/2\u0006\u0010R\u001a\u00020S2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010T\u001a\u00020/H\u0016J\b\u0010U\u001a\u00020/H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R#\u0010%\u001a\n \u0010*\u0004\u0018\u00010&0&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010 \u001a\u0004\b'\u0010(R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lio/sentry/android/replay/ReplayIntegration;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "Lio/sentry/ReplayController;", "Landroid/content/ComponentCallbacks;", "context", "Landroid/content/Context;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;)V", "cache", "Lio/sentry/android/replay/ReplayCache;", "currentReplayId", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/sentry/protocol/SentryId;", "kotlin.jvm.PlatformType", "currentSegment", "Ljava/util/concurrent/atomic/AtomicInteger;", "hub", "Lio/sentry/IHub;", "isEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isFullSession", "isRecording", "options", "Lio/sentry/SentryOptions;", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "Lkotlin/Lazy;", "recorder", "Lio/sentry/android/replay/WindowRecorder;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "replayExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "getReplayExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "replayExecutor$delegate", "replayStartTimestamp", "Ljava/util/concurrent/atomic/AtomicLong;", "segmentTimestamp", "Ljava/util/Date;", "captureReplay", "", "video", "Ljava/io/File;", "segmentId", "", "height", "width", "frameCount", "duration", "", "replayType", "Lio/sentry/SentryReplayEvent$ReplayType;", "hint", "Lio/sentry/Hint;", "close", "createAndCaptureSegment", "currentSegmentTimestamp", "replayId", "(JLjava/util/Date;Lio/sentry/protocol/SentryId;IIILio/sentry/SentryReplayEvent$ReplayType;Lio/sentry/Hint;)Ljava/lang/Long;", "", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onScreenshotRecorded", "bitmap", "Landroid/graphics/Bitmap;", "pause", "register", "resume", "sample", "rate", "", "(Ljava/lang/Double;)Z", "sendReplayForEvent", "event", "Lio/sentry/SentryEvent;", "start", "stop", "Companion", "ReplayExecutorServiceThreadFactory", "sentry-android-replay_release"})
@SourceDebugExtension(value={"SMAP\nReplayIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayIntegration.kt\nio/sentry/android/replay/ReplayIntegration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,467:1\n1#2:468\n*E\n"})
public final class ReplayIntegration
implements Integration,
Closeable,
ScreenshotRecorderCallback,
ReplayController,
ComponentCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    private SentryOptions options;
    @Nullable
    private IHub hub;
    @Nullable
    private WindowRecorder recorder;
    @Nullable
    private ReplayCache cache;
    @NotNull
    private final Lazy random$delegate;
    @NotNull
    private final AtomicBoolean isFullSession;
    @NotNull
    private final AtomicBoolean isEnabled;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final AtomicReference<SentryId> currentReplayId;
    @NotNull
    private final AtomicReference<Date> segmentTimestamp;
    @NotNull
    private final AtomicLong replayStartTimestamp;
    @NotNull
    private final AtomicInteger currentSegment;
    @NotNull
    private final Lazy replayExecutor$delegate;
    private ScreenshotRecorderConfig recorderConfig;
    @NotNull
    private static final String TAG = "ReplayIntegration";

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.context = context;
        this.dateProvider = dateProvider;
        this.random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
        this.isFullSession = new AtomicBoolean(false);
        this.isEnabled = new AtomicBoolean(false);
        this.isRecording = new AtomicBoolean(false);
        this.currentReplayId = new AtomicReference<SentryId>(SentryId.EMPTY_ID);
        this.segmentTimestamp = new AtomicReference();
        this.replayStartTimestamp = new AtomicLong();
        this.currentSegment = new AtomicInteger(0);
        this.replayExecutor$delegate = LazyKt.lazy((Function0)replayExecutor.2.INSTANCE);
    }

    private final SecureRandom getRandom() {
        Lazy lazy = this.random$delegate;
        return (SecureRandom)lazy.getValue();
    }

    private final ScheduledExecutorService getReplayExecutor() {
        Lazy lazy = this.replayExecutor$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    private final boolean sample(Double rate) {
        if (rate != null) {
            return !(rate < this.getRandom().nextDouble());
        }
        return false;
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        if (Build.VERSION.SDK_INT < 26) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is only supported on API 26 and above", new Object[0]);
            return;
        }
        if (!options.getExperimental().getSessionReplay().isSessionReplayEnabled() && !options.getExperimental().getSessionReplay().isSessionReplayForErrorsEnabled()) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is disabled, no sample rate specified", new Object[0]);
            return;
        }
        this.isFullSession.set(this.sample(options.getExperimental().getSessionReplay().getSessionSampleRate()));
        if (!this.isFullSession.get() && !options.getExperimental().getSessionReplay().isSessionReplayForErrorsEnabled()) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is disabled, full session was not sampled and errorSampleRate is not specified", new Object[0]);
            return;
        }
        this.hub = hub;
        this.recorder = new WindowRecorder(options, this);
        this.isEnabled.set(true);
        try {
            this.context.registerComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.INFO, "ComponentCallbacks is not available, orientation changes won't be handled by Session replay", e);
        }
        IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-replay", "7.8.0-alpha.0");
    }

    public boolean isRecording() {
        return this.isRecording.get();
    }

    public void start() {
        SentryOptions sentryOptions;
        if (!this.isEnabled.get()) {
            return;
        }
        if (this.isRecording.getAndSet(true)) {
            SentryOptions sentryOptions2 = this.options;
            if (sentryOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions2 = null;
            }
            sentryOptions2.getLogger().log(SentryLevel.DEBUG, "Session replay is already being recorded, not starting a new one", new Object[0]);
            return;
        }
        this.currentSegment.set(0);
        this.currentReplayId.set(new SentryId());
        ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
        ExecutorService executorService = scheduledExecutorService;
        SentryOptions sentryOptions3 = this.options;
        if (sentryOptions3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions3 = null;
        }
        ExecutorsKt.submitSafely(executorService, sentryOptions3, "ReplayIntegration.replays_cleanup", () -> ReplayIntegration.start$lambda$2(this));
        if (this.isFullSession.get()) {
            IHub iHub = this.hub;
            if (iHub != null) {
                iHub.configureScope(arg_0 -> ReplayIntegration.start$lambda$3(this, arg_0));
            }
        }
        if ((sentryOptions = this.options) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        SentryReplayOptions sentryReplayOptions = sentryOptions.getExperimental().getSessionReplay();
        Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"options.experimental.sessionReplay");
        this.recorderConfig = ScreenshotRecorderConfig.Companion.from(this.context, sentryReplayOptions);
        SentryOptions sentryOptions4 = this.options;
        if (sentryOptions4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions4 = null;
        }
        SentryId sentryId = this.currentReplayId.get();
        Intrinsics.checkNotNullExpressionValue((Object)sentryId, (String)"currentReplayId.get()");
        ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
        if (screenshotRecorderConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig = null;
        }
        this.cache = new ReplayCache(sentryOptions4, sentryId, screenshotRecorderConfig);
        WindowRecorder windowRecorder = this.recorder;
        if (windowRecorder != null) {
            ScreenshotRecorderConfig screenshotRecorderConfig2 = this.recorderConfig;
            if (screenshotRecorderConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig2 = null;
            }
            windowRecorder.startRecording(screenshotRecorderConfig2);
        }
        this.segmentTimestamp.set(DateUtils.getCurrentDateTime());
        this.replayStartTimestamp.set(this.dateProvider.getCurrentTimeMillis());
    }

    public void resume() {
        block1: {
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            this.segmentTimestamp.set(DateUtils.getCurrentDateTime());
            WindowRecorder windowRecorder = this.recorder;
            if (windowRecorder == null) break block1;
            windowRecorder.resume();
        }
    }

    public void sendReplayForEvent(@NotNull SentryEvent event, @NotNull Hint hint) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        if (!event.isErrored() && !event.isCrashed()) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            Object[] objectArray = new Object[]{event.getEventId()};
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Event is not error or crash, not capturing for event %s", objectArray);
            return;
        }
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        boolean sampled = this.sample(sentryOptions.getExperimental().getSessionReplay().getErrorSampleRate());
        SentryId replayId = this.currentReplayId.get();
        if (!replayId.equals((Object)SentryId.EMPTY_ID) && (this.isFullSession.get() || sampled)) {
            event.setTag("replayId", this.currentReplayId.get().toString());
        }
        if (this.isFullSession.get()) {
            SentryOptions sentryOptions2 = this.options;
            if (sentryOptions2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions2 = null;
            }
            Object[] objectArray = new Object[]{event.getEventId()};
            sentryOptions2.getLogger().log(SentryLevel.DEBUG, "Replay is already running in 'session' mode, not capturing for event %s", objectArray);
            return;
        }
        if (!sampled) {
            SentryOptions sentryOptions3 = this.options;
            if (sentryOptions3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions3 = null;
            }
            Object[] objectArray = new Object[]{event.getEventId()};
            sentryOptions3.getLogger().log(SentryLevel.INFO, "Replay wasn't sampled by errorSampleRate, not capturing for event %s", objectArray);
            return;
        }
        SentryOptions sentryOptions4 = this.options;
        if (sentryOptions4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions4 = null;
        }
        long errorReplayDuration = sentryOptions4.getExperimental().getSessionReplay().getErrorReplayDuration();
        long now = this.dateProvider.getCurrentTimeMillis();
        Object object = this.cache;
        boolean bl = object != null && (object = ((ReplayCache)object).getFrames$sentry_android_replay_release()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            ReplayCache replayCache = this.cache;
            Intrinsics.checkNotNull((Object)replayCache);
            date = DateUtils.getDateTime((long)((ReplayFrame)CollectionsKt.first(replayCache.getFrames$sentry_android_replay_release())).getTimestamp());
        } else {
            date = DateUtils.getDateTime((long)(now - errorReplayDuration));
        }
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"if (cache?.frames?.isNot\u2026ReplayDuration)\n        }");
        Date currentSegmentTimestamp = date;
        int segmentId = this.currentSegment.get();
        ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
        if (screenshotRecorderConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig = null;
        }
        int height = screenshotRecorderConfig.getRecordingHeight();
        ScreenshotRecorderConfig screenshotRecorderConfig2 = this.recorderConfig;
        if (screenshotRecorderConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig2 = null;
        }
        int width = screenshotRecorderConfig2.getRecordingWidth();
        ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
        ExecutorService executorService = scheduledExecutorService;
        SentryOptions sentryOptions5 = this.options;
        if (sentryOptions5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions5 = null;
        }
        ExecutorsKt.submitSafely(executorService, sentryOptions5, "ReplayIntegration.send_replay_for_event", () -> ReplayIntegration.sendReplayForEvent$lambda$4(this, now, currentSegmentTimestamp, replayId, segmentId, height, width, hint));
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(arg_0 -> ReplayIntegration.sendReplayForEvent$lambda$5(replayId, arg_0));
        }
        this.isFullSession.set(true);
    }

    public void pause() {
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        long now = this.dateProvider.getCurrentTimeMillis();
        WindowRecorder windowRecorder = this.recorder;
        if (windowRecorder != null) {
            windowRecorder.pause();
        }
        if (!this.isFullSession.get()) {
            return;
        }
        Date currentSegmentTimestamp = this.segmentTimestamp.get();
        int segmentId = this.currentSegment.get();
        long duration = now - currentSegmentTimestamp.getTime();
        SentryId replayId = this.currentReplayId.get();
        ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
        if (screenshotRecorderConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig = null;
        }
        int height = screenshotRecorderConfig.getRecordingHeight();
        ScreenshotRecorderConfig screenshotRecorderConfig2 = this.recorderConfig;
        if (screenshotRecorderConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig2 = null;
        }
        int width = screenshotRecorderConfig2.getRecordingWidth();
        ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
        ExecutorService executorService = scheduledExecutorService;
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        ExecutorsKt.submitSafely(executorService, sentryOptions, "ReplayIntegration.pause", () -> ReplayIntegration.pause$lambda$6(this, duration, currentSegmentTimestamp, replayId, segmentId, height, width));
    }

    public void stop() {
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        long now = this.dateProvider.getCurrentTimeMillis();
        Date currentSegmentTimestamp = this.segmentTimestamp.get();
        int segmentId = this.currentSegment.get();
        long duration = now - currentSegmentTimestamp.getTime();
        SentryId replayId = this.currentReplayId.get();
        ReplayCache replayCache = this.cache;
        File replayCacheDir2 = replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
        ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
        if (screenshotRecorderConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig = null;
        }
        int height = screenshotRecorderConfig.getRecordingHeight();
        ScreenshotRecorderConfig screenshotRecorderConfig2 = this.recorderConfig;
        if (screenshotRecorderConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig2 = null;
        }
        int width = screenshotRecorderConfig2.getRecordingWidth();
        ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
        ExecutorService executorService = scheduledExecutorService;
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        ExecutorsKt.submitSafely(executorService, sentryOptions, "ReplayIntegration.stop", () -> ReplayIntegration.stop$lambda$7(this, duration, currentSegmentTimestamp, replayId, segmentId, height, width, replayCacheDir2));
        WindowRecorder windowRecorder = this.recorder;
        if (windowRecorder != null) {
            windowRecorder.stopRecording();
        }
        ReplayCache replayCache2 = this.cache;
        if (replayCache2 != null) {
            replayCache2.close();
        }
        this.currentSegment.set(0);
        this.replayStartTimestamp.set(0L);
        this.segmentTimestamp.set(null);
        this.currentReplayId.set(SentryId.EMPTY_ID);
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(ReplayIntegration::stop$lambda$8);
        }
        this.isRecording.set(false);
    }

    @Override
    public void onScreenshotRecorded(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        long frameTimestamp = this.dateProvider.getCurrentTimeMillis();
        ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
        if (screenshotRecorderConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig = null;
        }
        int height = screenshotRecorderConfig.getRecordingHeight();
        ScreenshotRecorderConfig screenshotRecorderConfig2 = this.recorderConfig;
        if (screenshotRecorderConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
            screenshotRecorderConfig2 = null;
        }
        int width = screenshotRecorderConfig2.getRecordingWidth();
        ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
        ExecutorService executorService = scheduledExecutorService;
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        ExecutorsKt.submitSafely(executorService, sentryOptions, "ReplayIntegration.add_frame", () -> ReplayIntegration.onScreenshotRecorded$lambda$9(this, bitmap, frameTimestamp, height, width));
    }

    private final Long createAndCaptureSegment(long duration, Date currentSegmentTimestamp, SentryId replayId, int segmentId, int height, int width, SentryReplayEvent.ReplayType replayType, Hint hint) {
        Object object = this.cache;
        if (object == null || (object = ReplayCache.createVideoOf$default((ReplayCache)object, duration, currentSegmentTimestamp.getTime(), segmentId, height, width, null, 32, null)) == null) {
            return null;
        }
        Object generatedVideo = object;
        File video = ((GeneratedVideo)generatedVideo).component1();
        int frameCount = ((GeneratedVideo)generatedVideo).component2();
        long videoDuration = ((GeneratedVideo)generatedVideo).component3();
        this.captureReplay(video, replayId, currentSegmentTimestamp, segmentId, height, width, frameCount, videoDuration, replayType, hint);
        return videoDuration;
    }

    static /* synthetic */ Long createAndCaptureSegment$default(ReplayIntegration replayIntegration, long l, Date date, SentryId sentryId, int n, int n2, int n3, SentryReplayEvent.ReplayType replayType, Hint hint, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            replayType = SentryReplayEvent.ReplayType.SESSION;
        }
        if ((n4 & 0x80) != 0) {
            hint = null;
        }
        return replayIntegration.createAndCaptureSegment(l, date, sentryId, n, n2, n3, replayType, hint);
    }

    /*
     * WARNING - void declaration
     */
    private final void captureReplay(File video, SentryId currentReplayId, Date segmentTimestamp, int segmentId, int height, int width, int frameCount, long duration, SentryReplayEvent.ReplayType replayType, Hint hint) {
        block3: {
            void $this$captureReplay_u24lambda_u2414;
            Hint hint2;
            void $this$captureReplay_u24lambda_u2413_u24lambda_u2412;
            RRWebMetaEvent $this$captureReplay_u24lambda_u2413_u24lambda_u2411;
            RRWebMetaEvent rRWebMetaEvent;
            ReplayRecording replayRecording;
            SentryReplayEvent sentryReplayEvent;
            SentryReplayEvent $this$captureReplay_u24lambda_u2410 = sentryReplayEvent = new SentryReplayEvent();
            boolean bl = false;
            $this$captureReplay_u24lambda_u2410.setEventId(currentReplayId);
            $this$captureReplay_u24lambda_u2410.setReplayId(currentReplayId);
            $this$captureReplay_u24lambda_u2410.setSegmentId(segmentId);
            $this$captureReplay_u24lambda_u2410.setTimestamp(DateUtils.getDateTime((long)(segmentTimestamp.getTime() + duration)));
            if (segmentId == 0) {
                $this$captureReplay_u24lambda_u2410.setReplayStartTimestamp(segmentTimestamp);
            }
            $this$captureReplay_u24lambda_u2410.setReplayType(replayType);
            $this$captureReplay_u24lambda_u2410.setVideoFile(video);
            SentryReplayEvent replay = sentryReplayEvent;
            ReplayRecording $this$captureReplay_u24lambda_u2413 = replayRecording = new ReplayRecording();
            boolean $i$a$-apply-ReplayIntegration$captureReplay$recording$22 = false;
            $this$captureReplay_u24lambda_u2413.setSegmentId(Integer.valueOf(segmentId));
            Object[] objectArray = new RRWebEvent[2];
            RRWebMetaEvent rRWebMetaEvent2 = rRWebMetaEvent = new RRWebMetaEvent();
            int n = 0;
            Object[] objectArray2 = objectArray;
            ReplayRecording replayRecording2 = $this$captureReplay_u24lambda_u2413;
            boolean bl2 = false;
            $this$captureReplay_u24lambda_u2413_u24lambda_u2411.setTimestamp(segmentTimestamp.getTime());
            $this$captureReplay_u24lambda_u2413_u24lambda_u2411.setHeight(height);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2411.setWidth(width);
            Unit unit = Unit.INSTANCE;
            objectArray2[n] = (RRWebEvent)rRWebMetaEvent;
            $this$captureReplay_u24lambda_u2413_u24lambda_u2411 = rRWebMetaEvent = new RRWebVideoEvent();
            n = 1;
            objectArray2 = objectArray;
            boolean bl3 = false;
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setTimestamp(segmentTimestamp.getTime());
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setSegmentId(segmentId);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setDurationMs(duration);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setFrameCount(frameCount);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setSize(video.length());
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setFrameRate(screenshotRecorderConfig.getFrameRate());
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setHeight(height);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setWidth(width);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setLeft(0);
            $this$captureReplay_u24lambda_u2413_u24lambda_u2412.setTop(0);
            unit = Unit.INSTANCE;
            objectArray2[n] = (RRWebEvent)rRWebMetaEvent;
            replayRecording2.setPayload(CollectionsKt.listOf((Object[])objectArray));
            ReplayRecording recording = replayRecording;
            IHub iHub = this.hub;
            if (iHub == null) break block3;
            Hint hint3 = hint;
            if (hint3 == null) {
                hint3 = new Hint();
            }
            Hint $i$a$-apply-ReplayIntegration$captureReplay$recording$22 = hint2 = hint3;
            SentryReplayEvent sentryReplayEvent2 = replay;
            IHub iHub2 = iHub;
            boolean bl4 = false;
            $this$captureReplay_u24lambda_u2414.setReplayRecording(recording);
            Unit unit2 = Unit.INSTANCE;
            iHub2.captureReplay(sentryReplayEvent2, hint2);
        }
    }

    static /* synthetic */ void captureReplay$default(ReplayIntegration replayIntegration, File file, SentryId sentryId, Date date, int n, int n2, int n3, int n4, long l, SentryReplayEvent.ReplayType replayType, Hint hint, int n5, Object object) {
        if ((n5 & 0x200) != 0) {
            hint = null;
        }
        replayIntegration.captureReplay(file, sentryId, date, n, n2, n3, n4, l, replayType, hint);
    }

    @Override
    public void close() {
        if (!this.isEnabled.get()) {
            return;
        }
        try {
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stop();
        ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
        ExecutorService executorService = scheduledExecutorService;
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        ExecutorsKt.gracefullyShutdown(executorService, sentryOptions);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        block8: {
            SentryOptions sentryOptions;
            Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            WindowRecorder windowRecorder = this.recorder;
            if (windowRecorder != null) {
                windowRecorder.stopRecording();
            }
            if (this.isFullSession.get()) {
                long now = this.dateProvider.getCurrentTimeMillis();
                Date currentSegmentTimestamp = this.segmentTimestamp.get();
                int segmentId = this.currentSegment.get();
                long duration = now - currentSegmentTimestamp.getTime();
                SentryId replayId = this.currentReplayId.get();
                ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
                if (screenshotRecorderConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                    screenshotRecorderConfig = null;
                }
                int height = screenshotRecorderConfig.getRecordingHeight();
                ScreenshotRecorderConfig screenshotRecorderConfig2 = this.recorderConfig;
                if (screenshotRecorderConfig2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                    screenshotRecorderConfig2 = null;
                }
                int width = screenshotRecorderConfig2.getRecordingWidth();
                ScheduledExecutorService scheduledExecutorService = this.getReplayExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"replayExecutor");
                ExecutorService executorService = scheduledExecutorService;
                SentryOptions sentryOptions2 = this.options;
                if (sentryOptions2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions2 = null;
                }
                ExecutorsKt.submitSafely(executorService, sentryOptions2, "ReplayIntegration.onConfigurationChanged", () -> ReplayIntegration.onConfigurationChanged$lambda$15(this, duration, currentSegmentTimestamp, replayId, segmentId, height, width));
            }
            if ((sentryOptions = this.options) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            SentryReplayOptions sentryReplayOptions = sentryOptions.getExperimental().getSessionReplay();
            Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"options.experimental.sessionReplay");
            this.recorderConfig = ScreenshotRecorderConfig.Companion.from(this.context, sentryReplayOptions);
            WindowRecorder windowRecorder2 = this.recorder;
            if (windowRecorder2 == null) break block8;
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            windowRecorder2.startRecording(screenshotRecorderConfig);
        }
    }

    public void onLowMemory() {
    }

    private static final boolean start$lambda$2$lambda$1$lambda$0(ReplayIntegration this$0, File dir, String name) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (StringsKt.startsWith$default((String)name, (String)"replay_", (boolean)false, (int)2, null)) {
            CharSequence charSequence = name;
            String string = this$0.currentReplayId.get().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentReplayId.get().toString()");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                FileUtils.deleteRecursively((File)new File(dir, name));
            }
        }
        return false;
    }

    private static final void start$lambda$2(ReplayIntegration this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SentryOptions sentryOptions = this$0.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            String string = sentryOptions.getCacheDirPath();
            if (string == null) break block1;
            String cacheDir = string;
            boolean bl = false;
            new File(cacheDir).listFiles((arg_0, arg_1) -> ReplayIntegration.start$lambda$2$lambda$1$lambda$0(this$0, arg_0, arg_1));
        }
    }

    private static final void start$lambda$3(ReplayIntegration this$0, IScope it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(this$0.currentReplayId.get());
    }

    private static final void sendReplayForEvent$lambda$4(ReplayIntegration this$0, long $now, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width, Hint $hint) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentSegmentTimestamp, (String)"$currentSegmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)$hint, (String)"$hint");
        long l = $now - $currentSegmentTimestamp.getTime();
        Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
        Long videoDuration = this$0.createAndCaptureSegment(l, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, SentryReplayEvent.ReplayType.BUFFER, $hint);
        if (videoDuration != null) {
            this$0.currentSegment.getAndIncrement();
        }
        this$0.segmentTimestamp.set(DateUtils.getDateTime((long)$now));
    }

    private static final void sendReplayForEvent$lambda$5(SentryId $replayId, IScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId($replayId);
    }

    private static final void pause$lambda$6(ReplayIntegration this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)$currentSegmentTimestamp, (String)"currentSegmentTimestamp");
        Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
        Long videoDuration = ReplayIntegration.createAndCaptureSegment$default(this$0, $duration, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, null, null, 192, null);
        if (videoDuration != null) {
            this$0.currentSegment.getAndIncrement();
        }
    }

    private static final void stop$lambda$7(ReplayIntegration this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width, File $replayCacheDir) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isFullSession.get()) {
            Intrinsics.checkNotNullExpressionValue((Object)$currentSegmentTimestamp, (String)"currentSegmentTimestamp");
            Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
            ReplayIntegration.createAndCaptureSegment$default(this$0, $duration, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, null, null, 192, null);
        }
        FileUtils.deleteRecursively((File)$replayCacheDir);
    }

    private static final void stop$lambda$8(IScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(SentryId.EMPTY_ID);
    }

    private static final void onScreenshotRecorded$lambda$9(ReplayIntegration this$0, Bitmap $bitmap, long $frameTimestamp, int $height, int $width) {
        block8: {
            long now;
            block9: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
                    ReplayCache replayCache = this$0.cache;
                    if (replayCache != null) {
                        replayCache.addFrame$sentry_android_replay_release($bitmap, $frameTimestamp);
                    }
                    now = this$0.dateProvider.getCurrentTimeMillis();
                    if (!this$0.isFullSession.get()) break block7;
                    long l = now - this$0.segmentTimestamp.get().getTime();
                    SentryOptions sentryOptions = this$0.options;
                    if (sentryOptions == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions = null;
                    }
                    if (l < sentryOptions.getExperimental().getSessionReplay().getSessionSegmentDuration()) break block7;
                    Date currentSegmentTimestamp = this$0.segmentTimestamp.get();
                    int segmentId = this$0.currentSegment.get();
                    SentryId replayId = this$0.currentReplayId.get();
                    SentryOptions sentryOptions2 = this$0.options;
                    if (sentryOptions2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions2 = null;
                    }
                    long l2 = sentryOptions2.getExperimental().getSessionReplay().getSessionSegmentDuration();
                    Intrinsics.checkNotNullExpressionValue((Object)currentSegmentTimestamp, (String)"currentSegmentTimestamp");
                    Intrinsics.checkNotNullExpressionValue((Object)replayId, (String)"replayId");
                    Long videoDuration = ReplayIntegration.createAndCaptureSegment$default(this$0, l2, currentSegmentTimestamp, replayId, segmentId, $height, $width, null, null, 192, null);
                    if (videoDuration == null) break block8;
                    this$0.currentSegment.getAndIncrement();
                    this$0.segmentTimestamp.set(DateUtils.getDateTime((long)(currentSegmentTimestamp.getTime() + videoDuration)));
                    break block8;
                }
                if (!this$0.isFullSession.get()) break block9;
                long l = now - this$0.replayStartTimestamp.get();
                SentryOptions sentryOptions = this$0.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                if (l < sentryOptions.getExperimental().getSessionReplay().getSessionDuration()) break block9;
                this$0.stop();
                SentryOptions sentryOptions3 = this$0.options;
                if (sentryOptions3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions3 = null;
                }
                sentryOptions3.getLogger().log(SentryLevel.INFO, "Session replay deadline exceeded (1h), stopping recording", new Object[0]);
                break block8;
            }
            if (this$0.isFullSession.get()) break block8;
            ReplayCache replayCache = this$0.cache;
            if (replayCache != null) {
                SentryOptions sentryOptions = this$0.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                replayCache.rotate(now - sentryOptions.getExperimental().getSessionReplay().getErrorReplayDuration());
            }
        }
    }

    private static final void onConfigurationChanged$lambda$15(ReplayIntegration this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $segmentId, int $height, int $width) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)$currentSegmentTimestamp, (String)"currentSegmentTimestamp");
        Intrinsics.checkNotNullExpressionValue((Object)$replayId, (String)"replayId");
        Long videoDuration = ReplayIntegration.createAndCaptureSegment$default(this$0, $duration, $currentSegmentTimestamp, $replayId, $segmentId, $height, $width, null, null, 192, null);
        if (videoDuration != null) {
            this$0.currentSegment.getAndIncrement();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/ReplayIntegration$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/ReplayIntegration$ReplayExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class ReplayExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryReplayIntegration-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

