/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.GeneratedVideo;
import io.sentry.android.replay.ReplayFrame;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.video.MuxerConfig;
import io.sentry.android.replay.video.SimpleVideoEncoder;
import io.sentry.protocol.SentryId;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bBl\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\n\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0016\u0010!\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&J\b\u0010)\u001a\u00020\"H\u0016J:\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0019H\u0002J\u000e\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020&R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000RS\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/sentry/android/replay/ReplayCache;", "Ljava/io/Closeable;", "options", "Lio/sentry/SentryOptions;", "replayId", "Lio/sentry/protocol/SentryId;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "(Lio/sentry/SentryOptions;Lio/sentry/protocol/SentryId;Lio/sentry/android/replay/ScreenshotRecorderConfig;)V", "encoderCreator", "Lkotlin/Function3;", "Ljava/io/File;", "Lkotlin/ParameterName;", "name", "videoFile", "", "height", "width", "Lio/sentry/android/replay/video/SimpleVideoEncoder;", "(Lio/sentry/SentryOptions;Lio/sentry/protocol/SentryId;Lio/sentry/android/replay/ScreenshotRecorderConfig;Lkotlin/jvm/functions/Function3;)V", "encoder", "encoderLock", "", "frames", "", "Lio/sentry/android/replay/ReplayFrame;", "getFrames$sentry_android_replay_release", "()Ljava/util/List;", "replayCacheDir", "getReplayCacheDir$sentry_android_replay_release", "()Ljava/io/File;", "replayCacheDir$delegate", "Lkotlin/Lazy;", "addFrame", "", "bitmap", "Landroid/graphics/Bitmap;", "frameTimestamp", "", "addFrame$sentry_android_replay_release", "screenshot", "close", "createVideoOf", "Lio/sentry/android/replay/GeneratedVideo;", "duration", "from", "segmentId", "deleteFile", "file", "encode", "", "frame", "rotate", "until", "sentry-android-replay_release"})
@SourceDebugExtension(value={"SMAP\nReplayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayCache.kt\nio/sentry/android/replay/ReplayCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class ReplayCache
implements Closeable {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final SentryId replayId;
    @NotNull
    private final ScreenshotRecorderConfig recorderConfig;
    @NotNull
    private final Function3<File, Integer, Integer, SimpleVideoEncoder> encoderCreator;
    @NotNull
    private final Object encoderLock;
    @Nullable
    private SimpleVideoEncoder encoder;
    @NotNull
    private final Lazy replayCacheDir$delegate;
    @NotNull
    private final List<ReplayFrame> frames;

    public ReplayCache(@NotNull SentryOptions options, @NotNull SentryId replayId, @NotNull ScreenshotRecorderConfig recorderConfig, @NotNull Function3<? super File, ? super Integer, ? super Integer, SimpleVideoEncoder> encoderCreator) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        Intrinsics.checkNotNullParameter(encoderCreator, (String)"encoderCreator");
        this.options = options;
        this.replayId = replayId;
        this.recorderConfig = recorderConfig;
        this.encoderCreator = encoderCreator;
        this.encoderLock = new Object();
        this.replayCacheDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ReplayCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final File invoke() {
                Object object;
                Object object2 = ReplayCache.access$getOptions$p(this.this$0).getCacheDirPath();
                if (object2 == null || object2.length() == 0) {
                    ReplayCache.access$getOptions$p(this.this$0).getLogger().log(SentryLevel.WARNING, "SentryOptions.cacheDirPath is not set, session replay is no-op", new Object[0]);
                    object = null;
                } else {
                    String string = ReplayCache.access$getOptions$p(this.this$0).getCacheDirPath();
                    Intrinsics.checkNotNull((Object)string);
                    Object it = object2 = new File(string, "replay_" + ReplayCache.access$getReplayId$p(this.this$0));
                    boolean bl = false;
                    ((File)it).mkdirs();
                    object = object2;
                }
                return object;
            }
        }));
        this.frames = new ArrayList();
    }

    public ReplayCache(final @NotNull SentryOptions options, @NotNull SentryId replayId, final @NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this(options, replayId, recorderConfig, (Function3<? super File, ? super Integer, ? super Integer, SimpleVideoEncoder>)((Function3)new Function3<File, Integer, Integer, SimpleVideoEncoder>(){

            @NotNull
            public final SimpleVideoEncoder invoke(@NotNull File videoFile, int height, int width) {
                SimpleVideoEncoder simpleVideoEncoder;
                Intrinsics.checkNotNullParameter((Object)videoFile, (String)"videoFile");
                int n = recorderConfig.getFrameRate();
                int n2 = recorderConfig.getBitRate();
                SimpleVideoEncoder it = simpleVideoEncoder = new SimpleVideoEncoder(options, new MuxerConfig(videoFile, width, height, n, n2, null, 32, null), null, 4, null);
                boolean bl = false;
                it.start();
                return simpleVideoEncoder;
            }
        }));
    }

    @Nullable
    public final File getReplayCacheDir$sentry_android_replay_release() {
        Lazy lazy = this.replayCacheDir$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final List<ReplayFrame> getFrames$sentry_android_replay_release() {
        return this.frames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFrame$sentry_android_replay_release(@NotNull Bitmap bitmap, long frameTimestamp) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.getReplayCacheDir$sentry_android_replay_release() == null) {
            return;
        }
        Object object = new File(this.getReplayCacheDir$sentry_android_replay_release(), frameTimestamp + ".jpg");
        File it = object;
        boolean bl = false;
        it.createNewFile();
        File screenshot = object;
        object = new FileOutputStream(screenshot);
        Throwable throwable = null;
        try {
            FileOutputStream it2 = (FileOutputStream)object;
            boolean bl2 = false;
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)it2);
            it2.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this.addFrame(screenshot, frameTimestamp);
    }

    public final void addFrame(@NotNull File screenshot, long frameTimestamp) {
        Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
        ReplayFrame frame = new ReplayFrame(screenshot, frameTimestamp);
        ((Collection)this.frames).add(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final GeneratedVideo createVideoOf(long duration, long from, int segmentId, int height, int width, @NotNull File videoFile) {
        SimpleVideoEncoder $i$a$-synchronized-ReplayCache$createVideoOf$32;
        Intrinsics.checkNotNullParameter((Object)videoFile, (String)"videoFile");
        if (this.frames.isEmpty()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "No captured frames, skipping generating a video segment", new Object[0]);
            return null;
        }
        Object object = this.encoderLock;
        ReplayCache replayCache = this;
        Object object2 = object;
        synchronized (object2) {
            boolean $i$a$-synchronized-ReplayCache$createVideoOf$32 = false;
            $i$a$-synchronized-ReplayCache$createVideoOf$32 = (SimpleVideoEncoder)this.encoderCreator.invoke((Object)videoFile, (Object)height, (Object)width);
        }
        replayCache.encoder = $i$a$-synchronized-ReplayCache$createVideoOf$32;
        long step = (long)1000 / (long)this.recorderConfig.getFrameRate();
        int frameCount = 0;
        ReplayFrame lastFrame = (ReplayFrame)CollectionsKt.first(this.frames);
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)from, (long)(from + duration))), (long)step);
        long timestamp = longProgression.getFirst();
        long l = longProgression.getLast();
        long l2 = longProgression.getStep();
        if (l2 > 0L && timestamp <= l || l2 < 0L && l <= timestamp) {
            while (true) {
                for (ReplayFrame frame : this.frames) {
                    long l3 = timestamp + step;
                    long l4 = frame.getTimestamp();
                    boolean bl = timestamp <= l4 ? l4 <= l3 : false;
                    if (bl) {
                        lastFrame = frame;
                        break;
                    }
                    if (frame.getTimestamp() <= timestamp + step) continue;
                }
                if (this.encode(lastFrame)) {
                    ++frameCount;
                }
                if (timestamp == l) break;
                timestamp += l2;
            }
        }
        if (frameCount == 0) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Generated a video with no frames, not capturing a replay segment", new Object[0]);
            this.deleteFile(videoFile);
            return null;
        }
        long videoDuration = 0L;
        Object object3 = this.encoderLock;
        synchronized (object3) {
            boolean bl = false;
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            SimpleVideoEncoder simpleVideoEncoder2 = this.encoder;
            videoDuration = simpleVideoEncoder2 != null ? simpleVideoEncoder2.getDuration() : 0L;
            this.encoder = null;
            Unit unit = Unit.INSTANCE;
        }
        this.rotate(from + duration);
        return new GeneratedVideo(videoFile, frameCount, videoDuration);
    }

    public static /* synthetic */ GeneratedVideo createVideoOf$default(ReplayCache replayCache, long l, long l2, int n, int n2, int n3, File file, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            file = new File(replayCache.getReplayCacheDir$sentry_android_replay_release(), n + ".mp4");
        }
        return replayCache.createVideoOf(l, l2, n, n2, n3, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean encode(ReplayFrame frame) {
        boolean bl;
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)frame.getScreenshot().getAbsolutePath());
            Object object = this.encoderLock;
            synchronized (object) {
                Unit unit;
                boolean bl2 = false;
                SimpleVideoEncoder simpleVideoEncoder = this.encoder;
                if (simpleVideoEncoder != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
                    simpleVideoEncoder.encode(bitmap);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            bitmap.recycle();
            bl = true;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Unable to decode bitmap and encode it into a video, skipping frame", e);
            bl = false;
        }
        return bl;
    }

    private final void deleteFile(File file) {
        try {
            if (!file.delete()) {
                Object[] objectArray = new Object[]{file.getAbsolutePath()};
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to delete replay frame: %s", objectArray);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            this.options.getLogger().log(SentryLevel.ERROR, e, "Failed to delete replay frame: %s", objectArray);
        }
    }

    public final void rotate(long until) {
        CollectionsKt.removeAll(this.frames, (Function1)((Function1)new Function1<ReplayFrame, Boolean>(until, this){
            final /* synthetic */ long $until;
            final /* synthetic */ ReplayCache this$0;
            {
                this.$until = $until;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ReplayFrame it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getTimestamp() < this.$until) {
                    ReplayCache.access$deleteFile(this.this$0, it.getScreenshot());
                    return true;
                }
                return false;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.encoderLock;
        synchronized (object) {
            boolean bl = false;
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            this.encoder = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$deleteFile(ReplayCache $this, File file) {
        $this.deleteFile(file);
    }

    public static final /* synthetic */ SentryOptions access$getOptions$p(ReplayCache $this) {
        return $this.options;
    }

    public static final /* synthetic */ SentryId access$getReplayId$p(ReplayCache $this) {
        return $this.replayId;
    }
}

