/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.Breadcrumb;
import io.sentry.ReplayBreadcrumbConverter;
import io.sentry.SentryLevel;
import io.sentry.android.replay.DefaultReplayBreadcrumbConverter;
import io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebSpanEvent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002J\f\u0010\u000b\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sentry/android/replay/DefaultReplayBreadcrumbConverter;", "Lio/sentry/ReplayBreadcrumbConverter;", "()V", "lastConnectivityState", "", "convert", "Lio/sentry/rrweb/RRWebEvent;", "breadcrumb", "Lio/sentry/Breadcrumb;", "isValidForRRWebSpan", "", "snakeToCamelCase", "toRRWebSpanEvent", "Lio/sentry/rrweb/RRWebSpanEvent;", "Companion", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultReplayBreadcrumbConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultReplayBreadcrumbConverter.kt\nio/sentry/android/replay/DefaultReplayBreadcrumbConverter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,167:1\n467#2,7:168\n*S KotlinDebug\n*F\n+ 1 DefaultReplayBreadcrumbConverter.kt\nio/sentry/android/replay/DefaultReplayBreadcrumbConverter\n*L\n96#1:168,7\n*E\n"})
public class DefaultReplayBreadcrumbConverter
implements ReplayBreadcrumbConverter {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private String lastConnectivityState;
    public static final int $stable;
    @NotNull
    private static final Lazy<Regex> snakecasePattern$delegate;
    @NotNull
    private static final HashSet<String> supportedNetworkData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public RRWebEvent convert(@NotNull Breadcrumb breadcrumb) {
        RRWebBreadcrumbEvent rRWebBreadcrumbEvent;
        Intrinsics.checkNotNullParameter((Object)breadcrumb, (String)"breadcrumb");
        String breadcrumbMessage = null;
        String breadcrumbCategory = null;
        SentryLevel breadcrumbLevel = null;
        Map breadcrumbData = new LinkedHashMap();
        if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"http")) {
            if (!this.isValidForRRWebSpan(breadcrumb)) return null;
            RRWebEvent rRWebEvent = (RRWebEvent)this.toRRWebSpanEvent(breadcrumb);
            return rRWebEvent;
        }
        if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation") && Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"app.lifecycle")) {
            breadcrumbCategory = "app." + breadcrumb.getData().get("state");
        } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation") && Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"device.orientation")) {
            String string = breadcrumb.getCategory();
            Intrinsics.checkNotNull((Object)string);
            breadcrumbCategory = string;
            Object v = breadcrumb.getData().get("position");
            if (!Intrinsics.areEqual(v, (Object)"landscape")) {
                if (!Intrinsics.areEqual(v, (Object)"portrait")) return null;
            }
            breadcrumbData.put("position", v);
        } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation")) {
            String string;
            breadcrumbCategory = "navigation";
            Map map = breadcrumbData;
            String string2 = "to";
            if (Intrinsics.areEqual(breadcrumb.getData().get("state"), (Object)"resumed")) {
                Object v = breadcrumb.getData().get("screen");
                if (!(v instanceof String)) return null;
                String string3 = (String)v;
                if (string3 == null) return null;
                string = StringsKt.substringAfterLast$default((String)string3, (char)'.', null, (int)2, null);
            } else {
                Map map2 = breadcrumb.getData();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"breadcrumb.data");
                Map map3 = map2;
                if (!map3.containsKey("to")) return null;
                Object v = breadcrumb.getData().get("to");
                if (!(v instanceof String)) return null;
                string = (String)v;
            }
            if (string == null) {
                return null;
            }
            String string4 = string;
            map.put(string2, string4);
        } else if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"ui.click")) {
            Object v;
            breadcrumbCategory = "ui.tap";
            Object v2 = breadcrumb.getData().get("view.id");
            if (v2 == null && (v2 = breadcrumb.getData().get("view.tag")) == null) {
                v2 = breadcrumb.getData().get("view.class");
            }
            if (!((v = v2) instanceof String)) return null;
            String string = (String)v;
            if (string == null) {
                return null;
            }
            breadcrumbMessage = string;
            Map map = breadcrumb.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"breadcrumb.data");
            breadcrumbData.putAll(map);
        } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"system") && Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"network.event")) {
            Object object;
            String string;
            breadcrumbCategory = "device.connectivity";
            Map map = breadcrumbData;
            String string5 = "state";
            if (Intrinsics.areEqual(breadcrumb.getData().get("action"), (Object)"NETWORK_LOST")) {
                string = "offline";
            } else {
                Map map4 = breadcrumb.getData();
                Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"breadcrumb.data");
                object = map4;
                if (!object.containsKey("network_type")) return null;
                object = breadcrumb.getData().get("network_type");
                object = object instanceof String ? (String)object : null;
                if (object == null) return null;
                if (object.length() == 0) {
                    return null;
                }
                boolean bl = false;
                if (bl) return null;
                string = breadcrumb.getData().get("network_type");
            }
            object = string;
            map.put(string5, object);
            if (Intrinsics.areEqual((Object)this.lastConnectivityState, breadcrumbData.get("state"))) {
                return null;
            }
            Object v = breadcrumbData.get("state");
            this.lastConnectivityState = v instanceof String ? (String)v : null;
        } else if (Intrinsics.areEqual(breadcrumb.getData().get("action"), (Object)"BATTERY_CHANGED")) {
            breadcrumbCategory = "device.battery";
            Map map = breadcrumb.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"breadcrumb.data");
            Map map5 = map;
            Map map6 = breadcrumbData;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : map5.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)"level") || Intrinsics.areEqual((Object)it, (Object)"charging"))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map6.putAll(result$iv);
        } else {
            breadcrumbCategory = breadcrumb.getCategory();
            breadcrumbMessage = breadcrumb.getMessage();
            breadcrumbLevel = breadcrumb.getLevel();
            Map map = breadcrumb.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"breadcrumb.data");
            breadcrumbData.putAll(map);
        }
        CharSequence charSequence = breadcrumbCategory;
        if (charSequence == null) return null;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        RRWebBreadcrumbEvent $this$convert_u24lambda_u241 = rRWebBreadcrumbEvent = new RRWebBreadcrumbEvent();
        boolean bl2 = false;
        $this$convert_u24lambda_u241.setTimestamp(breadcrumb.getTimestamp().getTime());
        $this$convert_u24lambda_u241.setBreadcrumbTimestamp((double)breadcrumb.getTimestamp().getTime() / 1000.0);
        $this$convert_u24lambda_u241.setBreadcrumbType("default");
        $this$convert_u24lambda_u241.setCategory(breadcrumbCategory);
        $this$convert_u24lambda_u241.setMessage(breadcrumbMessage);
        $this$convert_u24lambda_u241.setLevel(breadcrumbLevel);
        $this$convert_u24lambda_u241.setData(breadcrumbData);
        RRWebEvent rRWebEvent = (RRWebEvent)rRWebBreadcrumbEvent;
        return rRWebEvent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidForRRWebSpan(Breadcrumb $this$isValidForRRWebSpan) {
        Object v = $this$isValidForRRWebSpan.getData().get("url");
        CharSequence charSequence = v instanceof String ? (String)v : null;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        Map map = $this$isValidForRRWebSpan.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
        Map map2 = map;
        if (!map2.containsKey("http.start_timestamp")) return false;
        Map map3 = $this$isValidForRRWebSpan.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"data");
        Map map4 = map3;
        if (!map4.containsKey("http.end_timestamp")) return false;
        return true;
    }

    private final String snakeToCamelCase(String $this$snakeToCamelCase) {
        CharSequence charSequence = $this$snakeToCamelCase;
        Regex regex = DefaultReplayBreadcrumbConverter.Companion.getSnakecasePattern();
        Function1 function1 = snakeToCamelCase.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    private final RRWebSpanEvent toRRWebSpanEvent(Breadcrumb $this$toRRWebSpanEvent) {
        double d;
        double d2;
        RRWebSpanEvent rRWebSpanEvent;
        Breadcrumb breadcrumb = $this$toRRWebSpanEvent;
        Object httpStartTimestamp = breadcrumb.getData().get("http.start_timestamp");
        Object httpEndTimestamp = breadcrumb.getData().get("http.end_timestamp");
        RRWebSpanEvent $this$toRRWebSpanEvent_u24lambda_u242 = rRWebSpanEvent = new RRWebSpanEvent();
        boolean bl = false;
        $this$toRRWebSpanEvent_u24lambda_u242.setTimestamp(breadcrumb.getTimestamp().getTime());
        $this$toRRWebSpanEvent_u24lambda_u242.setOp("resource.http");
        Object v = breadcrumb.getData().get("url");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        $this$toRRWebSpanEvent_u24lambda_u242.setDescription((String)v);
        if (httpStartTimestamp instanceof Double) {
            d2 = ((Number)httpStartTimestamp).doubleValue() / 1000.0;
        } else {
            Intrinsics.checkNotNull(httpStartTimestamp, (String)"null cannot be cast to non-null type kotlin.Long");
            d2 = (double)((Long)httpStartTimestamp).longValue() / 1000.0;
        }
        $this$toRRWebSpanEvent_u24lambda_u242.setStartTimestamp(d2);
        if (httpEndTimestamp instanceof Double) {
            d = ((Number)httpEndTimestamp).doubleValue() / 1000.0;
        } else {
            Intrinsics.checkNotNull(httpEndTimestamp, (String)"null cannot be cast to non-null type kotlin.Long");
            d = (double)((Long)httpEndTimestamp).longValue() / 1000.0;
        }
        $this$toRRWebSpanEvent_u24lambda_u242.setEndTimestamp(d);
        Map breadcrumbData = new LinkedHashMap();
        Map map = breadcrumb.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"breadcrumb.data");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!supportedNetworkData.contains(key)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            breadcrumbData.put(this.snakeToCamelCase(StringsKt.substringAfter$default((String)StringsKt.replace$default((String)key, (String)"content_length", (String)"body_size", (boolean)false, (int)4, null), (String)".", null, (int)2, null)), value);
        }
        $this$toRRWebSpanEvent_u24lambda_u242.setData(breadcrumbData);
        return rRWebSpanEvent;
    }

    static {
        HashSet<String> hashSet;
        Companion = new Companion(null);
        $stable = 8;
        snakecasePattern$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.snakecasePattern.2.INSTANCE);
        HashSet<String> $this$supportedNetworkData_u24lambda_u243 = hashSet = new HashSet<String>();
        boolean bl = false;
        $this$supportedNetworkData_u24lambda_u243.add("status_code");
        $this$supportedNetworkData_u24lambda_u243.add("method");
        $this$supportedNetworkData_u24lambda_u243.add("response_content_length");
        $this$supportedNetworkData_u24lambda_u243.add("request_content_length");
        $this$supportedNetworkData_u24lambda_u243.add("http.response_content_length");
        $this$supportedNetworkData_u24lambda_u243.add("http.request_content_length");
        supportedNetworkData = hashSet;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/sentry/android/replay/DefaultReplayBreadcrumbConverter$Companion;", "", "()V", "snakecasePattern", "Lkotlin/text/Regex;", "getSnakecasePattern", "()Lkotlin/text/Regex;", "snakecasePattern$delegate", "Lkotlin/Lazy;", "supportedNetworkData", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Regex getSnakecasePattern() {
            Lazy lazy = snakecasePattern$delegate;
            return (Regex)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

