/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.capture;

import android.view.MotionEvent;
import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.ReplayRecording;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.GeneratedVideo;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.protocol.SentryId;
import io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebIncrementalSnapshotEvent;
import io.sentry.rrweb.RRWebInteractionEvent;
import io.sentry.rrweb.RRWebInteractionMoveEvent;
import io.sentry.rrweb.RRWebMetaEvent;
import io.sentry.rrweb.RRWebVideoEvent;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 i2\u00020\u0001:\u0003ijkBo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012:\b\u0002\u0010\f\u001a4\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u0012\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0013JP\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u0002072\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020G2\u0006\u0010M\u001a\u00020\"2\u0006\u0010N\u001a\u00020\"2\u0006\u0010O\u001a\u00020\"2\u0006\u0010P\u001a\u00020\"2\u0006\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020SH\u0002J\b\u0010T\u001a\u00020UH\u0016JB\u0010V\u001a\u00020K2\u0006\u0010Q\u001a\u0002012\u0006\u0010W\u001a\u00020G2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010M\u001a\u00020\"2\u0006\u0010N\u001a\u00020\"2\u0006\u0010O\u001a\u00020\"2\b\b\u0002\u0010R\u001a\u00020SH\u0004J\u0010\u0010X\u001a\u00020U2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010Y\u001a\u00020U2\u0006\u0010Z\u001a\u00020[H\u0016J\b\u0010\\\u001a\u00020UH\u0016J\b\u0010]\u001a\u00020UH\u0016J(\u0010^\u001a\u00020U2\u0006\u0010_\u001a\u0002012\u0016\b\u0002\u0010`\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020U\u0018\u00010aH\u0004J \u0010b\u001a\u00020U2\u0006\u0010M\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020dH\u0016J\b\u0010e\u001a\u00020UH\u0016J\u0014\u0010f\u001a\n\u0012\u0004\u0012\u00020h\u0018\u00010g*\u00020[H\u0002R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010 \u001a>\u0012\u0004\u0012\u00020\"\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%0!j\u001e\u0012\u0004\u0012\u00020\"\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010'\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010\u000e0\u000e0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u0001078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R@\u0010\f\u001a4\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\u0012\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010:\u001a\u00020\u000b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b;\u0010<R\u0014\u0010?\u001a\u00020@X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020D0(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010+R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020G0(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010+R\u000e\u0010I\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy;", "Lio/sentry/android/replay/capture/CaptureStrategy;", "options", "Lio/sentry/SentryOptions;", "hub", "Lio/sentry/IHub;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "replayCacheProvider", "Lkotlin/Function2;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "(Lio/sentry/SentryOptions;Lio/sentry/IHub;Lio/sentry/transport/ICurrentDateProvider;Lio/sentry/android/replay/ScreenshotRecorderConfig;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function2;)V", "cache", "getCache", "()Lio/sentry/android/replay/ReplayCache;", "setCache", "(Lio/sentry/android/replay/ReplayCache;)V", "currentEvents", "Ljava/util/LinkedList;", "Lio/sentry/rrweb/RRWebEvent;", "getCurrentEvents", "()Ljava/util/LinkedList;", "currentEventsLock", "", "currentPositions", "Ljava/util/LinkedHashMap;", "", "Ljava/util/ArrayList;", "Lio/sentry/rrweb/RRWebInteractionMoveEvent$Position;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/LinkedHashMap;", "currentReplayId", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "getCurrentReplayId", "()Ljava/util/concurrent/atomic/AtomicReference;", "currentSegment", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCurrentSegment", "()Ljava/util/concurrent/atomic/AtomicInteger;", "lastCapturedMoveEvent", "", "getRecorderConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "setRecorderConfig", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;)V", "replayCacheDir", "Ljava/io/File;", "getReplayCacheDir", "()Ljava/io/File;", "replayExecutor", "getReplayExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "replayExecutor$delegate", "Lkotlin/Lazy;", "replayStartTimestamp", "Ljava/util/concurrent/atomic/AtomicLong;", "getReplayStartTimestamp", "()Ljava/util/concurrent/atomic/AtomicLong;", "screenAtStart", "", "getScreenAtStart", "segmentTimestamp", "Ljava/util/Date;", "getSegmentTimestamp", "touchMoveBaseline", "buildReplay", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "video", "segmentId", "height", "width", "frameCount", "duration", "replayType", "Lio/sentry/SentryReplayEvent$ReplayType;", "close", "", "createSegment", "currentSegmentTimestamp", "onConfigurationChanged", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pause", "resume", "rotateCurrentEvents", "until", "callback", "Lkotlin/Function1;", "start", "cleanupOldReplays", "", "stop", "toRRWebIncrementalSnapshotEvent", "", "Lio/sentry/rrweb/RRWebIncrementalSnapshotEvent;", "Companion", "ReplayExecutorServiceThreadFactory", "ReplaySegment", "sentry-android-replay_release"})
@SourceDebugExtension(value={"SMAP\nBaseCaptureStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n1045#2:421\n1855#2,2:422\n1549#2:424\n1620#2,3:425\n1855#2,2:428\n*S KotlinDebug\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy\n*L\n227#1:421\n311#1:422,2\n339#1:424\n339#1:425,3\n194#1:428,2\n*E\n"})
public abstract class BaseCaptureStrategy
implements CaptureStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final IHub hub;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private ScreenshotRecorderConfig recorderConfig;
    @Nullable
    private final Function2<SentryId, ScreenshotRecorderConfig, ReplayCache> replayCacheProvider;
    @Nullable
    private ReplayCache cache;
    @NotNull
    private final AtomicReference<Date> segmentTimestamp;
    @NotNull
    private final AtomicLong replayStartTimestamp;
    @NotNull
    private final AtomicReference<String> screenAtStart;
    @NotNull
    private final AtomicReference<SentryId> currentReplayId;
    @NotNull
    private final AtomicInteger currentSegment;
    @NotNull
    private final LinkedList<RRWebEvent> currentEvents;
    @NotNull
    private final Object currentEventsLock;
    @NotNull
    private final LinkedHashMap<Integer, ArrayList<RRWebInteractionMoveEvent.Position>> currentPositions;
    private long touchMoveBaseline;
    private long lastCapturedMoveEvent;
    @NotNull
    private final Lazy replayExecutor$delegate;
    @NotNull
    private static final String TAG = "CaptureStrategy";
    private static final int TOUCH_MOVE_DEBOUNCE_THRESHOLD = 50;
    private static final int CAPTURE_MOVE_EVENT_THRESHOLD = 500;

    public BaseCaptureStrategy(@NotNull SentryOptions options, @Nullable IHub hub, @NotNull ICurrentDateProvider dateProvider, @NotNull ScreenshotRecorderConfig recorderConfig, @Nullable ScheduledExecutorService executor, @Nullable Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this.options = options;
        this.hub = hub;
        this.dateProvider = dateProvider;
        this.recorderConfig = recorderConfig;
        this.replayCacheProvider = replayCacheProvider;
        this.segmentTimestamp = new AtomicReference();
        this.replayStartTimestamp = new AtomicLong();
        this.screenAtStart = new AtomicReference();
        this.currentReplayId = new AtomicReference<SentryId>(SentryId.EMPTY_ID);
        this.currentSegment = new AtomicInteger(0);
        this.currentEvents = new LinkedList();
        this.currentEventsLock = new Object();
        this.currentPositions = new LinkedHashMap(10);
        this.replayExecutor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScheduledExecutorService>(executor){
            final /* synthetic */ ScheduledExecutorService $executor;
            {
                this.$executor = $executor;
                super(0);
            }

            public final ScheduledExecutorService invoke() {
                ScheduledExecutorService scheduledExecutorService = this.$executor;
                if (scheduledExecutorService == null) {
                    scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ReplayExecutorServiceThreadFactory());
                }
                return scheduledExecutorService;
            }
        }));
    }

    public /* synthetic */ BaseCaptureStrategy(SentryOptions sentryOptions, IHub iHub, ICurrentDateProvider iCurrentDateProvider, ScreenshotRecorderConfig screenshotRecorderConfig, ScheduledExecutorService scheduledExecutorService, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            scheduledExecutorService = null;
        }
        if ((n & 0x20) != 0) {
            function2 = null;
        }
        this(sentryOptions, iHub, iCurrentDateProvider, screenshotRecorderConfig, scheduledExecutorService, (Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache>)function2);
    }

    @NotNull
    protected final ScreenshotRecorderConfig getRecorderConfig() {
        return this.recorderConfig;
    }

    protected final void setRecorderConfig(@NotNull ScreenshotRecorderConfig screenshotRecorderConfig) {
        Intrinsics.checkNotNullParameter((Object)screenshotRecorderConfig, (String)"<set-?>");
        this.recorderConfig = screenshotRecorderConfig;
    }

    @Nullable
    protected final ReplayCache getCache() {
        return this.cache;
    }

    protected final void setCache(@Nullable ReplayCache replayCache) {
        this.cache = replayCache;
    }

    @NotNull
    protected final AtomicReference<Date> getSegmentTimestamp() {
        return this.segmentTimestamp;
    }

    @NotNull
    protected final AtomicLong getReplayStartTimestamp() {
        return this.replayStartTimestamp;
    }

    @NotNull
    protected final AtomicReference<String> getScreenAtStart() {
        return this.screenAtStart;
    }

    @Override
    @NotNull
    public AtomicReference<SentryId> getCurrentReplayId() {
        return this.currentReplayId;
    }

    @Override
    @NotNull
    public AtomicInteger getCurrentSegment() {
        return this.currentSegment;
    }

    @Override
    @Nullable
    public File getReplayCacheDir() {
        ReplayCache replayCache = this.cache;
        return replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
    }

    @NotNull
    protected final LinkedList<RRWebEvent> getCurrentEvents() {
        return this.currentEvents;
    }

    @NotNull
    protected final ScheduledExecutorService getReplayExecutor() {
        Lazy lazy = this.replayExecutor$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-replayExecutor>(...)");
        return (ScheduledExecutorService)object;
    }

    @Override
    public void start(int segmentId, @NotNull SentryId replayId, boolean cleanupOldReplays) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        this.getCurrentSegment().set(segmentId);
        this.getCurrentReplayId().set(replayId);
        if (cleanupOldReplays) {
            ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "CaptureStrategy.replays_cleanup", () -> BaseCaptureStrategy.start$lambda$2(this));
        }
        if ((object = this.replayCacheProvider) == null || (object = (ReplayCache)object.invoke((Object)replayId, (Object)this.recorderConfig)) == null) {
            object = new ReplayCache(this.options, replayId, this.recorderConfig);
        }
        this.cache = object;
        this.segmentTimestamp.set(DateUtils.getCurrentDateTime());
        this.replayStartTimestamp.set(this.dateProvider.getCurrentTimeMillis());
    }

    @Override
    public void resume() {
        this.segmentTimestamp.set(DateUtils.getCurrentDateTime());
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
        ReplayCache replayCache = this.cache;
        if (replayCache != null) {
            replayCache.close();
        }
        this.getCurrentSegment().set(0);
        this.replayStartTimestamp.set(0L);
        this.segmentTimestamp.set(null);
        this.getCurrentReplayId().set(SentryId.EMPTY_ID);
    }

    @NotNull
    protected final ReplaySegment createSegment(long duration, @NotNull Date currentSegmentTimestamp, @NotNull SentryId replayId, int segmentId, int height, int width, @NotNull SentryReplayEvent.ReplayType replayType) {
        Intrinsics.checkNotNullParameter((Object)currentSegmentTimestamp, (String)"currentSegmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
        Intrinsics.checkNotNullParameter((Object)replayType, (String)"replayType");
        Object object = this.cache;
        if (object == null || (object = ReplayCache.createVideoOf$default((ReplayCache)object, duration, currentSegmentTimestamp.getTime(), segmentId, height, width, null, 32, null)) == null) {
            return ReplaySegment.Failed.INSTANCE;
        }
        Object generatedVideo = object;
        File video = ((GeneratedVideo)generatedVideo).component1();
        int frameCount = ((GeneratedVideo)generatedVideo).component2();
        long videoDuration = ((GeneratedVideo)generatedVideo).component3();
        return this.buildReplay(video, replayId, currentSegmentTimestamp, segmentId, height, width, frameCount, videoDuration, replayType);
    }

    public static /* synthetic */ ReplaySegment createSegment$default(BaseCaptureStrategy baseCaptureStrategy, long l, Date date, SentryId sentryId, int n, int n2, int n3, SentryReplayEvent.ReplayType replayType, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSegment");
        }
        if ((n4 & 0x40) != 0) {
            replayType = SentryReplayEvent.ReplayType.SESSION;
        }
        return baseCaptureStrategy.createSegment(l, date, sentryId, n, n2, n3, replayType);
    }

    private final ReplaySegment buildReplay(File video, SentryId currentReplayId, Date segmentTimestamp, int segmentId, int height, int width, int frameCount, long duration, SentryReplayEvent.ReplayType replayType) {
        ReplayRecording replayRecording;
        Date date = DateUtils.getDateTime((long)(segmentTimestamp.getTime() + duration));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getDateTime(segmentTimestamp.time + duration)");
        Date endTimestamp = date;
        SentryReplayEvent sentryReplayEvent = new SentryReplayEvent();
        Object $this$buildReplay_u24lambda_u243 = sentryReplayEvent;
        boolean bl = false;
        $this$buildReplay_u24lambda_u243.setEventId(currentReplayId);
        $this$buildReplay_u24lambda_u243.setReplayId(currentReplayId);
        $this$buildReplay_u24lambda_u243.setSegmentId(segmentId);
        $this$buildReplay_u24lambda_u243.setTimestamp(endTimestamp);
        $this$buildReplay_u24lambda_u243.setReplayStartTimestamp(segmentTimestamp);
        $this$buildReplay_u24lambda_u243.setReplayType(replayType);
        $this$buildReplay_u24lambda_u243.setVideoFile(video);
        SentryReplayEvent replay = sentryReplayEvent;
        List recordingPayload = new ArrayList();
        $this$buildReplay_u24lambda_u243 = recordingPayload;
        RRWebMetaEvent $this$buildReplay_u24lambda_u244 = bl = new RRWebMetaEvent();
        boolean bl2 = false;
        $this$buildReplay_u24lambda_u244.setTimestamp(segmentTimestamp.getTime());
        $this$buildReplay_u24lambda_u244.setHeight(height);
        $this$buildReplay_u24lambda_u244.setWidth(width);
        $this$buildReplay_u24lambda_u243.add(bl);
        $this$buildReplay_u24lambda_u243 = recordingPayload;
        RRWebMetaEvent $this$buildReplay_u24lambda_u245 = bl = new RRWebVideoEvent();
        boolean bl3 = false;
        $this$buildReplay_u24lambda_u245.setTimestamp(segmentTimestamp.getTime());
        $this$buildReplay_u24lambda_u245.setSegmentId(segmentId);
        $this$buildReplay_u24lambda_u245.setDurationMs(duration);
        $this$buildReplay_u24lambda_u245.setFrameCount(frameCount);
        $this$buildReplay_u24lambda_u245.setSize(video.length());
        $this$buildReplay_u24lambda_u245.setFrameRate(this.recorderConfig.getFrameRate());
        $this$buildReplay_u24lambda_u245.setHeight(height);
        $this$buildReplay_u24lambda_u245.setWidth(width);
        $this$buildReplay_u24lambda_u245.setLeft(0);
        $this$buildReplay_u24lambda_u245.setTop(0);
        $this$buildReplay_u24lambda_u243.add(bl);
        LinkedList<String> urls = new LinkedList<String>();
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(arg_0 -> BaseCaptureStrategy.buildReplay$lambda$7(segmentTimestamp, endTimestamp, this, recordingPayload, urls, arg_0));
        }
        if (this.screenAtStart.get() != null && !Intrinsics.areEqual((Object)CollectionsKt.firstOrNull((List)urls), (Object)this.screenAtStart.get())) {
            urls.addFirst(this.screenAtStart.get());
        }
        this.rotateCurrentEvents(endTimestamp.getTime(), (Function1<? super RRWebEvent, Unit>)((Function1)new Function1<RRWebEvent, Unit>(segmentTimestamp, (List<RRWebEvent>)recordingPayload){
            final /* synthetic */ Date $segmentTimestamp;
            final /* synthetic */ List<RRWebEvent> $recordingPayload;
            {
                this.$segmentTimestamp = $segmentTimestamp;
                this.$recordingPayload = $recordingPayload;
                super(1);
            }

            public final void invoke(@NotNull RRWebEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getTimestamp() >= this.$segmentTimestamp.getTime()) {
                    ((Collection)this.$recordingPayload).add(event);
                }
            }
        }));
        ReplayRecording $this$buildReplay_u24lambda_u249 = replayRecording = new ReplayRecording();
        boolean bl4 = false;
        $this$buildReplay_u24lambda_u249.setSegmentId(Integer.valueOf(segmentId));
        Iterable $this$sortedBy$iv = recordingPayload;
        boolean $i$f$sortedBy = false;
        $this$buildReplay_u24lambda_u249.setPayload(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RRWebEvent it = (RRWebEvent)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTimestamp());
                it = (RRWebEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
            }
        }));
        ReplayRecording recording = replayRecording;
        replay.setUrls((List)urls);
        return new ReplaySegment.Created(duration, replay, recording);
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this.recorderConfig = recorderConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List<RRWebIncrementalSnapshotEvent> rrwebEvents = this.toRRWebIncrementalSnapshotEvent(event);
        if (rrwebEvents != null) {
            Object object = this.currentEventsLock;
            synchronized (object) {
                boolean bl = false;
                CollectionsKt.addAll((Collection)this.currentEvents, (Iterable)rrwebEvents);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    public void close() {
        ExecutorsKt.gracefullyShutdown(this.getReplayExecutor(), this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void rotateCurrentEvents(long until, @Nullable Function1<? super RRWebEvent, Unit> callback) {
        Object object = this.currentEventsLock;
        synchronized (object) {
            boolean bl = false;
            RRWebEvent event = this.currentEvents.peek();
            while (event != null && event.getTimestamp() < until) {
                Function1<? super RRWebEvent, Unit> function1 = callback;
                if (function1 != null) {
                    function1.invoke((Object)event);
                }
                this.currentEvents.remove();
                event = this.currentEvents.peek();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void rotateCurrentEvents$default(BaseCaptureStrategy baseCaptureStrategy, long l, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rotateCurrentEvents");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        baseCaptureStrategy.rotateCurrentEvents(l, (Function1<? super RRWebEvent, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RRWebIncrementalSnapshotEvent> toRRWebIncrementalSnapshotEvent(MotionEvent $this$toRRWebIncrementalSnapshotEvent) {
        List list;
        MotionEvent event = $this$toRRWebIncrementalSnapshotEvent;
        switch (event.getActionMasked()) {
            case 2: {
                List list2;
                RRWebInteractionMoveEvent.Position position;
                Collection collection;
                long now = this.dateProvider.getCurrentTimeMillis();
                if (this.lastCapturedMoveEvent != 0L && this.lastCapturedMoveEvent + (long)50 > now) {
                    return null;
                }
                this.lastCapturedMoveEvent = now;
                Set<Integer> set = this.currentPositions.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"currentPositions.keys");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Integer pId = (Integer)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)pId, (String)"pId");
                    int pIndex = event.findPointerIndex(pId.intValue());
                    if (pIndex == -1) continue;
                    if (this.touchMoveBaseline == 0L) {
                        this.touchMoveBaseline = now;
                    }
                    ArrayList<RRWebInteractionMoveEvent.Position> arrayList = this.currentPositions.get(pId);
                    Intrinsics.checkNotNull(arrayList);
                    collection = arrayList;
                    RRWebInteractionMoveEvent.Position $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2413_u24lambda_u2412 = position = new RRWebInteractionMoveEvent.Position();
                    boolean bl2 = false;
                    $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2413_u24lambda_u2412.setX(event.getX(pIndex) * this.recorderConfig.getScaleFactorX());
                    $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2413_u24lambda_u2412.setY(event.getY(pIndex) * this.recorderConfig.getScaleFactorY());
                    $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2413_u24lambda_u2412.setId(0);
                    $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2413_u24lambda_u2412.setTimeOffset(now - this.touchMoveBaseline);
                    collection.add(position);
                }
                long totalOffset = now - this.touchMoveBaseline;
                if (totalOffset > 500L) {
                    List moveEvents = new ArrayList();
                    for (Map.Entry entry : ((Map)this.currentPositions).entrySet()) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        int pointerId = ((Number)entry.getKey()).intValue();
                        ArrayList positions = (ArrayList)entry.getValue();
                        if (!(!((Collection)positions).isEmpty())) continue;
                        collection = moveEvents;
                        RRWebInteractionMoveEvent.Position $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2415 = position = new RRWebInteractionMoveEvent();
                        boolean bl = false;
                        $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2415.setTimestamp(now);
                        Iterable iterable = positions;
                        RRWebInteractionMoveEvent.Position position2 = $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2415;
                        boolean $i$f$map = false;
                        void var19_30 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void pos;
                            RRWebInteractionMoveEvent.Position position3 = (RRWebInteractionMoveEvent.Position)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl3 = false;
                            pos.setTimeOffset(pos.getTimeOffset() - totalOffset);
                            collection2.add(pos);
                        }
                        position2.setPositions((List)destination$iv$iv);
                        $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2415.setPointerId(pointerId);
                        collection.add(position);
                        ArrayList<RRWebInteractionMoveEvent.Position> arrayList = this.currentPositions.get(pointerId);
                        Intrinsics.checkNotNull(arrayList);
                        arrayList.clear();
                    }
                    this.touchMoveBaseline = 0L;
                    list2 = moveEvents;
                } else {
                    list2 = null;
                }
                return list2;
            }
            case 0: 
            case 5: {
                RRWebInteractionEvent totalOffset;
                int pId = event.getPointerId(event.getActionIndex());
                int pIndex = event.findPointerIndex(pId);
                if (pIndex == -1) {
                    return null;
                }
                Integer $i$f$forEach = pId;
                ((Map)this.currentPositions).put($i$f$forEach, new ArrayList());
                RRWebInteractionEvent $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416 = totalOffset = new RRWebInteractionEvent();
                boolean bl = false;
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416.setTimestamp(this.dateProvider.getCurrentTimeMillis());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416.setX(event.getX(pIndex) * this.recorderConfig.getScaleFactorX());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416.setY(event.getY(pIndex) * this.recorderConfig.getScaleFactorY());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416.setId(0);
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416.setPointerId(pId);
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2416.setInteractionType(RRWebInteractionEvent.InteractionType.TouchStart);
                list = CollectionsKt.listOf((Object)totalOffset);
                break;
            }
            case 1: 
            case 6: {
                RRWebInteractionEvent totalOffset;
                int pId = event.getPointerId(event.getActionIndex());
                int pIndex = event.findPointerIndex(pId);
                if (pIndex == -1) {
                    return null;
                }
                this.currentPositions.remove(pId);
                RRWebInteractionEvent $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417 = totalOffset = new RRWebInteractionEvent();
                boolean bl = false;
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417.setTimestamp(this.dateProvider.getCurrentTimeMillis());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417.setX(event.getX(pIndex) * this.recorderConfig.getScaleFactorX());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417.setY(event.getY(pIndex) * this.recorderConfig.getScaleFactorY());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417.setId(0);
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417.setPointerId(pId);
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2417.setInteractionType(RRWebInteractionEvent.InteractionType.TouchEnd);
                list = CollectionsKt.listOf((Object)totalOffset);
                break;
            }
            case 3: {
                RRWebInteractionEvent rRWebInteractionEvent;
                this.currentPositions.clear();
                RRWebInteractionEvent $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418 = rRWebInteractionEvent = new RRWebInteractionEvent();
                boolean bl = false;
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418.setTimestamp(this.dateProvider.getCurrentTimeMillis());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418.setX(event.getX() * this.recorderConfig.getScaleFactorX());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418.setY(event.getY() * this.recorderConfig.getScaleFactorY());
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418.setId(0);
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418.setPointerId(0);
                $this$toRRWebIncrementalSnapshotEvent_u24lambda_u2418.setInteractionType(RRWebInteractionEvent.InteractionType.TouchCancel);
                list = CollectionsKt.listOf((Object)rRWebInteractionEvent);
                break;
            }
            default: {
                list = null;
            }
        }
        return list;
    }

    @Override
    public void onScreenChanged(@Nullable String screen) {
        CaptureStrategy.DefaultImpls.onScreenChanged(this, screen);
    }

    private static final boolean start$lambda$2$lambda$1$lambda$0(BaseCaptureStrategy this$0, File dir, String name) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (StringsKt.startsWith$default((String)name, (String)"replay_", (boolean)false, (int)2, null)) {
            CharSequence charSequence = name;
            String string = this$0.getCurrentReplayId().get().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentReplayId.get().toString()");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                FileUtils.deleteRecursively((File)new File(dir, name));
            }
        }
        return false;
    }

    private static final void start$lambda$2(BaseCaptureStrategy this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            String string = this$0.options.getCacheDirPath();
            if (string == null) break block0;
            String cacheDir = string;
            boolean bl = false;
            new File(cacheDir).listFiles((arg_0, arg_1) -> BaseCaptureStrategy.start$lambda$2$lambda$1$lambda$0(this$0, arg_0, arg_1));
        }
    }

    private static final void buildReplay$lambda$7(Date $segmentTimestamp, Date $endTimestamp, BaseCaptureStrategy this$0, List $recordingPayload, LinkedList $urls, IScope scope) {
        Intrinsics.checkNotNullParameter((Object)$segmentTimestamp, (String)"$segmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)$endTimestamp, (String)"$endTimestamp");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$recordingPayload, (String)"$recordingPayload");
        Intrinsics.checkNotNullParameter((Object)$urls, (String)"$urls");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Queue queue = scope.getBreadcrumbs();
        Intrinsics.checkNotNullExpressionValue((Object)queue, (String)"scope.breadcrumbs");
        Iterable $this$forEach$iv = queue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RRWebEvent rrwebEvent;
            Breadcrumb breadcrumb = (Breadcrumb)element$iv;
            boolean bl = false;
            if (breadcrumb.getTimestamp().getTime() < $segmentTimestamp.getTime() || breadcrumb.getTimestamp().getTime() >= $endTimestamp.getTime() || (rrwebEvent = this$0.options.getReplayController().getBreadcrumbConverter().convert(breadcrumb)) == null) continue;
            ((Collection)$recordingPayload).add(rrwebEvent);
            RRWebBreadcrumbEvent rRWebBreadcrumbEvent = rrwebEvent instanceof RRWebBreadcrumbEvent ? (RRWebBreadcrumbEvent)rrwebEvent : null;
            if (!Intrinsics.areEqual((Object)(rRWebBreadcrumbEvent != null ? rRWebBreadcrumbEvent.getCategory() : null), (Object)"navigation")) continue;
            Map map = ((RRWebBreadcrumbEvent)rrwebEvent).getData();
            Intrinsics.checkNotNull((Object)map);
            Object v = map.get("to");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            $urls.add((String)v);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "", "()V", "Created", "Failed", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Failed;", "sentry-android-replay_release"})
    protected static abstract class ReplaySegment {
        private ReplaySegment() {
        }

        public /* synthetic */ ReplaySegment(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Failed;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "()V", "sentry-android-replay_release"})
        public static final class Failed
        extends ReplaySegment {
            @NotNull
            public static final Failed INSTANCE = new Failed();

            private Failed() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001eJ\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment;", "videoDuration", "", "replay", "Lio/sentry/SentryReplayEvent;", "recording", "Lio/sentry/ReplayRecording;", "(JLio/sentry/SentryReplayEvent;Lio/sentry/ReplayRecording;)V", "getRecording", "()Lio/sentry/ReplayRecording;", "getReplay", "()Lio/sentry/SentryReplayEvent;", "getVideoDuration", "()J", "capture", "", "hub", "Lio/sentry/IHub;", "hint", "Lio/sentry/Hint;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "setSegmentId", "segmentId", "toString", "", "sentry-android-replay_release"})
        @SourceDebugExtension(value={"SMAP\nBaseCaptureStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,420:1\n1#2:421\n1855#3,2:422\n*S KotlinDebug\n*F\n+ 1 BaseCaptureStrategy.kt\nio/sentry/android/replay/capture/BaseCaptureStrategy$ReplaySegment$Created\n*L\n291#1:422,2\n*E\n"})
        public static final class Created
        extends ReplaySegment {
            private final long videoDuration;
            @NotNull
            private final SentryReplayEvent replay;
            @NotNull
            private final ReplayRecording recording;

            public Created(long videoDuration, @NotNull SentryReplayEvent replay, @NotNull ReplayRecording recording) {
                Intrinsics.checkNotNullParameter((Object)replay, (String)"replay");
                Intrinsics.checkNotNullParameter((Object)recording, (String)"recording");
                super(null);
                this.videoDuration = videoDuration;
                this.replay = replay;
                this.recording = recording;
            }

            public final long getVideoDuration() {
                return this.videoDuration;
            }

            @NotNull
            public final SentryReplayEvent getReplay() {
                return this.replay;
            }

            @NotNull
            public final ReplayRecording getRecording() {
                return this.recording;
            }

            /*
             * WARNING - void declaration
             */
            public final void capture(@Nullable IHub hub, @NotNull Hint hint) {
                block0: {
                    void $this$capture_u24lambda_u240;
                    Hint hint2;
                    Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
                    IHub iHub = hub;
                    if (iHub == null) break block0;
                    Hint hint3 = hint2 = hint;
                    SentryReplayEvent sentryReplayEvent = this.replay;
                    IHub iHub2 = iHub;
                    boolean bl = false;
                    $this$capture_u24lambda_u240.setReplayRecording(this.recording);
                    Unit unit = Unit.INSTANCE;
                    iHub2.captureReplay(sentryReplayEvent, hint2);
                }
            }

            public static /* synthetic */ void capture$default(Created created, IHub iHub, Hint hint, int n, Object object) {
                if ((n & 2) != 0) {
                    hint = new Hint();
                }
                created.capture(iHub, hint);
            }

            public final void setSegmentId(int segmentId) {
                block1: {
                    this.replay.setSegmentId(segmentId);
                    List list = this.recording.getPayload();
                    if (list == null) break block1;
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RRWebEvent it = (RRWebEvent)element$iv;
                        boolean bl = false;
                        if (!(it instanceof RRWebVideoEvent)) continue;
                        ((RRWebVideoEvent)it).setSegmentId(segmentId);
                    }
                }
            }

            public final long component1() {
                return this.videoDuration;
            }

            @NotNull
            public final SentryReplayEvent component2() {
                return this.replay;
            }

            @NotNull
            public final ReplayRecording component3() {
                return this.recording;
            }

            @NotNull
            public final Created copy(long videoDuration, @NotNull SentryReplayEvent replay, @NotNull ReplayRecording recording) {
                Intrinsics.checkNotNullParameter((Object)replay, (String)"replay");
                Intrinsics.checkNotNullParameter((Object)recording, (String)"recording");
                return new Created(videoDuration, replay, recording);
            }

            public static /* synthetic */ Created copy$default(Created created, long l, SentryReplayEvent sentryReplayEvent, ReplayRecording replayRecording, int n, Object object) {
                if ((n & 1) != 0) {
                    l = created.videoDuration;
                }
                if ((n & 2) != 0) {
                    sentryReplayEvent = created.replay;
                }
                if ((n & 4) != 0) {
                    replayRecording = created.recording;
                }
                return created.copy(l, sentryReplayEvent, replayRecording);
            }

            @NotNull
            public String toString() {
                return "Created(videoDuration=" + this.videoDuration + ", replay=" + this.replay + ", recording=" + this.recording + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.videoDuration);
                result = result * 31 + this.replay.hashCode();
                result = result * 31 + this.recording.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Created)) {
                    return false;
                }
                Created created = (Created)other;
                if (this.videoDuration != created.videoDuration) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.replay, (Object)created.replay)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.recording, (Object)created.recording);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$Companion;", "", "()V", "CAPTURE_MOVE_EVENT_THRESHOLD", "", "TAG", "", "TOUCH_MOVE_DEBOUNCE_THRESHOLD", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/capture/BaseCaptureStrategy$ReplayExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class ReplayExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryReplayIntegration-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

