/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.instrumentation.util;

import io.sentry.android.gradle.instrumentation.util.FieldUtilsKt;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\fH\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0006*\u00020\nH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0004*\u00020\nH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"MINIFIED_CLASSNAME_REGEX", "Lkotlin/text/Regex;", "MINIFIED_CLASSNAME_SENTRY_REGEX", "classNameLooksMinified", "", "simpleClassName", "", "fullClassName", "isR8Minified", "classReader", "Lorg/objectweb/asm/ClassReader;", "findClassReader", "Lorg/objectweb/asm/ClassWriter;", "findClassWriter", "Lorg/objectweb/asm/ClassVisitor;", "getSimpleClassName", "isMinifiedClass", "sentry-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nConstantPoolHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantPoolHelpers.kt\nio/sentry/android/gradle/instrumentation/util/ConstantPoolHelpersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class ConstantPoolHelpersKt {
    private static final Regex MINIFIED_CLASSNAME_REGEX;
    private static final Regex MINIFIED_CLASSNAME_SENTRY_REGEX;

    @Nullable
    public static final ClassWriter findClassWriter(@NotNull ClassVisitor $this$findClassWriter) {
        Intrinsics.checkNotNullParameter((Object)$this$findClassWriter, (String)"$this$findClassWriter");
        ClassVisitor classWriter = $this$findClassWriter;
        while (!ClassWriter.class.isAssignableFrom(classWriter.getClass())) {
            Object object;
            try {
                Object v0;
                block7: {
                    object = FieldUtilsKt.getAllFields(classWriter.getClass());
                    Iterable iterable = object;
                    for (Object t : iterable) {
                        Field it = (Field)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"cv")) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                Field field = v0;
                if (field == null) {
                    return null;
                }
                object = field;
            }
            catch (Throwable e) {
                return null;
            }
            Object cvField = object;
            ((Field)cvField).setAccessible(true);
            Object object2 = ((Field)cvField).get(classWriter);
            if (!(object2 instanceof ClassVisitor)) {
                object2 = null;
            }
            if ((ClassVisitor)object2 != null) continue;
            return null;
        }
        ClassVisitor classVisitor = classWriter;
        if (classVisitor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.ClassWriter");
        }
        return (ClassWriter)classVisitor;
    }

    @Nullable
    public static final ClassReader findClassReader(@NotNull ClassWriter $this$findClassReader) {
        Field field;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$findClassReader, (String)"$this$findClassReader");
        Class<?> clazz = $this$findClassReader.getClass();
        try {
            Object v0;
            block7: {
                object = FieldUtilsKt.getAllFields(clazz);
                Iterable iterable = object;
                for (Object t : iterable) {
                    Field it = (Field)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"symbolTable")) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            Field field2 = v0;
            if (field2 == null) {
                return null;
            }
            object = field2;
        }
        catch (Throwable e) {
            return null;
        }
        Object symbolTableField = object;
        ((Field)symbolTableField).setAccessible(true);
        Object symbolTable = ((Field)symbolTableField).get($this$findClassReader);
        try {
            Field field3 = symbolTable.getClass().getDeclaredField("sourceClassReader");
            Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"symbolTable::class.java.\u2026ield(\"sourceClassReader\")");
            field = field3;
        }
        catch (Throwable e) {
            return null;
        }
        Field classReaderField = field;
        classReaderField.setAccessible(true);
        Object object2 = classReaderField.get(symbolTable);
        if (!(object2 instanceof ClassReader)) {
            object2 = null;
        }
        return (ClassReader)object2;
    }

    @NotNull
    public static final String getSimpleClassName(@NotNull ClassReader $this$getSimpleClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSimpleClassName, (String)"$this$getSimpleClassName");
        String string = $this$getSimpleClassName.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        return StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isMinifiedClass(@NotNull ClassReader $this$isMinifiedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isMinifiedClass, (String)"$this$isMinifiedClass");
        if (ConstantPoolHelpersKt.isR8Minified($this$isMinifiedClass)) return true;
        String string = ConstantPoolHelpersKt.getSimpleClassName($this$isMinifiedClass);
        String string2 = $this$isMinifiedClass.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.className");
        if (!ConstantPoolHelpersKt.classNameLooksMinified(string, string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isR8Minified(ClassReader classReader) {
        char[] charBuffer = new char[classReader.getMaxStringLength()];
        int n = 10;
        int n2 = classReader.getItemCount();
        int poolSize = Math.min(n, n2);
        n = 1;
        n2 = poolSize;
        while (n < n2) {
            void i;
            try {
                Object constantPoolEntry = classReader.readConst((int)i, charBuffer);
                if (constantPoolEntry instanceof String && StringsKt.contains$default((CharSequence)((CharSequence)constantPoolEntry), (CharSequence)"~~R8", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }

    public static final boolean classNameLooksMinified(@NotNull String simpleClassName, @NotNull String fullClassName) {
        char c;
        Intrinsics.checkNotNullParameter((Object)simpleClassName, (String)"simpleClassName");
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        CharSequence charSequence = simpleClassName;
        return charSequence.length() > 0 && Character.isLowerCase(c = simpleClassName.charAt(0)) && (MINIFIED_CLASSNAME_REGEX.matches((CharSequence)simpleClassName) || MINIFIED_CLASSNAME_SENTRY_REGEX.matches((CharSequence)fullClassName));
    }

    static {
        String string = "^(((([a-zA-z])\\4{1,}|[a-zA-Z]{1,2})([0-9]{1,})?(([a-zA-Z])\\7{1,})?)|([a-zA-Z]([0-9])?))(\\$((((\\w)\\14{1,}|[a-zA-Z]{1,2})([0-9]{1,})?(([a-zA-Z])\\17{1,})?)|(\\w([0-9])?)))*$";
        MINIFIED_CLASSNAME_REGEX = new Regex(string);
        string = "^(([\\w\\$]\\/[\\w\\$]{1,2})|([\\w\\$]{2}\\/[\\w\\$]\\/[\\w\\$]))(\\/|$)";
        MINIFIED_CLASSNAME_SENTRY_REGEX = new Regex(string);
    }
}

