/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.fragment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.fragment.SentryFragmentLifecycleCallbacks;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/sentry/android/fragment/FragmentLifecycleIntegration;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "enableFragmentLifecycleBreadcrumbs", "", "enableAutoFragmentLifecycleTracing", "(Landroid/app/Application;ZZ)V", "hub", "Lio/sentry/IHub;", "options", "Lio/sentry/SentryOptions;", "close", "", "onActivityCreated", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "register", "sentry-android-fragment_release"})
public final class FragmentLifecycleIntegration
implements Application.ActivityLifecycleCallbacks,
Integration,
Closeable {
    private IHub hub;
    private SentryOptions options;
    private final Application application;
    private final boolean enableFragmentLifecycleBreadcrumbs;
    private final boolean enableAutoFragmentLifecycleTracing;

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.hub = hub;
        this.options = options;
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        options.getLogger().log(SentryLevel.DEBUG, "FragmentLifecycleIntegration installed.", new Object[0]);
    }

    @Override
    public void close() {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.options != null) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "FragmentLifecycleIntegration removed.", new Object[0]);
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        block2: {
            FragmentActivity fragmentActivity;
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Activity activity2 = activity;
            if (!(activity2 instanceof FragmentActivity)) {
                activity2 = null;
            }
            if ((fragmentActivity = (FragmentActivity)activity2) == null || (fragmentActivity = fragmentActivity.getSupportFragmentManager()) == null) break block2;
            IHub iHub = this.hub;
            if (iHub == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hub");
            }
            fragmentActivity.registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)new SentryFragmentLifecycleCallbacks(iHub, this.enableFragmentLifecycleBreadcrumbs, this.enableAutoFragmentLifecycleTracing), true);
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public FragmentLifecycleIntegration(@NotNull Application application, boolean enableFragmentLifecycleBreadcrumbs, boolean enableAutoFragmentLifecycleTracing) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
        this.enableFragmentLifecycleBreadcrumbs = enableFragmentLifecycleBreadcrumbs;
        this.enableAutoFragmentLifecycleTracing = enableAutoFragmentLifecycleTracing;
    }

    public FragmentLifecycleIntegration(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this(application, true, false);
    }

    public static final /* synthetic */ SentryOptions access$getOptions$p(FragmentLifecycleIntegration $this) {
        SentryOptions sentryOptions = $this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        return sentryOptions;
    }

    public static final /* synthetic */ void access$setOptions$p(FragmentLifecycleIntegration $this, SentryOptions sentryOptions) {
        $this.options = sentryOptions;
    }
}

