/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.fragment;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.fragment.SentryFragmentLifecycleCallbacks;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/sentry/android/fragment/FragmentLifecycleIntegration;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "hub", "Lio/sentry/IHub;", "logger", "Lio/sentry/ILogger;", "close", "", "onActivityCreated", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "register", "options", "Lio/sentry/SentryOptions;", "sentry-android-fragment_release"})
public final class FragmentLifecycleIntegration
implements Application.ActivityLifecycleCallbacks,
Integration,
Closeable {
    private IHub hub;
    private ILogger logger;
    private final Application application;

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.hub = hub;
        ILogger iLogger = options.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)iLogger, (String)"options.logger");
        this.logger = iLogger;
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        ILogger iLogger2 = this.logger;
        if (iLogger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        iLogger2.log(SentryLevel.DEBUG, "FragmentLifecycleIntegration installed.", new Object[0]);
    }

    @Override
    public void close() {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        if (this.logger != null) {
            ILogger iLogger = this.logger;
            if (iLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            iLogger.log(SentryLevel.DEBUG, "FragmentLifecycleIntegration removed.", new Object[0]);
        }
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        block2: {
            FragmentActivity fragmentActivity;
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Activity activity2 = activity;
            if (!(activity2 instanceof FragmentActivity)) {
                activity2 = null;
            }
            if ((fragmentActivity = (FragmentActivity)activity2) == null || (fragmentActivity = fragmentActivity.getSupportFragmentManager()) == null) break block2;
            IHub iHub = this.hub;
            if (iHub == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hub");
            }
            fragmentActivity.registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)new SentryFragmentLifecycleCallbacks(iHub), true);
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public FragmentLifecycleIntegration(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(FragmentLifecycleIntegration $this) {
        ILogger iLogger = $this.logger;
        if (iLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return iLogger;
    }

    public static final /* synthetic */ void access$setLogger$p(FragmentLifecycleIntegration $this, ILogger iLogger) {
        $this.logger = iLogger;
    }
}

