/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.util.SparseIntArray;
import androidx.core.app.FrameMetricsAggregator;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.LoadClass;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class ActivityFramesTracker {
    @Nullable
    private FrameMetricsAggregator frameMetricsAggregator = null;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final @NotNull Map<SentryId, Map<String, @NotNull MeasurementValue>> activityMeasurements = new ConcurrentHashMap<SentryId, Map<String, MeasurementValue>>();
    @NotNull
    private final Map<Activity, FrameCounts> frameCountAtStartSnapshots = new WeakHashMap<Activity, FrameCounts>();
    @NotNull
    private final MainLooperHandler handler;
    @NotNull
    protected AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    public ActivityFramesTracker(@NotNull LoadClass loadClass, @NotNull SentryAndroidOptions options, @NotNull MainLooperHandler handler) {
        boolean androidXAvailable = loadClass.isClassAvailable("androidx.core.app.FrameMetricsAggregator", options.getLogger());
        if (androidXAvailable) {
            this.frameMetricsAggregator = new FrameMetricsAggregator();
        }
        this.options = options;
        this.handler = handler;
    }

    public ActivityFramesTracker(@NotNull LoadClass loadClass, @NotNull SentryAndroidOptions options) {
        this(loadClass, options, new MainLooperHandler());
    }

    @TestOnly
    ActivityFramesTracker(@NotNull LoadClass loadClass, @NotNull SentryAndroidOptions options, @NotNull MainLooperHandler handler, @Nullable FrameMetricsAggregator frameMetricsAggregator) {
        this(loadClass, options, handler);
        this.frameMetricsAggregator = frameMetricsAggregator;
    }

    @VisibleForTesting
    public boolean isFrameMetricsAggregatorAvailable() {
        return this.frameMetricsAggregator != null && this.options.isEnableFramesTracking() && !this.options.isEnablePerformanceV2();
    }

    public void addActivity(@NotNull Activity activity) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (!this.isFrameMetricsAggregatorAvailable()) {
                return;
            }
            this.runSafelyOnUiThread(() -> this.frameMetricsAggregator.add(activity), "FrameMetricsAggregator.add");
            this.snapshotFrameCountsAtStart(activity);
        }
    }

    private void snapshotFrameCountsAtStart(@NotNull Activity activity) {
        FrameCounts frameCounts = this.calculateCurrentFrameCounts();
        if (frameCounts != null) {
            this.frameCountAtStartSnapshots.put(activity, frameCounts);
        }
    }

    @Nullable
    private FrameCounts calculateCurrentFrameCounts() {
        SparseIntArray totalIndexArray;
        if (!this.isFrameMetricsAggregatorAvailable()) {
            return null;
        }
        if (this.frameMetricsAggregator == null) {
            return null;
        }
        @Nullable SparseIntArray[] framesRates = this.frameMetricsAggregator.getMetrics();
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        if (framesRates != null && framesRates.length > 0 && (totalIndexArray = framesRates[0]) != null) {
            for (int i = 0; i < totalIndexArray.size(); ++i) {
                int frameTime = totalIndexArray.keyAt(i);
                int numFrames = totalIndexArray.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                    continue;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        return new FrameCounts(totalFrames, slowFrames, frozenFrames);
    }

    public void setMetrics(@NotNull Activity activity, @NotNull SentryId transactionId) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (!this.isFrameMetricsAggregatorAvailable()) {
                return;
            }
            this.runSafelyOnUiThread(() -> this.frameMetricsAggregator.remove(activity), null);
            @Nullable FrameCounts frameCounts = this.diffFrameCountsAtEnd(activity);
            if (frameCounts == null || frameCounts.totalFrames == 0 && frameCounts.slowFrames == 0 && frameCounts.frozenFrames == 0) {
                return;
            }
            MeasurementValue tfValues = new MeasurementValue((Number)frameCounts.totalFrames, "none");
            MeasurementValue sfValues = new MeasurementValue((Number)frameCounts.slowFrames, "none");
            MeasurementValue ffValues = new MeasurementValue((Number)frameCounts.frozenFrames, "none");
            HashMap<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
            measurements.put("frames_total", tfValues);
            measurements.put("frames_slow", sfValues);
            measurements.put("frames_frozen", ffValues);
            this.activityMeasurements.put(transactionId, measurements);
        }
    }

    @Nullable
    private FrameCounts diffFrameCountsAtEnd(@NotNull Activity activity) {
        @Nullable FrameCounts frameCountsAtStart = this.frameCountAtStartSnapshots.remove(activity);
        if (frameCountsAtStart == null) {
            return null;
        }
        @Nullable FrameCounts frameCountsAtEnd = this.calculateCurrentFrameCounts();
        if (frameCountsAtEnd == null) {
            return null;
        }
        int diffTotalFrames = frameCountsAtEnd.totalFrames - frameCountsAtStart.totalFrames;
        int diffSlowFrames = frameCountsAtEnd.slowFrames - frameCountsAtStart.slowFrames;
        int diffFrozenFrames = frameCountsAtEnd.frozenFrames - frameCountsAtStart.frozenFrames;
        return new FrameCounts(diffTotalFrames, diffSlowFrames, diffFrozenFrames);
    }

    public @Nullable Map<String, @NotNull MeasurementValue> takeMetrics(@NotNull SentryId transactionId) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (!this.isFrameMetricsAggregatorAvailable()) {
                Map<String, MeasurementValue> map = null;
                return map;
            }
            Map<String, @NotNull MeasurementValue> stringMeasurementValueMap = this.activityMeasurements.get(transactionId);
            this.activityMeasurements.remove(transactionId);
            Map<String, MeasurementValue> map = stringMeasurementValueMap;
            return map;
        }
    }

    public void stop() {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.isFrameMetricsAggregatorAvailable()) {
                this.runSafelyOnUiThread(() -> this.frameMetricsAggregator.stop(), "FrameMetricsAggregator.stop");
                this.frameMetricsAggregator.reset();
            }
            this.activityMeasurements.clear();
        }
    }

    private void runSafelyOnUiThread(Runnable runnable, String tag) {
        block4: {
            try {
                if (AndroidThreadChecker.getInstance().isMainThread()) {
                    runnable.run();
                } else {
                    this.handler.post(() -> {
                        block2: {
                            try {
                                runnable.run();
                            }
                            catch (Throwable ignored) {
                                if (tag == null) break block2;
                                this.options.getLogger().log(SentryLevel.WARNING, "Failed to execute " + tag, new Object[0]);
                            }
                        }
                    });
                }
            }
            catch (Throwable ignored) {
                if (tag == null) break block4;
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to execute " + tag, new Object[0]);
            }
        }
    }

    private static final class FrameCounts {
        private final int totalFrames;
        private final int slowFrames;
        private final int frozenFrames;

        private FrameCounts(int totalFrames, int slowFrames, int frozenFrames) {
            this.totalFrames = totalFrames;
            this.slowFrames = slowFrames;
            this.frozenFrames = frozenFrames;
        }
    }
}

