/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.performance;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.app.ApplicationStartInfo;
import android.content.ContentProvider;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.sentry.IContinuousProfiler;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ITransactionProfiler;
import io.sentry.NoOpLogger;
import io.sentry.TracesSamplingDecision;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.FirstDrawDoneListener;
import io.sentry.android.core.performance.ActivityLifecycleCallbacksAdapter;
import io.sentry.android.core.performance.ActivityLifecycleTimeSpan;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.LazyEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class AppStartMetrics
extends ActivityLifecycleCallbacksAdapter {
    private static long CLASS_LOADED_UPTIME_MS = SystemClock.uptimeMillis();
    @Nullable
    private static volatile AppStartMetrics instance;
    @NotNull
    public static final AutoClosableReentrantLock staticLock;
    @NotNull
    private AppStartType appStartType = AppStartType.UNKNOWN;
    private final LazyEvaluator<Boolean> appLaunchedInForeground = new LazyEvaluator((LazyEvaluator.Evaluator)new LazyEvaluator.Evaluator<Boolean>(){

        @NotNull
        public Boolean evaluate() {
            return ContextUtils.isForegroundImportance();
        }
    });
    private volatile long firstIdle = -1L;
    @NotNull
    private final TimeSpan appStartSpan;
    @NotNull
    private final TimeSpan sdkInitTimeSpan;
    @NotNull
    private final TimeSpan applicationOnCreate;
    @NotNull
    private final Map<ContentProvider, TimeSpan> contentProviderOnCreates;
    @NotNull
    private final List<ActivityLifecycleTimeSpan> activityLifecycles;
    @Nullable
    private ITransactionProfiler appStartProfiler = null;
    @Nullable
    private IContinuousProfiler appStartContinuousProfiler = null;
    @Nullable
    private TracesSamplingDecision appStartSamplingDecision = null;
    private boolean isCallbackRegistered = false;
    private boolean shouldSendStartMeasurements = true;
    private final AtomicInteger activeActivitiesCounter = new AtomicInteger();
    private final AtomicBoolean firstDrawDone = new AtomicBoolean(false);

    @NotNull
    public static AppStartMetrics getInstance() {
        if (instance == null) {
            try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
                if (instance == null) {
                    instance = new AppStartMetrics();
                }
            }
        }
        return instance;
    }

    public AppStartMetrics() {
        this.appStartSpan = new TimeSpan();
        this.sdkInitTimeSpan = new TimeSpan();
        this.applicationOnCreate = new TimeSpan();
        this.contentProviderOnCreates = new HashMap<ContentProvider, TimeSpan>();
        this.activityLifecycles = new ArrayList<ActivityLifecycleTimeSpan>();
    }

    @NotNull
    public TimeSpan getAppStartTimeSpan() {
        return this.appStartSpan;
    }

    @NotNull
    public TimeSpan createProcessInitSpan() {
        @NotNull TimeSpan processInitSpan = new TimeSpan();
        processInitSpan.setup("Process Initialization", this.appStartSpan.getStartTimestampMs(), this.appStartSpan.getStartUptimeMs(), CLASS_LOADED_UPTIME_MS);
        return processInitSpan;
    }

    @NotNull
    public TimeSpan getSdkInitTimeSpan() {
        return this.sdkInitTimeSpan;
    }

    @NotNull
    public TimeSpan getApplicationOnCreateTimeSpan() {
        return this.applicationOnCreate;
    }

    public void setAppStartType(@NotNull AppStartType appStartType) {
        this.appStartType = appStartType;
    }

    @NotNull
    public AppStartType getAppStartType() {
        return this.appStartType;
    }

    public boolean isAppLaunchedInForeground() {
        return (Boolean)this.appLaunchedInForeground.getValue();
    }

    @VisibleForTesting
    public void setAppLaunchedInForeground(boolean appLaunchedInForeground) {
        this.appLaunchedInForeground.setValue((Object)appLaunchedInForeground);
    }

    @NotNull
    public List<TimeSpan> getContentProviderOnCreateTimeSpans() {
        ArrayList<TimeSpan> spans = new ArrayList<TimeSpan>(this.contentProviderOnCreates.values());
        Collections.sort(spans);
        return spans;
    }

    @NotNull
    public List<ActivityLifecycleTimeSpan> getActivityLifecycleTimeSpans() {
        ArrayList<ActivityLifecycleTimeSpan> spans = new ArrayList<ActivityLifecycleTimeSpan>(this.activityLifecycles);
        Collections.sort(spans);
        return spans;
    }

    public void addActivityLifecycleTimeSpans(@NotNull ActivityLifecycleTimeSpan timeSpan) {
        this.activityLifecycles.add(timeSpan);
    }

    public void onAppStartSpansSent() {
        this.shouldSendStartMeasurements = false;
        this.contentProviderOnCreates.clear();
        this.activityLifecycles.clear();
    }

    public boolean shouldSendStartMeasurements() {
        return this.shouldSendStartMeasurements && (Boolean)this.appLaunchedInForeground.getValue() != false;
    }

    public long getClassLoadedUptimeMs() {
        return CLASS_LOADED_UPTIME_MS;
    }

    @NotNull
    public TimeSpan getAppStartTimeSpanWithFallback(@NotNull SentryAndroidOptions options) {
        if (this.appStartType != AppStartType.UNKNOWN && ((Boolean)this.appLaunchedInForeground.getValue()).booleanValue()) {
            TimeSpan appStartSpan;
            if (options.isEnablePerformanceV2() && (appStartSpan = this.getAppStartTimeSpan()).hasStarted() && appStartSpan.getDurationMs() <= TimeUnit.MINUTES.toMillis(1L)) {
                return appStartSpan;
            }
            @NotNull TimeSpan sdkInitTimeSpan = this.getSdkInitTimeSpan();
            if (sdkInitTimeSpan.hasStarted() && sdkInitTimeSpan.getDurationMs() <= TimeUnit.MINUTES.toMillis(1L)) {
                return sdkInitTimeSpan;
            }
        }
        return new TimeSpan();
    }

    @TestOnly
    void setFirstIdle(long firstIdle) {
        this.firstIdle = firstIdle;
    }

    @TestOnly
    long getFirstIdle() {
        return this.firstIdle;
    }

    @TestOnly
    public void clear() {
        this.appStartType = AppStartType.UNKNOWN;
        this.appStartSpan.reset();
        this.sdkInitTimeSpan.reset();
        this.applicationOnCreate.reset();
        this.contentProviderOnCreates.clear();
        this.activityLifecycles.clear();
        if (this.appStartProfiler != null) {
            this.appStartProfiler.close();
        }
        this.appStartProfiler = null;
        if (this.appStartContinuousProfiler != null) {
            this.appStartContinuousProfiler.close(true);
        }
        this.appStartContinuousProfiler = null;
        this.appStartSamplingDecision = null;
        this.appLaunchedInForeground.resetValue();
        this.isCallbackRegistered = false;
        this.shouldSendStartMeasurements = true;
        this.firstDrawDone.set(false);
        this.activeActivitiesCounter.set(0);
        this.firstIdle = -1L;
    }

    @Nullable
    public ITransactionProfiler getAppStartProfiler() {
        return this.appStartProfiler;
    }

    public void setAppStartProfiler(@Nullable ITransactionProfiler appStartProfiler) {
        this.appStartProfiler = appStartProfiler;
    }

    @Nullable
    public IContinuousProfiler getAppStartContinuousProfiler() {
        return this.appStartContinuousProfiler;
    }

    public void setAppStartContinuousProfiler(@Nullable IContinuousProfiler appStartContinuousProfiler) {
        this.appStartContinuousProfiler = appStartContinuousProfiler;
    }

    public void setAppStartSamplingDecision(@Nullable TracesSamplingDecision appStartSamplingDecision) {
        this.appStartSamplingDecision = appStartSamplingDecision;
    }

    @Nullable
    public TracesSamplingDecision getAppStartSamplingDecision() {
        return this.appStartSamplingDecision;
    }

    @TestOnly
    @ApiStatus.Internal
    public void setClassLoadedUptimeMs(long classLoadedUptimeMs) {
        CLASS_LOADED_UPTIME_MS = classLoadedUptimeMs;
    }

    public static void onApplicationCreate(@NotNull Application application) {
        long now = SystemClock.uptimeMillis();
        @NotNull AppStartMetrics instance = AppStartMetrics.getInstance();
        if (instance.applicationOnCreate.hasNotStarted()) {
            instance.applicationOnCreate.setStartedAt(now);
            instance.registerLifecycleCallbacks(application);
        }
    }

    public static void onApplicationPostCreate(@NotNull Application application) {
        long now = SystemClock.uptimeMillis();
        @NotNull AppStartMetrics instance = AppStartMetrics.getInstance();
        if (instance.applicationOnCreate.hasNotStopped()) {
            instance.applicationOnCreate.setDescription(application.getClass().getName() + ".onCreate");
            instance.applicationOnCreate.setStoppedAt(now);
        }
    }

    public void registerLifecycleCallbacks(@NotNull Application application) {
        ApplicationStartInfo info;
        List historicalProcessStartReasons;
        if (this.isCallbackRegistered) {
            return;
        }
        this.isCallbackRegistered = true;
        this.appLaunchedInForeground.resetValue();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        ActivityManager activityManager = (ActivityManager)application.getSystemService("activity");
        if (activityManager != null && Build.VERSION.SDK_INT >= 35 && !(historicalProcessStartReasons = activityManager.getHistoricalProcessStartReasons(1)).isEmpty() && (info = (ApplicationStartInfo)historicalProcessStartReasons.get(0)).getStartupState() == 0) {
            this.appStartType = info.getStartType() == 1 ? AppStartType.COLD : AppStartType.WARM;
        }
        if (this.appStartType == AppStartType.UNKNOWN && Build.VERSION.SDK_INT >= 23) {
            Looper.getMainLooper().getQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                public boolean queueIdle() {
                    AppStartMetrics.this.firstIdle = SystemClock.uptimeMillis();
                    AppStartMetrics.this.checkCreateTimeOnMain();
                    return false;
                }
            });
        } else if (this.appStartType == AppStartType.UNKNOWN) {
            final Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    AppStartMetrics.this.firstIdle = SystemClock.uptimeMillis();
                    handler.post(() -> AppStartMetrics.this.checkCreateTimeOnMain());
                }
            });
        }
    }

    private void checkCreateTimeOnMain() {
        if (this.activeActivitiesCounter.get() == 0) {
            this.appLaunchedInForeground.setValue((Object)false);
            if (this.appStartProfiler != null && this.appStartProfiler.isRunning()) {
                this.appStartProfiler.close();
                this.appStartProfiler = null;
            }
            if (this.appStartContinuousProfiler != null && this.appStartContinuousProfiler.isRunning()) {
                this.appStartContinuousProfiler.close(true);
                this.appStartContinuousProfiler = null;
            }
        }
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        long activityCreatedUptimeMillis = SystemClock.uptimeMillis();
        CurrentActivityHolder.getInstance().setActivity(activity);
        if (this.activeActivitiesCounter.incrementAndGet() == 1 && !this.firstDrawDone.get()) {
            long nowUptimeMs = SystemClock.uptimeMillis();
            long durationSinceAppStartMillis = nowUptimeMs - this.appStartSpan.getStartUptimeMs();
            if (!((Boolean)this.appLaunchedInForeground.getValue()).booleanValue() || durationSinceAppStartMillis > TimeUnit.MINUTES.toMillis(1L)) {
                this.appStartType = AppStartType.WARM;
                this.shouldSendStartMeasurements = true;
                this.appStartSpan.reset();
                this.appStartSpan.setStartedAt(activityCreatedUptimeMillis);
                CLASS_LOADED_UPTIME_MS = activityCreatedUptimeMillis;
                this.contentProviderOnCreates.clear();
                this.applicationOnCreate.reset();
            } else if (this.appStartType == AppStartType.UNKNOWN) {
                this.appStartType = savedInstanceState != null ? AppStartType.WARM : (this.firstIdle != -1L && activityCreatedUptimeMillis > this.firstIdle ? AppStartType.WARM : AppStartType.COLD);
            }
        }
        this.appLaunchedInForeground.setValue((Object)true);
    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        CurrentActivityHolder.getInstance().setActivity(activity);
        if (this.firstDrawDone.get()) {
            return;
        }
        if (activity.getWindow() != null) {
            FirstDrawDoneListener.registerForNextDraw(activity, () -> this.onFirstFrameDrawn(), new BuildInfoProvider((ILogger)NoOpLogger.getInstance()));
        } else {
            new Handler(Looper.getMainLooper()).post(() -> this.onFirstFrameDrawn());
        }
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {
        CurrentActivityHolder.getInstance().setActivity(activity);
    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {
        CurrentActivityHolder.getInstance().clearActivity(activity);
    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {
        CurrentActivityHolder.getInstance().clearActivity(activity);
    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {
        CurrentActivityHolder.getInstance().clearActivity(activity);
        int remainingActivities = this.activeActivitiesCounter.decrementAndGet();
        if (remainingActivities == 0 && !activity.isChangingConfigurations()) {
            this.appStartType = AppStartType.WARM;
            this.appLaunchedInForeground.setValue((Object)true);
            this.shouldSendStartMeasurements = true;
            this.firstDrawDone.set(false);
        }
    }

    public static void onContentProviderCreate(@NotNull ContentProvider contentProvider) {
        long now = SystemClock.uptimeMillis();
        TimeSpan measurement = new TimeSpan();
        measurement.setStartedAt(now);
        AppStartMetrics.getInstance().contentProviderOnCreates.put(contentProvider, measurement);
    }

    public static void onContentProviderPostCreate(@NotNull ContentProvider contentProvider) {
        long now = SystemClock.uptimeMillis();
        TimeSpan measurement = AppStartMetrics.getInstance().contentProviderOnCreates.get(contentProvider);
        if (measurement != null && measurement.hasNotStopped()) {
            measurement.setDescription(contentProvider.getClass().getName() + ".onCreate");
            measurement.setStoppedAt(now);
        }
    }

    synchronized void onFirstFrameDrawn() {
        if (!this.firstDrawDone.getAndSet(true)) {
            @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
            appStartMetrics.getSdkInitTimeSpan().stop();
            appStartMetrics.getAppStartTimeSpan().stop();
        }
    }

    static {
        staticLock = new AutoClosableReentrantLock();
    }

    public static enum AppStartType {
        UNKNOWN,
        COLD,
        WARM;

    }
}

