/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.PerformanceCollectionData;
import io.sentry.ProfilingTraceData;
import io.sentry.ProfilingTransactionData;
import io.sentry.ScopesAdapter;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.AndroidProfiler;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidTransactionProfiler
implements ITransactionProfiler {
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;
    @Nullable
    private final String profilingTracesDirPath;
    private final boolean isProfilingEnabled;
    private final int profilingTracesHz;
    @NotNull
    private final LazyEvaluator.Evaluator<ISentryExecutorService> executorServiceSupplier;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    private boolean isInitialized = false;
    @NotNull
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    @NotNull
    private final SentryFrameMetricsCollector frameMetricsCollector;
    @Nullable
    private volatile ProfilingTransactionData currentProfilingTransactionData;
    @Nullable
    private volatile AndroidProfiler profiler = null;
    private long profileStartNanos;
    private long profileStartCpuMillis;
    @NotNull
    private Date profileStartTimestamp;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull SentryAndroidOptions sentryAndroidOptions, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector) {
        this(context, buildInfoProvider, frameMetricsCollector, sentryAndroidOptions.getLogger(), sentryAndroidOptions.getProfilingTracesDirPath(), sentryAndroidOptions.isProfilingEnabled(), sentryAndroidOptions.getProfilingTracesHz(), (LazyEvaluator.Evaluator<ISentryExecutorService>)((LazyEvaluator.Evaluator)() -> sentryAndroidOptions.getExecutorService()));
    }

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull ILogger logger, @Nullable String profilingTracesDirPath, boolean isProfilingEnabled, int profilingTracesHz, @NotNull ISentryExecutorService executorService) {
        this(context, buildInfoProvider, frameMetricsCollector, logger, profilingTracesDirPath, isProfilingEnabled, profilingTracesHz, (LazyEvaluator.Evaluator<ISentryExecutorService>)((LazyEvaluator.Evaluator)() -> executorService));
    }

    public AndroidTransactionProfiler(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull SentryFrameMetricsCollector frameMetricsCollector, @NotNull ILogger logger, @Nullable String profilingTracesDirPath, boolean isProfilingEnabled, int profilingTracesHz, @NotNull LazyEvaluator.Evaluator<ISentryExecutorService> executorServiceSupplier) {
        this.context = (Context)Objects.requireNonNull((Object)ContextUtils.getApplicationContext(context), (String)"The application context is required");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"ILogger is required");
        this.frameMetricsCollector = (SentryFrameMetricsCollector)Objects.requireNonNull((Object)frameMetricsCollector, (String)"SentryFrameMetricsCollector is required");
        this.buildInfoProvider = (BuildInfoProvider)Objects.requireNonNull((Object)buildInfoProvider, (String)"The BuildInfoProvider is required.");
        this.profilingTracesDirPath = profilingTracesDirPath;
        this.isProfilingEnabled = isProfilingEnabled;
        this.profilingTracesHz = profilingTracesHz;
        this.executorServiceSupplier = (LazyEvaluator.Evaluator)Objects.requireNonNull(executorServiceSupplier, (String)"A supplier for ISentryExecutorService is required.");
        this.profileStartTimestamp = DateUtils.getCurrentDateTime();
    }

    private void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        if (!this.isProfilingEnabled) {
            this.logger.log(SentryLevel.INFO, "Profiling is disabled in options.", new Object[0]);
            return;
        }
        if (this.profilingTracesDirPath == null) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because no profiling traces dir path is defined in options.", new Object[0]);
            return;
        }
        if (this.profilingTracesHz <= 0) {
            this.logger.log(SentryLevel.WARNING, "Disabling profiling because trace rate is set to %d", new Object[]{this.profilingTracesHz});
            return;
        }
        this.profiler = new AndroidProfiler(this.profilingTracesDirPath, (int)TimeUnit.SECONDS.toMicros(1L) / this.profilingTracesHz, this.frameMetricsCollector, this.executorServiceSupplier, this.logger);
    }

    public void start() {
        if (this.buildInfoProvider.getSdkInfoVersion() < 22) {
            return;
        }
        if (!this.isRunning.getAndSet(true)) {
            this.init();
            if (this.onFirstStart()) {
                this.logger.log(SentryLevel.DEBUG, "Profiler started.", new Object[0]);
            } else if (this.profiler != null && this.profiler.isRunning()) {
                this.logger.log(SentryLevel.WARNING, "A profile is already running. This profile will be ignored.", new Object[0]);
            } else {
                try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
                    this.currentProfilingTransactionData = null;
                }
                this.isRunning.set(false);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean onFirstStart() {
        if (this.profiler == null) {
            return false;
        }
        AndroidProfiler.ProfileStartData startData = this.profiler.start();
        if (startData == null) {
            return false;
        }
        this.profileStartNanos = startData.startNanos;
        this.profileStartCpuMillis = startData.startCpuMillis;
        this.profileStartTimestamp = startData.startTimestamp;
        return true;
    }

    public void bindTransaction(@NotNull ITransaction transaction) {
        if (this.isRunning.get() && this.currentProfilingTransactionData == null) {
            try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
                if (this.isRunning.get() && this.currentProfilingTransactionData == null) {
                    this.currentProfilingTransactionData = new ProfilingTransactionData(transaction, Long.valueOf(this.profileStartNanos), Long.valueOf(this.profileStartCpuMillis));
                }
            }
        }
    }

    @Nullable
    public ProfilingTraceData onTransactionFinish(@NotNull ITransaction transaction, @Nullable List<PerformanceCollectionData> performanceCollectionData, @NotNull SentryOptions options) {
        return this.onTransactionFinish(transaction.getName(), transaction.getEventId().toString(), transaction.getSpanContext().getTraceId().toString(), false, performanceCollectionData, options);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    private ProfilingTraceData onTransactionFinish(@NotNull String transactionName, @NotNull String transactionId, @NotNull String traceId, boolean isTimeout, @Nullable List<PerformanceCollectionData> performanceCollectionData, @NotNull SentryOptions options) {
        Long memory;
        ProfilingTransactionData txData;
        if (this.buildInfoProvider.getSdkInfoVersion() < 22) {
            return null;
        }
        if (this.profiler == null) {
            return null;
        }
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            txData = this.currentProfilingTransactionData;
            if (txData == null || !txData.getId().equals(transactionId)) {
                this.logger.log(SentryLevel.INFO, "Transaction %s (%s) finished, but was not currently being profiled. Skipping", new Object[]{transactionName, traceId});
                ProfilingTraceData profilingTraceData = null;
                return profilingTraceData;
            }
            this.currentProfilingTransactionData = null;
        }
        this.logger.log(SentryLevel.DEBUG, "Transaction %s (%s) finished.", new Object[]{transactionName, traceId});
        AndroidProfiler.ProfileEndData endData = this.profiler.endAndCollect(false, performanceCollectionData);
        this.isRunning.set(false);
        if (endData == null) {
            return null;
        }
        long transactionDurationNanos = endData.endNanos - this.profileStartNanos;
        @NotNull ArrayList<ProfilingTransactionData> transactionList = new ArrayList<ProfilingTransactionData>(1);
        transactionList.add(txData);
        txData.notifyFinish(Long.valueOf(endData.endNanos), Long.valueOf(this.profileStartNanos), Long.valueOf(endData.endCpuMillis), Long.valueOf(this.profileStartCpuMillis));
        String totalMem = "0";
        Long l = memory = options instanceof SentryAndroidOptions ? DeviceInfoUtil.getInstance(this.context, (SentryAndroidOptions)options).getTotalMemory() : null;
        if (memory != null) {
            totalMem = Long.toString(memory);
        }
        String[] abis = Build.SUPPORTED_ABIS;
        return new ProfilingTraceData(endData.traceFile, this.profileStartTimestamp, transactionList, transactionName, transactionId, traceId, Long.toString(transactionDurationNanos), this.buildInfoProvider.getSdkInfoVersion(), abis != null && abis.length > 0 ? abis[0] : "", () -> CpuInfoUtils.getInstance().readMaxFrequencies(), this.buildInfoProvider.getManufacturer(), this.buildInfoProvider.getModel(), this.buildInfoProvider.getVersionRelease(), this.buildInfoProvider.isEmulator(), totalMem, options.getProguardUuid(), options.getRelease(), options.getEnvironment(), endData.didTimeout || isTimeout ? "timeout" : "normal", endData.measurementsMap);
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void close() {
        @Nullable ProfilingTransactionData txData = this.currentProfilingTransactionData;
        if (txData != null) {
            this.onTransactionFinish(txData.getName(), txData.getId(), txData.getTraceId(), true, null, ScopesAdapter.getInstance().getOptions());
        }
        this.isRunning.set(false);
        if (this.profiler != null) {
            this.profiler.close();
        }
    }
}

