/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.cache;

import io.sentry.Hint;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.android.core.AnrV2Integration;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.TombstoneIntegration;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.cache.EnvelopeCache;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AndroidEnvelopeCache
extends EnvelopeCache {
    public static final String LAST_ANR_REPORT = "last_anr_report";
    public static final String LAST_TOMBSTONE_REPORT = "last_tombstone_report";
    @NotNull
    private final ICurrentDateProvider currentDateProvider;
    public static final String LAST_TOMBSTONE_MARKER_LABEL = "Tombstone";
    public static final String LAST_ANR_MARKER_LABEL = "ANR";
    private static final List<TimestampMarkerHandler<?>> TIMESTAMP_MARKER_HANDLERS = Arrays.asList(new TimestampMarkerHandler<AnrV2Integration.AnrV2Hint>(AnrV2Integration.AnrV2Hint.class, "ANR", "last_anr_report", anrV2Hint -> anrV2Hint.timestamp()), new TimestampMarkerHandler<TombstoneIntegration.TombstoneHint>(TombstoneIntegration.TombstoneHint.class, "Tombstone", "last_tombstone_report", tombstoneHint -> tombstoneHint.timestamp()));

    public AndroidEnvelopeCache(@NotNull SentryAndroidOptions options) {
        this(options, AndroidCurrentDateProvider.getInstance());
    }

    AndroidEnvelopeCache(@NotNull SentryAndroidOptions options, @NotNull ICurrentDateProvider currentDateProvider) {
        super((SentryOptions)options, (String)Objects.requireNonNull((Object)options.getCacheDirPath(), (String)"cacheDirPath must not be null"), options.getMaxCacheItems());
        this.currentDateProvider = currentDateProvider;
    }

    public void store(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        this.storeInternalAndroid(envelope, hint);
    }

    public boolean storeEnvelope(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        return this.storeInternalAndroid(envelope, hint);
    }

    private boolean storeInternalAndroid(@NotNull SentryEnvelope envelope, @NotNull Hint hint) {
        long timeSinceSdkInit;
        boolean didStore = super.storeEnvelope(envelope, hint);
        SentryAndroidOptions options = (SentryAndroidOptions)this.options;
        TimeSpan sdkInitTimeSpan = AppStartMetrics.getInstance().getSdkInitTimeSpan();
        if (HintUtils.hasType((Hint)hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class) && sdkInitTimeSpan.hasStarted() && (timeSinceSdkInit = this.currentDateProvider.getCurrentTimeMillis() - sdkInitTimeSpan.getStartUptimeMs()) <= options.getStartupCrashDurationThresholdMillis()) {
            options.getLogger().log(SentryLevel.DEBUG, "Startup Crash detected %d milliseconds after SDK init. Writing a startup crash marker file to disk.", new Object[]{timeSinceSdkInit});
            this.writeStartupCrashMarkerFile();
        }
        for (TimestampMarkerHandler<?> handler : TIMESTAMP_MARKER_HANDLERS) {
            handler.handle(this, hint, options);
        }
        return didStore;
    }

    @TestOnly
    @NotNull
    public File getDirectory() {
        return this.directory;
    }

    private void writeStartupCrashMarkerFile() {
        String outboxPath = this.options.getOutboxPath();
        if (outboxPath == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Outbox path is null, the startup crash marker file will not be written", new Object[0]);
            return;
        }
        File crashMarkerFile = new File(outboxPath, "startup_crash");
        try {
            crashMarkerFile.createNewFile();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the startup crash marker file to the disk", e);
        }
    }

    public static boolean hasStartupCrashMarker(@NotNull SentryOptions options) {
        String outboxPath = options.getOutboxPath();
        if (outboxPath == null) {
            options.getLogger().log(SentryLevel.DEBUG, "Outbox path is null, the startup crash marker file does not exist", new Object[0]);
            return false;
        }
        File crashMarkerFile = new File(outboxPath, "startup_crash");
        try {
            boolean exists = (Boolean)options.getRuntimeManager().runWithRelaxedPolicy(() -> crashMarkerFile.exists());
            if (exists && !((Boolean)options.getRuntimeManager().runWithRelaxedPolicy(() -> crashMarkerFile.delete())).booleanValue()) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to delete the startup crash marker file. %s.", new Object[]{crashMarkerFile.getAbsolutePath()});
            }
            return exists;
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error reading/deleting the startup crash marker file on the disk", e);
            return false;
        }
    }

    @Nullable
    private static Long lastReportedMarker(@NotNull SentryOptions options, @NotNull String reportFilename, @NotNull String markerLabel) {
        String cacheDirPath = (String)Objects.requireNonNull((Object)options.getCacheDirPath(), (String)("Cache dir path should be set for getting " + markerLabel + "s reported"));
        File lastMarker = new File(cacheDirPath, reportFilename);
        try {
            String content = FileUtils.readText((File)lastMarker);
            return content == null || content.equals("null") ? null : Long.valueOf(Long.parseLong(content.trim()));
        }
        catch (Throwable e) {
            if (e instanceof FileNotFoundException) {
                options.getLogger().log(SentryLevel.DEBUG, "Last " + markerLabel + " marker does not exist. %s.", new Object[]{lastMarker.getAbsolutePath()});
            } else {
                options.getLogger().log(SentryLevel.ERROR, "Error reading last " + markerLabel + " marker", e);
            }
            return null;
        }
    }

    private void writeLastReportedMarker(@Nullable Long timestamp, @NotNull String reportFilename, @NotNull String markerCategory) {
        String cacheDirPath = this.options.getCacheDirPath();
        if (cacheDirPath == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Cache dir path is null, the " + markerCategory + " marker will not be written", new Object[0]);
            return;
        }
        File anrMarker = new File(cacheDirPath, reportFilename);
        try (FileOutputStream outputStream = new FileOutputStream(anrMarker);){
            ((OutputStream)outputStream).write(String.valueOf(timestamp).getBytes(UTF_8));
            outputStream.flush();
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error writing the " + markerCategory + " marker to the disk", e);
        }
    }

    @Nullable
    public static Long lastReportedAnr(@NotNull SentryOptions options) {
        return AndroidEnvelopeCache.lastReportedMarker(options, LAST_ANR_REPORT, LAST_ANR_MARKER_LABEL);
    }

    @Nullable
    public static Long lastReportedTombstone(@NotNull SentryOptions options) {
        return AndroidEnvelopeCache.lastReportedMarker(options, LAST_TOMBSTONE_REPORT, LAST_TOMBSTONE_MARKER_LABEL);
    }

    private static final class TimestampMarkerHandler<T> {
        @NotNull
        private final Class<T> type;
        @NotNull
        private final String label;
        @NotNull
        private final String reportFilename;
        @NotNull
        private final TimestampExtractor<T> timestampProvider;

        TimestampMarkerHandler(@NotNull Class<T> type, @NotNull String label, @NotNull String reportFilename, @NotNull TimestampExtractor<T> timestampProvider) {
            this.type = type;
            this.label = label;
            this.reportFilename = reportFilename;
            this.timestampProvider = timestampProvider;
        }

        void handle(@NotNull AndroidEnvelopeCache cache, @NotNull Hint hint, @NotNull SentryAndroidOptions options) {
            HintUtils.runIfHasType((Hint)hint, this.type, typedHint -> {
                @NotNull Long timestamp = this.timestampProvider.extract(typedHint);
                options.getLogger().log(SentryLevel.DEBUG, "Writing last reported %s marker with timestamp %d", new Object[]{this.label, timestamp});
                cache.writeLastReportedMarker(timestamp, this.reportFilename, this.label);
            });
        }

        static interface TimestampExtractor<T> {
            @NotNull
            public Long extract(T var1);
        }
    }
}

