/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.internal.util.Debouncer;
import io.sentry.android.core.internal.util.DeviceOrientations;
import io.sentry.protocol.Device;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppComponentsBreadcrumbsIntegration
implements Integration,
Closeable,
ComponentCallbacks2 {
    private static final long DEBOUNCE_WAIT_TIME_MS = 60000L;
    @NotNull
    private static final Hint EMPTY_HINT = new Hint();
    @NotNull
    private final Context context;
    @Nullable
    private IScopes scopes;
    @Nullable
    private SentryAndroidOptions options;
    @NotNull
    private final Debouncer trimMemoryDebouncer = new Debouncer(AndroidCurrentDateProvider.getInstance(), 60000L, 0);

    public AppComponentsBreadcrumbsIntegration(@NotNull Context context) {
        this.context = (Context)Objects.requireNonNull((Object)ContextUtils.getApplicationContext(context), (String)"Context is required");
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration enabled: %s", new Object[]{this.options.isEnableAppComponentBreadcrumbs()});
        if (this.options.isEnableAppComponentBreadcrumbs()) {
            try {
                this.context.registerComponentCallbacks((ComponentCallbacks)this);
                options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration installed.", new Object[0]);
                IntegrationUtils.addIntegrationToSdkVersion((String)"AppComponentsBreadcrumbs");
            }
            catch (Throwable e) {
                this.options.setEnableAppComponentBreadcrumbs(false);
                options.getLogger().log(SentryLevel.INFO, e, "ComponentCallbacks2 is not available.", new Object[0]);
            }
        }
    }

    @Override
    public void close() throws IOException {
        block3: {
            try {
                this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
            }
            catch (Throwable ignored) {
                if (this.options == null) break block3;
                this.options.getLogger().log(SentryLevel.DEBUG, ignored, "It was not possible to unregisterComponentCallbacks", new Object[0]);
            }
        }
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "AppComponentsBreadcrumbsIntegration removed.", new Object[0]);
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        long now = System.currentTimeMillis();
        this.executeInBackground(() -> this.captureConfigurationChangedBreadcrumb(now, newConfig));
    }

    public void onLowMemory() {
    }

    public void onTrimMemory(int level) {
        if (level < 40) {
            return;
        }
        if (this.trimMemoryDebouncer.checkForDebounce()) {
            return;
        }
        long now = System.currentTimeMillis();
        this.executeInBackground(() -> this.captureLowMemoryBreadcrumb(now, level));
    }

    private void captureLowMemoryBreadcrumb(long timeMs, int level) {
        if (this.scopes != null) {
            Breadcrumb breadcrumb = new Breadcrumb(timeMs);
            breadcrumb.setType("system");
            breadcrumb.setCategory("device.event");
            breadcrumb.setMessage("Low memory");
            breadcrumb.setData("action", (Object)"LOW_MEMORY");
            breadcrumb.setData("level", (Object)level);
            breadcrumb.setLevel(SentryLevel.WARNING);
            this.scopes.addBreadcrumb(breadcrumb, EMPTY_HINT);
        }
    }

    private void captureConfigurationChangedBreadcrumb(long timeMs, @NotNull Configuration newConfig) {
        if (this.scopes != null) {
            Device.DeviceOrientation deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            String orientation = deviceOrientation != null ? deviceOrientation.name().toLowerCase(Locale.ROOT) : "undefined";
            Breadcrumb breadcrumb = new Breadcrumb(timeMs);
            breadcrumb.setType("navigation");
            breadcrumb.setCategory("device.orientation");
            breadcrumb.setData("position", (Object)orientation);
            breadcrumb.setLevel(SentryLevel.INFO);
            Hint hint = new Hint();
            hint.set("android:configuration", (Object)newConfig);
            this.scopes.addBreadcrumb(breadcrumb, hint);
        }
    }

    private void executeInBackground(@NotNull Runnable runnable) {
        if (this.options != null) {
            try {
                this.options.getExecutorService().submit(runnable);
            }
            catch (Throwable t) {
                this.options.getLogger().log(SentryLevel.ERROR, t, "Failed to submit app components breadcrumb task", new Object[0]);
            }
        }
    }
}

