/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import io.sentry.CompositePerformanceCollector;
import io.sentry.DeduplicateMultithreadedEventProcessor;
import io.sentry.DefaultCompositePerformanceCollector;
import io.sentry.DefaultVersionDetector;
import io.sentry.EventProcessor;
import io.sentry.IContinuousProfiler;
import io.sentry.IDistributionApi;
import io.sentry.ILogger;
import io.sentry.IOptionsObserver;
import io.sentry.IPerformanceCollector;
import io.sentry.IScopeObserver;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ITransactionProfiler;
import io.sentry.IVersionDetector;
import io.sentry.Integration;
import io.sentry.NoOpCompositePerformanceCollector;
import io.sentry.NoOpConnectionStatusProvider;
import io.sentry.NoOpContinuousProfiler;
import io.sentry.NoOpReplayBreadcrumbConverter;
import io.sentry.NoOpSocketTagger;
import io.sentry.NoOpTransactionProfiler;
import io.sentry.NoopVersionDetector;
import io.sentry.ReplayBreadcrumbConverter;
import io.sentry.ReplayController;
import io.sentry.ScopeType;
import io.sentry.SendCachedEnvelopeFireAndForgetIntegration;
import io.sentry.SendFireAndForgetEnvelopeSender;
import io.sentry.SendFireAndForgetOutboxSender;
import io.sentry.SentryFeedbackOptions;
import io.sentry.SentryLevel;
import io.sentry.SentryOpenTelemetryMode;
import io.sentry.SentryOptions;
import io.sentry.android.core.ActivityBreadcrumbsIntegration;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.ActivityLifecycleIntegration;
import io.sentry.android.core.AndroidContinuousProfiler;
import io.sentry.android.core.AndroidCpuCollector;
import io.sentry.android.core.AndroidFatalLogger;
import io.sentry.android.core.AndroidLogger;
import io.sentry.android.core.AndroidLoggerBatchProcessorFactory;
import io.sentry.android.core.AndroidMemoryCollector;
import io.sentry.android.core.AndroidSocketTagger;
import io.sentry.android.core.AndroidTransactionProfiler;
import io.sentry.android.core.AndroidTransportGate;
import io.sentry.android.core.AnrIntegrationFactory;
import io.sentry.android.core.AnrV2EventProcessor;
import io.sentry.android.core.AppComponentsBreadcrumbsIntegration;
import io.sentry.android.core.AppLifecycleIntegration;
import io.sentry.android.core.AppState;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.DefaultAndroidEventProcessor;
import io.sentry.android.core.EnvelopeFileObserverIntegration;
import io.sentry.android.core.Installation;
import io.sentry.android.core.ManifestMetadataReader;
import io.sentry.android.core.NdkIntegration;
import io.sentry.android.core.NetworkBreadcrumbsIntegration;
import io.sentry.android.core.PerformanceAndroidEventProcessor;
import io.sentry.android.core.ScreenshotEventProcessor;
import io.sentry.android.core.SendCachedEnvelopeIntegration;
import io.sentry.android.core.SentryAndroidDateProvider;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.SpanFrameMetricsCollector;
import io.sentry.android.core.SystemEventsBreadcrumbsIntegration;
import io.sentry.android.core.UserInteractionIntegration;
import io.sentry.android.core.ViewHierarchyEventProcessor;
import io.sentry.android.core.cache.AndroidEnvelopeCache;
import io.sentry.android.core.internal.debugmeta.AssetsDebugMetaLoader;
import io.sentry.android.core.internal.gestures.AndroidViewGestureTargetLocator;
import io.sentry.android.core.internal.modules.AssetsModulesLoader;
import io.sentry.android.core.internal.util.AndroidConnectionStatusProvider;
import io.sentry.android.core.internal.util.AndroidCurrentDateProvider;
import io.sentry.android.core.internal.util.AndroidRuntimeManager;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.android.core.internal.util.SentryFrameMetricsCollector;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.distribution.DistributionIntegration;
import io.sentry.android.fragment.FragmentLifecycleIntegration;
import io.sentry.android.replay.DefaultReplayBreadcrumbConverter;
import io.sentry.android.replay.ReplayIntegration;
import io.sentry.android.timber.SentryTimberIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.cache.PersistingOptionsObserver;
import io.sentry.cache.PersistingScopeObserver;
import io.sentry.compose.gestures.ComposeGestureTargetLocator;
import io.sentry.compose.viewhierarchy.ComposeViewHierarchyExporter;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.logger.ILoggerBatchProcessorFactory;
import io.sentry.protocol.SentryId;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.LazyEvaluator;
import io.sentry.util.LoadClass;
import io.sentry.util.Objects;
import io.sentry.util.thread.NoOpThreadChecker;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class AndroidOptionsInitializer {
    static final long DEFAULT_FLUSH_TIMEOUT_MS = 4000L;
    static final String SENTRY_COMPOSE_GESTURE_INTEGRATION_CLASS_NAME = "io.sentry.compose.gestures.ComposeGestureTargetLocator";
    static final String SENTRY_COMPOSE_VIEW_HIERARCHY_INTEGRATION_CLASS_NAME = "io.sentry.compose.viewhierarchy.ComposeViewHierarchyExporter";
    static final String COMPOSE_CLASS_NAME = "androidx.compose.ui.node.Owner";

    private AndroidOptionsInitializer() {
    }

    @TestOnly
    static void loadDefaultAndMetadataOptions(@NotNull SentryAndroidOptions options, @NotNull Context context) {
        AndroidLogger logger = new AndroidLogger();
        AndroidOptionsInitializer.loadDefaultAndMetadataOptions(options, context, logger, new BuildInfoProvider(logger));
    }

    static void loadDefaultAndMetadataOptions(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        Objects.requireNonNull((Object)context, (String)"The context is required.");
        @NotNull Context finalContext = ContextUtils.getApplicationContext(context);
        Objects.requireNonNull((Object)((Object)options), (String)"The options object is required.");
        Objects.requireNonNull((Object)logger, (String)"The ILogger object is required.");
        options.setLogger(logger);
        options.setFatalLogger(new AndroidFatalLogger());
        options.setDefaultScopeType(ScopeType.CURRENT);
        options.setOpenTelemetryMode(SentryOpenTelemetryMode.OFF);
        options.setDateProvider(new SentryAndroidDateProvider());
        options.setRuntimeManager(new AndroidRuntimeManager());
        options.getLogs().setLoggerBatchProcessorFactory((ILoggerBatchProcessorFactory)new AndroidLoggerBatchProcessorFactory());
        options.setFlushTimeoutMillis(4000L);
        options.setFrameMetricsCollector(new SentryFrameMetricsCollector(finalContext, logger, buildInfoProvider));
        ManifestMetadataReader.applyMetadata(finalContext, options, buildInfoProvider);
        options.setCacheDirPath((String)options.getRuntimeManager().runWithRelaxedPolicy(() -> AndroidOptionsInitializer.getCacheDir(finalContext).getAbsolutePath()));
        AndroidOptionsInitializer.readDefaultOptionValues(options, finalContext, buildInfoProvider);
        AppState.getInstance().registerLifecycleObserver(options);
    }

    @TestOnly
    static void initializeIntegrationsAndProcessors(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker, boolean isReplayAvailable) {
        AndroidOptionsInitializer.initializeIntegrationsAndProcessors(options, context, new BuildInfoProvider(new AndroidLogger()), loadClass, activityFramesTracker, isReplayAvailable);
    }

    static void initializeIntegrationsAndProcessors(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker, boolean isReplayAvailable) {
        IContinuousProfiler appStartContinuousProfiler;
        ITransactionProfiler appStartTransactionProfiler;
        if (options.getCacheDirPath() != null && options.getEnvelopeDiskCache() instanceof NoOpEnvelopeCache) {
            options.setEnvelopeDiskCache((IEnvelopeCache)new AndroidEnvelopeCache(options));
        }
        if (options.getConnectionStatusProvider() instanceof NoOpConnectionStatusProvider) {
            options.setConnectionStatusProvider(new AndroidConnectionStatusProvider(context, options, buildInfoProvider, AndroidCurrentDateProvider.getInstance()));
        }
        if (options.getCacheDirPath() != null) {
            options.addScopeObserver((IScopeObserver)new PersistingScopeObserver((SentryOptions)options));
            options.addOptionsObserver((IOptionsObserver)new PersistingOptionsObserver((SentryOptions)options));
        }
        options.addEventProcessor((EventProcessor)new DeduplicateMultithreadedEventProcessor((SentryOptions)options));
        options.addEventProcessor(new DefaultAndroidEventProcessor(context, buildInfoProvider, options));
        options.addEventProcessor(new PerformanceAndroidEventProcessor(options, activityFramesTracker));
        options.addEventProcessor(new ScreenshotEventProcessor(options, buildInfoProvider));
        options.addEventProcessor(new ViewHierarchyEventProcessor(options));
        options.addEventProcessor((EventProcessor)new AnrV2EventProcessor(context, options, buildInfoProvider));
        if (options.getTransportGate() instanceof NoOpTransportGate) {
            options.setTransportGate(new AndroidTransportGate(options));
        }
        @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
        if (options.getModulesLoader() instanceof NoOpModulesLoader) {
            options.setModulesLoader((IModulesLoader)new AssetsModulesLoader(context, options.getLogger()));
        }
        if (options.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options.setDebugMetaLoader(new AssetsDebugMetaLoader(context, options.getLogger()));
        }
        if (options.getVersionDetector() instanceof NoopVersionDetector) {
            options.setVersionDetector((IVersionDetector)new DefaultVersionDetector((SentryOptions)options));
        }
        @NotNull LazyEvaluator isAndroidXScrollViewAvailable = loadClass.isClassAvailableLazy("androidx.core.view.ScrollingView", (SentryOptions)options);
        boolean isComposeUpstreamAvailable = loadClass.isClassAvailable(COMPOSE_CLASS_NAME, (SentryOptions)options);
        if (options.getGestureTargetLocators().isEmpty()) {
            boolean isComposeAvailable;
            ArrayList<AndroidViewGestureTargetLocator> gestureTargetLocators = new ArrayList<AndroidViewGestureTargetLocator>(2);
            gestureTargetLocators.add(new AndroidViewGestureTargetLocator((LazyEvaluator<Boolean>)isAndroidXScrollViewAvailable));
            boolean bl = isComposeAvailable = isComposeUpstreamAvailable && loadClass.isClassAvailable(SENTRY_COMPOSE_GESTURE_INTEGRATION_CLASS_NAME, (SentryOptions)options);
            if (isComposeAvailable) {
                gestureTargetLocators.add((AndroidViewGestureTargetLocator)new ComposeGestureTargetLocator(options.getLogger()));
            }
            options.setGestureTargetLocators(gestureTargetLocators);
        }
        if (options.getViewHierarchyExporters().isEmpty() && isComposeUpstreamAvailable && loadClass.isClassAvailable(SENTRY_COMPOSE_VIEW_HIERARCHY_INTEGRATION_CLASS_NAME, (SentryOptions)options)) {
            ArrayList<ComposeViewHierarchyExporter> viewHierarchyExporters = new ArrayList<ComposeViewHierarchyExporter>(1);
            viewHierarchyExporters.add(new ComposeViewHierarchyExporter(options.getLogger()));
            options.setViewHierarchyExporters(viewHierarchyExporters);
        }
        if (options.getThreadChecker() instanceof NoOpThreadChecker) {
            options.setThreadChecker(AndroidThreadChecker.getInstance());
        }
        if (options.getSocketTagger() instanceof NoOpSocketTagger) {
            options.setSocketTagger(AndroidSocketTagger.getInstance());
        }
        if (options.getPerformanceCollectors().isEmpty()) {
            options.addPerformanceCollector((IPerformanceCollector)new AndroidMemoryCollector());
            options.addPerformanceCollector((IPerformanceCollector)new AndroidCpuCollector(options.getLogger()));
            if (options.isEnablePerformanceV2()) {
                options.addPerformanceCollector((IPerformanceCollector)new SpanFrameMetricsCollector(options, (SentryFrameMetricsCollector)Objects.requireNonNull((Object)options.getFrameMetricsCollector(), (String)"options.getFrameMetricsCollector is required")));
            }
        }
        if (options.getCompositePerformanceCollector() instanceof NoOpCompositePerformanceCollector) {
            options.setCompositePerformanceCollector((CompositePerformanceCollector)new DefaultCompositePerformanceCollector((SentryOptions)options));
        }
        if (isReplayAvailable && options.getReplayController().getBreadcrumbConverter() instanceof NoOpReplayBreadcrumbConverter) {
            options.getReplayController().setBreadcrumbConverter((ReplayBreadcrumbConverter)new DefaultReplayBreadcrumbConverter((SentryOptions)options));
        }
        try (@NotNull ISentryLifecycleToken ignored = AppStartMetrics.staticLock.acquire();){
            appStartTransactionProfiler = appStartMetrics.getAppStartProfiler();
            appStartContinuousProfiler = appStartMetrics.getAppStartContinuousProfiler();
            appStartMetrics.setAppStartProfiler(null);
            appStartMetrics.setAppStartContinuousProfiler(null);
        }
        AndroidOptionsInitializer.setupProfiler(options, context, buildInfoProvider, appStartTransactionProfiler, appStartContinuousProfiler, options.getCompositePerformanceCollector());
    }

    private static void setupProfiler(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @Nullable ITransactionProfiler appStartTransactionProfiler, @Nullable IContinuousProfiler appStartContinuousProfiler, @NotNull CompositePerformanceCollector performanceCollector) {
        if (options.isProfilingEnabled() || options.getProfilesSampleRate() != null) {
            options.setContinuousProfiler((IContinuousProfiler)NoOpContinuousProfiler.getInstance());
            if (appStartContinuousProfiler != null) {
                appStartContinuousProfiler.close(true);
            }
            if (appStartTransactionProfiler != null) {
                options.setTransactionProfiler(appStartTransactionProfiler);
            } else {
                options.setTransactionProfiler(new AndroidTransactionProfiler(context, options, buildInfoProvider, (SentryFrameMetricsCollector)Objects.requireNonNull((Object)options.getFrameMetricsCollector(), (String)"options.getFrameMetricsCollector is required")));
            }
        } else {
            options.setTransactionProfiler((ITransactionProfiler)NoOpTransactionProfiler.getInstance());
            if (appStartTransactionProfiler != null) {
                appStartTransactionProfiler.close();
            }
            if (appStartContinuousProfiler != null) {
                options.setContinuousProfiler(appStartContinuousProfiler);
                @NotNull SentryId chunkId = appStartContinuousProfiler.getChunkId();
                if (appStartContinuousProfiler.isRunning() && !chunkId.equals((Object)SentryId.EMPTY_ID)) {
                    performanceCollector.start(chunkId.toString());
                }
            } else {
                options.setContinuousProfiler(new AndroidContinuousProfiler(buildInfoProvider, (SentryFrameMetricsCollector)Objects.requireNonNull((Object)options.getFrameMetricsCollector(), (String)"options.getFrameMetricsCollector is required"), options.getLogger(), options.getProfilingTracesDirPath(), options.getProfilingTracesHz(), options.getExecutorService()));
            }
        }
    }

    static void installDefaultIntegrations(@NotNull Context context, @NotNull SentryAndroidOptions options, @NotNull BuildInfoProvider buildInfoProvider, @NotNull LoadClass loadClass, @NotNull ActivityFramesTracker activityFramesTracker, boolean isFragmentAvailable, boolean isTimberAvailable, boolean isReplayAvailable, boolean isDistributionAvailable) {
        LazyEvaluator startupCrashMarkerEvaluator = new LazyEvaluator(() -> AndroidEnvelopeCache.hasStartupCrashMarker(options));
        options.addIntegration(new SendCachedEnvelopeIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetEnvelopeSender(() -> options.getCacheDirPath()), (LazyEvaluator<Boolean>)startupCrashMarkerEvaluator));
        Class sentryNdkClass = loadClass.loadClass("io.sentry.android.ndk.SentryNdk", options.getLogger());
        options.addIntegration(new NdkIntegration(sentryNdkClass));
        options.addIntegration(EnvelopeFileObserverIntegration.getOutboxFileObserver());
        options.addIntegration(new SendCachedEnvelopeIntegration((SendCachedEnvelopeFireAndForgetIntegration.SendFireAndForgetFactory)new SendFireAndForgetOutboxSender(() -> options.getOutboxPath()), (LazyEvaluator<Boolean>)startupCrashMarkerEvaluator));
        options.addIntegration(new AppLifecycleIntegration());
        options.addIntegration(AnrIntegrationFactory.create(context, buildInfoProvider));
        if (context instanceof Application) {
            options.addIntegration(new ActivityLifecycleIntegration((Application)context, buildInfoProvider, activityFramesTracker));
            options.addIntegration(new ActivityBreadcrumbsIntegration((Application)context));
            options.addIntegration(new UserInteractionIntegration((Application)context, loadClass));
            if (isFragmentAvailable) {
                options.addIntegration((Integration)new FragmentLifecycleIntegration((Application)context, true, true));
            }
        } else {
            options.getLogger().log(SentryLevel.WARNING, "ActivityLifecycle, FragmentLifecycle and UserInteraction Integrations need an Application class to be installed.", new Object[0]);
        }
        if (isTimberAvailable) {
            options.addIntegration((Integration)new SentryTimberIntegration());
        }
        options.addIntegration(new AppComponentsBreadcrumbsIntegration(context));
        options.addIntegration(new SystemEventsBreadcrumbsIntegration(context));
        options.addIntegration(new NetworkBreadcrumbsIntegration(context, buildInfoProvider));
        if (isReplayAvailable) {
            ReplayIntegration replay = new ReplayIntegration(context, CurrentDateProvider.getInstance());
            options.addIntegration((Integration)replay);
            options.setReplayController((ReplayController)replay);
        }
        if (isDistributionAvailable) {
            DistributionIntegration distribution = new DistributionIntegration(context);
            options.setDistributionController((IDistributionApi)distribution);
            options.addIntegration((Integration)distribution);
        }
        options.getFeedbackOptions().setDialogHandler((SentryFeedbackOptions.IDialogHandler)new SentryAndroidOptions.AndroidUserFeedbackIDialogHandler());
    }

    private static void readDefaultOptionValues(@NotNull SentryAndroidOptions options, @NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider) {
        @Nullable PackageInfo packageInfo = ContextUtils.getPackageInfo(context, buildInfoProvider);
        if (packageInfo != null) {
            String packageName;
            if (options.getRelease() == null) {
                options.setRelease(AndroidOptionsInitializer.getSentryReleaseVersion(packageInfo, ContextUtils.getVersionCode(packageInfo, buildInfoProvider)));
            }
            if ((packageName = packageInfo.packageName) != null && !packageName.startsWith("android.")) {
                options.addInAppInclude(packageName);
            }
        }
        if (options.getDistinctId() == null) {
            try {
                options.setDistinctId((String)options.getRuntimeManager().runWithRelaxedPolicy(() -> Installation.id(context)));
            }
            catch (RuntimeException e) {
                options.getLogger().log(SentryLevel.ERROR, "Could not generate distinct Id.", (Throwable)e);
            }
        }
    }

    @NotNull
    private static String getSentryReleaseVersion(@NotNull PackageInfo packageInfo, @NotNull String versionCode) {
        return packageInfo.packageName + "@" + packageInfo.versionName + "+" + versionCode;
    }

    @NotNull
    static File getCacheDir(@NotNull Context context) {
        return new File(context.getCacheDir(), "sentry");
    }
}

