/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import io.sentry.ISentryLifecycleToken;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class CpuInfoUtils {
    private static final CpuInfoUtils instance = new CpuInfoUtils();
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    @NotNull
    private static final String SYSTEM_CPU_PATH = "/sys/devices/system/cpu";
    @VisibleForTesting
    @NotNull
    static final String CPUINFO_MAX_FREQ_PATH = "cpufreq/cpuinfo_max_freq";
    @NotNull
    private final List<Integer> cpuMaxFrequenciesMhz = new ArrayList<Integer>();

    public static CpuInfoUtils getInstance() {
        return instance;
    }

    private CpuInfoUtils() {
    }

    @NotNull
    public List<Integer> readMaxFrequencies() {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (!this.cpuMaxFrequenciesMhz.isEmpty()) {
                List<Integer> list = this.cpuMaxFrequenciesMhz;
                return list;
            }
            File[] cpuDirs = new File(this.getSystemCpuPath()).listFiles();
            if (cpuDirs == null) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                return arrayList;
            }
            for (File cpuDir : cpuDirs) {
                long khz;
                if (!cpuDir.getName().matches("cpu[0-9]+")) continue;
                File cpuMaxFreqFile = new File(cpuDir, CPUINFO_MAX_FREQ_PATH);
                try {
                    String content = FileUtils.readText((File)cpuMaxFreqFile);
                    if (content == null) continue;
                    khz = Long.parseLong(content.trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                this.cpuMaxFrequenciesMhz.add((int)(khz / 1000L));
            }
            List<Integer> list = this.cpuMaxFrequenciesMhz;
            return list;
        }
    }

    @VisibleForTesting
    @NotNull
    String getSystemCpuPath() {
        return SYSTEM_CPU_PATH;
    }

    @TestOnly
    public void setCpuMaxFrequencies(List<Integer> frequencies) {
        this.cpuMaxFrequenciesMhz.clear();
        this.cpuMaxFrequenciesMhz.addAll(frequencies);
    }

    @TestOnly
    final void clear() {
        this.cpuMaxFrequenciesMhz.clear();
    }
}

