/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import androidx.annotation.NonNull;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.sentry.ILogger;
import io.sentry.ISentryLifecycleToken;
import io.sentry.NoOpLogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.MainLooperHandler;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.util.AutoClosableReentrantLock;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppState
implements Closeable {
    @NotNull
    private static AppState instance = new AppState();
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();
    private volatile LifecycleObserver lifecycleObserver;
    private MainLooperHandler handler = new MainLooperHandler();
    @Nullable
    private volatile Boolean inBackground = null;

    private AppState() {
    }

    @NotNull
    public static AppState getInstance() {
        return instance;
    }

    @TestOnly
    void setHandler(@NotNull MainLooperHandler handler) {
        this.handler = handler;
    }

    @ApiStatus.Internal
    @TestOnly
    public void resetInstance() {
        instance = new AppState();
    }

    @ApiStatus.Internal
    @TestOnly
    public LifecycleObserver getLifecycleObserver() {
        return this.lifecycleObserver;
    }

    @Nullable
    public Boolean isInBackground() {
        return this.inBackground;
    }

    void setInBackground(boolean inBackground) {
        this.inBackground = inBackground;
    }

    public void addAppStateListener(@NotNull AppStateListener listener) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            this.ensureLifecycleObserver((ILogger)NoOpLogger.getInstance());
            if (this.lifecycleObserver != null) {
                this.lifecycleObserver.listeners.add(listener);
            }
        }
    }

    public void removeAppStateListener(@NotNull AppStateListener listener) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            if (this.lifecycleObserver != null) {
                this.lifecycleObserver.listeners.remove(listener);
            }
        }
    }

    @ApiStatus.Internal
    public void registerLifecycleObserver(@Nullable SentryOptions options) {
        if (this.lifecycleObserver != null) {
            return;
        }
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            this.ensureLifecycleObserver((ILogger)(options != null ? options.getLogger() : NoOpLogger.getInstance()));
        }
    }

    private void ensureLifecycleObserver(@NotNull ILogger logger) {
        if (this.lifecycleObserver != null) {
            return;
        }
        try {
            Class.forName("androidx.lifecycle.ProcessLifecycleOwner");
            this.lifecycleObserver = new LifecycleObserver();
            if (AndroidThreadChecker.getInstance().isMainThread()) {
                this.addObserverInternal(logger);
            } else {
                this.handler.post(() -> this.addObserverInternal(logger));
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(SentryLevel.WARNING, "androidx.lifecycle is not available, some features might not be properly working,e.g. Session Tracking, Network and System Events breadcrumbs, etc.", new Object[0]);
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "AppState could not register lifecycle observer", e);
        }
    }

    private void addObserverInternal(@NotNull ILogger logger) {
        @Nullable LifecycleObserver observerRef = this.lifecycleObserver;
        try {
            if (observerRef != null) {
                ProcessLifecycleOwner.get().getLifecycle().addObserver((androidx.lifecycle.LifecycleObserver)observerRef);
            }
        }
        catch (Throwable e) {
            this.lifecycleObserver = null;
            logger.log(SentryLevel.ERROR, "AppState failed to get Lifecycle and could not install lifecycle observer.", e);
        }
    }

    @ApiStatus.Internal
    public void unregisterLifecycleObserver() {
        LifecycleObserver ref;
        if (this.lifecycleObserver == null) {
            return;
        }
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            ref = this.lifecycleObserver;
            this.lifecycleObserver.listeners.clear();
            this.lifecycleObserver = null;
        }
        if (AndroidThreadChecker.getInstance().isMainThread()) {
            this.removeObserverInternal(ref);
        } else {
            this.handler.post(() -> this.removeObserverInternal(ref));
        }
    }

    private void removeObserverInternal(@Nullable LifecycleObserver ref) {
        if (ref != null) {
            ProcessLifecycleOwner.get().getLifecycle().removeObserver((androidx.lifecycle.LifecycleObserver)ref);
        }
    }

    @Override
    public void close() throws IOException {
        this.unregisterLifecycleObserver();
    }

    @ApiStatus.Internal
    public final class LifecycleObserver
    implements DefaultLifecycleObserver {
        final List<AppStateListener> listeners = new CopyOnWriteArrayList<AppStateListener>(){

            @Override
            public boolean add(AppStateListener appStateListener) {
                boolean addResult = super.add(appStateListener);
                if (Boolean.FALSE.equals(AppState.this.inBackground)) {
                    appStateListener.onForeground();
                } else if (Boolean.TRUE.equals(AppState.this.inBackground)) {
                    appStateListener.onBackground();
                }
                return addResult;
            }
        };

        @ApiStatus.Internal
        @TestOnly
        public List<AppStateListener> getListeners() {
            return this.listeners;
        }

        public void onStart(@NonNull LifecycleOwner owner) {
            AppState.this.setInBackground(false);
            for (AppStateListener listener : this.listeners) {
                listener.onForeground();
            }
        }

        public void onStop(@NonNull LifecycleOwner owner) {
            AppState.this.setInBackground(true);
            for (AppStateListener listener : this.listeners) {
                listener.onBackground();
            }
        }
    }

    public static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }
}

