/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.DisplayMetrics;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.DeviceInfoUtil;
import io.sentry.android.core.util.AndroidLazyEvaluator;
import io.sentry.protocol.App;
import io.sentry.util.LazyEvaluator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ContextUtils {
    @NotNull
    private static final LazyEvaluator<Boolean> isForegroundImportance = new LazyEvaluator(() -> {
        try {
            ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
            return appProcessInfo.importance == 100;
        }
        catch (Throwable throwable) {
            return false;
        }
    });
    @SuppressLint(value={"NewApi"})
    @NotNull
    private static final AndroidLazyEvaluator<PackageInfo> staticPackageInfo33 = new AndroidLazyEvaluator<PackageInfo>(context -> {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
        }
        catch (Throwable e) {
            return null;
        }
    });
    @NotNull
    private static final AndroidLazyEvaluator<PackageInfo> staticPackageInfo = new AndroidLazyEvaluator<PackageInfo>(context -> {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (Throwable e) {
            return null;
        }
    });
    @NotNull
    private static final AndroidLazyEvaluator<String> applicationName = new AndroidLazyEvaluator<String>(context -> {
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            if (stringId == 0) {
                if (applicationInfo.nonLocalizedLabel != null) {
                    return applicationInfo.nonLocalizedLabel.toString();
                }
                return context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            return context.getString(stringId);
        }
        catch (Throwable e) {
            return null;
        }
    });
    @SuppressLint(value={"NewApi"})
    @NotNull
    private static final AndroidLazyEvaluator<ApplicationInfo> staticAppInfo33 = new AndroidLazyEvaluator<ApplicationInfo>(context -> {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.ApplicationInfoFlags.of((long)128L));
        }
        catch (Throwable e) {
            return null;
        }
    });
    @NotNull
    private static final AndroidLazyEvaluator<ApplicationInfo> staticAppInfo = new AndroidLazyEvaluator<ApplicationInfo>(context -> {
        try {
            return context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (Throwable e) {
            return null;
        }
    });

    private ContextUtils() {
    }

    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 33) {
            return staticPackageInfo33.getValue(context);
        }
        return staticPackageInfo.getValue(context);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    static PackageInfo getPackageInfo(@NotNull Context context, int flags, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        try {
            if (buildInfoProvider.getSdkInfoVersion() >= 33) {
                return context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)flags));
            }
            return context.getPackageManager().getPackageInfo(context.getPackageName(), flags);
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting package info.", e);
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    static ApplicationInfo getApplicationInfo(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 33) {
            return staticAppInfo33.getValue(context);
        }
        return staticAppInfo.getValue(context);
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    static String getVersionCode(@NotNull PackageInfo packageInfo, @NotNull BuildInfoProvider buildInfoProvider) {
        if (buildInfoProvider.getSdkInfoVersion() >= 28) {
            return Long.toString(packageInfo.getLongVersionCode());
        }
        return ContextUtils.getVersionCodeDep(packageInfo);
    }

    @Nullable
    static String getVersionName(@NotNull PackageInfo packageInfo) {
        return packageInfo.versionName;
    }

    @NotNull
    private static String getVersionCodeDep(@NotNull PackageInfo packageInfo) {
        return Integer.toString(packageInfo.versionCode);
    }

    @ApiStatus.Internal
    public static boolean isForegroundImportance() {
        return (Boolean)isForegroundImportance.getValue();
    }

    @ApiStatus.Internal
    public static boolean appIsLibraryForComposePreview(@NotNull Context context) {
        if (context.getPackageName().endsWith(".test")) {
            try {
                @NotNull ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                @NotNull List appTasks = activityManager.getAppTasks();
                for (ActivityManager.AppTask task : appTasks) {
                    @Nullable ComponentName component = task.getTaskInfo().baseIntent.getComponent();
                    if (component == null || !component.getClassName().equals("androidx.compose.ui.tooling.PreviewActivity")) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    static String getKernelVersion(@NotNull ILogger logger) {
        String string;
        String errorMsg = "Exception while attempting to read kernel information";
        String defaultVersion = System.getProperty("os.version");
        File file = new File("/proc/version");
        if (!file.canRead()) {
            return defaultVersion;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            string = br.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.log(SentryLevel.ERROR, "Exception while attempting to read kernel information", (Throwable)e);
                return defaultVersion;
            }
        }
        br.close();
        return string;
    }

    @Nullable
    static SideLoadedInfo retrieveSideLoadedInfo(@NotNull Context context, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        String packageName = null;
        try {
            PackageInfo packageInfo = ContextUtils.getPackageInfo(context, buildInfoProvider);
            PackageManager packageManager = context.getPackageManager();
            if (packageInfo != null && packageManager != null) {
                packageName = packageInfo.packageName;
                String installerPackageName = packageManager.getInstallerPackageName(packageName);
                return new SideLoadedInfo(installerPackageName == null, installerPackageName);
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(SentryLevel.DEBUG, "%s package isn't installed.", new Object[]{packageName});
        }
        return null;
    }

    @Nullable
    static SplitApksInfo retrieveSplitApksInfo(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider) {
        String[] splitNames = null;
        ApplicationInfo applicationInfo = ContextUtils.getApplicationInfo(context, buildInfoProvider);
        PackageInfo packageInfo = ContextUtils.getPackageInfo(context, buildInfoProvider);
        if (packageInfo != null) {
            splitNames = packageInfo.splitNames;
            boolean isSplitApks = false;
            if (applicationInfo != null && applicationInfo.metaData != null) {
                isSplitApks = applicationInfo.metaData.getBoolean("com.android.vending.splits.required");
            }
            return new SplitApksInfo(isSplitApks, splitNames);
        }
        return null;
    }

    @Nullable
    static String getApplicationName(@NotNull Context context) {
        return applicationName.getValue(context);
    }

    @Nullable
    static DisplayMetrics getDisplayMetrics(@NotNull Context context, @NotNull ILogger logger) {
        try {
            return context.getResources().getDisplayMetrics();
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting DisplayMetrics.", e);
            return null;
        }
    }

    @Nullable
    static String getFamily(@NotNull ILogger logger) {
        try {
            return Build.MODEL.split(" ", -1)[0];
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting device family.", e);
            return null;
        }
    }

    @NotNull
    static String[] getArchitectures() {
        return Build.SUPPORTED_ABIS;
    }

    @Nullable
    static ActivityManager.MemoryInfo getMemInfo(@NotNull Context context, @NotNull ILogger logger) {
        try {
            ActivityManager actManager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            if (actManager != null) {
                actManager.getMemoryInfo(memInfo);
                return memInfo;
            }
            logger.log(SentryLevel.INFO, "Error getting MemoryInfo.", new Object[0]);
            return null;
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Error getting MemoryInfo.", e);
            return null;
        }
    }

    @Nullable
    static Intent registerReceiver(@NotNull Context context, @NotNull SentryOptions options, @Nullable BroadcastReceiver receiver, @NotNull IntentFilter filter) {
        return ContextUtils.registerReceiver(context, new BuildInfoProvider(options.getLogger()), receiver, filter);
    }

    @SuppressLint(value={"NewApi", "UnspecifiedRegisterReceiverFlag"})
    @Nullable
    static Intent registerReceiver(@NotNull Context context, @NotNull BuildInfoProvider buildInfoProvider, @Nullable BroadcastReceiver receiver, @NotNull IntentFilter filter) {
        if (buildInfoProvider.getSdkInfoVersion() >= 33) {
            return context.registerReceiver(receiver, filter, 4);
        }
        return context.registerReceiver(receiver, filter);
    }

    static void setAppPackageInfo(@NotNull PackageInfo packageInfo, @NotNull BuildInfoProvider buildInfoProvider, @Nullable DeviceInfoUtil deviceInfoUtil, @NotNull App app) {
        app.setAppIdentifier(packageInfo.packageName);
        app.setAppVersion(packageInfo.versionName);
        app.setAppBuild(ContextUtils.getVersionCode(packageInfo, buildInfoProvider));
        HashMap<String, String> permissions = new HashMap<String, String>();
        String[] requestedPermissions = packageInfo.requestedPermissions;
        int[] requestedPermissionsFlags = packageInfo.requestedPermissionsFlags;
        if (requestedPermissions != null && requestedPermissions.length > 0 && requestedPermissionsFlags != null && requestedPermissionsFlags.length > 0) {
            for (int i = 0; i < requestedPermissions.length; ++i) {
                String permission2 = requestedPermissions[i];
                permission2 = permission2.substring(permission2.lastIndexOf(46) + 1);
                boolean granted = (requestedPermissionsFlags[i] & 2) == 2;
                permissions.put(permission2, granted ? "granted" : "not_granted");
            }
        }
        app.setPermissions(permissions);
        if (deviceInfoUtil != null) {
            try {
                SplitApksInfo splitApksInfo = deviceInfoUtil.getSplitApksInfo();
                if (splitApksInfo != null) {
                    app.setSplitApks(Boolean.valueOf(splitApksInfo.isSplitApks()));
                    if (splitApksInfo.getSplitNames() != null) {
                        app.setSplitNames(Arrays.asList(splitApksInfo.getSplitNames()));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static Context getApplicationContext(@NotNull Context context) {
        @Nullable Context appContext = context.getApplicationContext();
        if (appContext != null) {
            return appContext;
        }
        return context;
    }

    @TestOnly
    static void resetInstance() {
        isForegroundImportance.resetValue();
        staticPackageInfo33.resetValue();
        staticPackageInfo.resetValue();
        applicationName.resetValue();
        staticAppInfo33.resetValue();
        staticAppInfo.resetValue();
    }

    static class SideLoadedInfo {
        private final boolean isSideLoaded;
        @Nullable
        private final String installerStore;

        public SideLoadedInfo(boolean isSideLoaded, @Nullable String installerStore) {
            this.isSideLoaded = isSideLoaded;
            this.installerStore = installerStore;
        }

        public boolean isSideLoaded() {
            return this.isSideLoaded;
        }

        @Nullable
        public String getInstallerStore() {
            return this.installerStore;
        }

        @NotNull
        public Map<String, String> asTags() {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("isSideLoaded", String.valueOf(this.isSideLoaded));
            if (this.installerStore != null) {
                data.put("installerStore", this.installerStore);
            }
            return data;
        }
    }

    static class SplitApksInfo {
        static final String SPLITS_REQUIRED = "com.android.vending.splits.required";
        private final boolean isSplitApks;
        private final String[] splitNames;

        public SplitApksInfo(boolean isSplitApks, String[] splitNames) {
            this.isSplitApks = isSplitApks;
            this.splitNames = splitNames;
        }

        public boolean isSplitApks() {
            return this.isSplitApks;
        }

        @Nullable
        public String[] getSplitNames() {
            return this.splitNames;
        }
    }
}

