/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.threaddump;

import io.sentry.android.core.internal.threaddump.Line;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Lines {
    @NotNull
    private final ArrayList<? extends Line> mList;
    private final int mMin;
    private final int mMax;
    public int pos;

    public static Lines readLines(@NotNull File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            Lines lines = Lines.readLines(reader);
            return lines;
        }
    }

    public static Lines readLines(@NotNull BufferedReader in) throws IOException {
        String text;
        ArrayList<Line> list = new ArrayList<Line>();
        int lineno = 0;
        while ((text = in.readLine()) != null) {
            list.add(new Line(++lineno, text));
        }
        return new Lines(list);
    }

    public Lines(@NotNull ArrayList<? extends Line> list) {
        this.mList = list;
        this.mMin = 0;
        this.mMax = this.mList.size();
    }

    public boolean hasNext() {
        return this.pos < this.mMax;
    }

    @Nullable
    public Line next() {
        if (this.pos >= this.mMin && this.pos < this.mMax) {
            return this.mList.get(this.pos++);
        }
        return null;
    }

    public void rewind() {
        --this.pos;
    }
}

