/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.Window;
import androidx.core.view.GestureDetectorCompat;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.android.core.internal.gestures.SentryGestureListener;
import io.sentry.android.core.internal.gestures.WindowCallbackAdapter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryWindowCallback
extends WindowCallbackAdapter {
    @NotNull
    private final Window.Callback delegate;
    @NotNull
    private final SentryGestureListener gestureListener;
    @NotNull
    private final GestureDetectorCompat gestureDetector;
    @Nullable
    private final SentryOptions options;
    @NotNull
    private final MotionEventObtainer motionEventObtainer;

    public SentryWindowCallback(@NotNull Window.Callback delegate, @NotNull Context context, @NotNull SentryGestureListener gestureListener, @Nullable SentryOptions options) {
        this(delegate, new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)gestureListener), gestureListener, options, new MotionEventObtainer(){});
    }

    SentryWindowCallback(@NotNull Window.Callback delegate, @NotNull GestureDetectorCompat gestureDetector, @NotNull SentryGestureListener gestureListener, @Nullable SentryOptions options, @NotNull MotionEventObtainer motionEventObtainer) {
        super(delegate);
        this.delegate = delegate;
        this.gestureListener = gestureListener;
        this.options = options;
        this.gestureDetector = gestureDetector;
        this.motionEventObtainer = motionEventObtainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchTouchEvent(@Nullable MotionEvent motionEvent) {
        if (motionEvent != null) {
            MotionEvent copy = this.motionEventObtainer.obtain(motionEvent);
            try {
                this.handleTouchEvent(copy);
            }
            catch (Throwable e) {
                if (this.options != null) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error dispatching touch event", e);
                }
            }
            finally {
                copy.recycle();
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    private void handleTouchEvent(@NotNull MotionEvent motionEvent) {
        this.gestureDetector.onTouchEvent(motionEvent);
        int action = motionEvent.getActionMasked();
        if (action == 1) {
            this.gestureListener.onUp(motionEvent);
        }
    }

    public void stopTracking() {
        this.gestureListener.stopTracing(SpanStatus.CANCELLED);
    }

    @NotNull
    public Window.Callback getDelegate() {
        return this.delegate;
    }

    static interface MotionEventObtainer {
        @NotNull
        default public MotionEvent obtain(@NotNull MotionEvent origin) {
            return MotionEvent.obtain((MotionEvent)origin);
        }
    }
}

