/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import io.sentry.IHub;
import io.sentry.Integration;
import io.sentry.SentryOptions;
import io.sentry.android.core.CurrentActivityHolder;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CurrentActivityIntegration
implements Integration,
Closeable,
Application.ActivityLifecycleCallbacks {
    @NotNull
    private final Application application;

    public CurrentActivityIntegration(@NotNull Application application) {
        this.application = (Application)Objects.requireNonNull((Object)application, (String)"Application is required");
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        this.setCurrentActivity(activity);
    }

    public void onActivityStarted(@NonNull Activity activity) {
        this.setCurrentActivity(activity);
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.setCurrentActivity(activity);
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.cleanCurrentActivity(activity);
    }

    @Override
    public void close() throws IOException {
        this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        CurrentActivityHolder.getInstance().clearActivity();
    }

    private void cleanCurrentActivity(@NotNull Activity activity) {
        if (CurrentActivityHolder.getInstance().getActivity() == activity) {
            CurrentActivityHolder.getInstance().clearActivity();
        }
    }

    private void setCurrentActivity(@NotNull Activity activity) {
        CurrentActivityHolder.getInstance().setActivity(activity);
    }
}

