/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.file.lock;

import io.seata.common.loader.LoadLevel;
import io.seata.core.exception.TransactionException;
import io.seata.core.lock.Locker;
import io.seata.server.lock.AbstractLockManager;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.storage.file.lock.FileLocker;
import io.seata.server.storage.raft.lock.RaftLockManager;
import java.util.List;
import org.slf4j.MDC;

@LoadLevel(name="file")
public class FileLockManager
extends AbstractLockManager {
    @Override
    public Locker getLocker(BranchSession branchSession) {
        return new FileLocker(branchSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        List<BranchSession> branchSessions = globalSession.getBranchSessions();
        boolean releaseLockResult = true;
        for (BranchSession branchSession : branchSessions) {
            try {
                MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(branchSession.getBranchId()));
                releaseLockResult = this instanceof RaftLockManager ? super.releaseLock(branchSession) : this.releaseLock(branchSession);
            }
            finally {
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
        return releaseLockResult;
    }
}

