/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.common.XID;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.exception.StoreException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.LockStatus;
import io.seata.core.store.DistributedLockDO;
import io.seata.core.store.DistributedLocker;
import io.seata.server.cluster.raft.RaftServerFactory;
import io.seata.server.cluster.raft.context.SeataClusterContext;
import io.seata.server.lock.distributed.DistributedLockerFactory;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.Reloadable;
import io.seata.server.session.SessionCondition;
import io.seata.server.session.SessionHelper;
import io.seata.server.session.SessionManager;
import io.seata.server.store.StoreConfig;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionHolder.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    public static final String ROOT_SESSION_MANAGER_NAME = "root.data";
    private static long DISTRIBUTED_LOCK_EXPIRE_TIME = CONFIG.getLong("server.distributedLockExpireTime", 10000L);
    private static SessionManager ROOT_SESSION_MANAGER;
    private static volatile Map<String, SessionManager> SESSION_MANAGER_MAP;
    private static DistributedLocker DISTRIBUTED_LOCKER;

    public static void init() {
        SessionHolder.init(null);
    }

    public static void init(StoreConfig.SessionMode sessionMode) {
        if (null == sessionMode) {
            sessionMode = StoreConfig.getSessionMode();
        }
        LOGGER.info("use session store mode: {}", (Object)sessionMode.getName());
        DISTRIBUTED_LOCKER = DistributedLockerFactory.getDistributedLocker(sessionMode.getName());
        if (StoreConfig.SessionMode.DB.equals((Object)sessionMode)) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.DB.getName());
            SessionHolder.reload(sessionMode);
        } else if (StoreConfig.SessionMode.RAFT.equals((Object)sessionMode) || StoreConfig.SessionMode.FILE.equals((Object)sessionMode)) {
            RaftServerFactory.getInstance().init();
            if (CollectionUtils.isNotEmpty(RaftServerFactory.getInstance().getRaftServers())) {
                sessionMode = StoreConfig.SessionMode.RAFT;
            }
            if (StoreConfig.SessionMode.RAFT.equals((Object)sessionMode)) {
                String group = CONFIG.getConfig("server.raft.group", "default");
                ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.RAFT.getName(), (Object[])new Object[]{ROOT_SESSION_MANAGER_NAME});
                SESSION_MANAGER_MAP = new HashMap<String, SessionManager>();
                SESSION_MANAGER_MAP.put(group, ROOT_SESSION_MANAGER);
                RaftServerFactory.getInstance().start();
            } else {
                String sessionStorePath = CONFIG.getConfig("store.file.dir", "sessionStore") + File.separator + System.getProperty("server.servicePort");
                if (StringUtils.isBlank((String)sessionStorePath)) {
                    throw new StoreException("the {store.file.dir} is empty.");
                }
                ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.FILE.getName(), (Object[])new Object[]{ROOT_SESSION_MANAGER_NAME, sessionStorePath});
                SessionHolder.reload(sessionMode);
            }
        } else if (StoreConfig.SessionMode.REDIS.equals((Object)sessionMode)) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreConfig.SessionMode.REDIS.getName());
            SessionHolder.reload(sessionMode);
        } else {
            throw new IllegalArgumentException("unknown store mode:" + sessionMode.getName());
        }
    }

    protected static void reload(StoreConfig.SessionMode sessionMode) {
        if (sessionMode == StoreConfig.SessionMode.FILE) {
            ((Reloadable)((Object)ROOT_SESSION_MANAGER)).reload();
            SessionHolder.reload(ROOT_SESSION_MANAGER.allSessions(), sessionMode);
        } else {
            SessionHolder.reload(null, sessionMode);
        }
    }

    public static void reload(Collection<GlobalSession> allSessions, StoreConfig.SessionMode storeMode) {
        SessionHolder.reload(allSessions, storeMode, true);
    }

    public static void reload(Collection<GlobalSession> allSessions, StoreConfig.SessionMode storeMode, boolean acquireLock) {
        if ((StoreConfig.SessionMode.FILE == storeMode || StoreConfig.SessionMode.RAFT == storeMode) && CollectionUtils.isNotEmpty(allSessions)) {
            block18: for (GlobalSession globalSession : allSessions) {
                GlobalStatus globalStatus = globalSession.getStatus();
                switch (globalStatus) {
                    case TimeoutRollbacked: 
                    case Rollbacked: {
                        try {
                            SessionHelper.endRollbacked(globalSession, true);
                        }
                        catch (TransactionException e) {
                            LOGGER.error("Could not handle the global session, xid: {},error: {}", (Object)globalSession.getXid(), (Object)e.getMessage());
                        }
                        continue block18;
                    }
                    case Committed: {
                        try {
                            SessionHelper.endCommitted(globalSession, true);
                        }
                        catch (TransactionException e) {
                            LOGGER.error("Could not handle the global session, xid: {},error: {}", (Object)globalSession.getXid(), (Object)e.getMessage());
                        }
                        continue block18;
                    }
                    case Finished: 
                    case UnKnown: 
                    case CommitFailed: 
                    case RollbackFailed: 
                    case TimeoutRollbackFailed: {
                        SessionHolder.removeInErrorState(globalSession);
                        continue block18;
                    }
                    case AsyncCommitting: 
                    case Committing: 
                    case CommitRetrying: {
                        if (!Objects.equals((Object)StoreConfig.SessionMode.RAFT, (Object)storeMode)) continue block18;
                        try {
                            globalSession.clean();
                            continue block18;
                        }
                        catch (TransactionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (acquireLock) {
                    SessionHolder.lockBranchSessions(globalSession.getSortedBranches());
                    if (GlobalStatus.Rollbacking.equals((Object)globalSession.getStatus()) || GlobalStatus.TimeoutRollbacking.equals((Object)globalSession.getStatus())) {
                        globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
                    }
                }
                switch (globalStatus) {
                    case Rollbacking: 
                    case RollbackRetrying: 
                    case TimeoutRollbacking: 
                    case TimeoutRollbackRetrying: {
                        continue block18;
                    }
                    case Begin: {
                        if (Objects.equals((Object)storeMode, (Object)StoreConfig.SessionMode.RAFT)) {
                            try {
                                globalSession.changeGlobalStatus(GlobalStatus.RollbackRetrying);
                                LOGGER.info("change global status: {}, xid: {}", (Object)globalSession.getStatus(), (Object)globalSession.getXid());
                            }
                            catch (TransactionException e) {
                                LOGGER.error("change global status fail: {}", (Object)e.getMessage(), (Object)e);
                            }
                            continue block18;
                        }
                        globalSession.setActive(true);
                        continue block18;
                    }
                }
                LOGGER.error("Could not handle the global session, xid: {}", (Object)globalSession.getXid());
                throw new ShouldNeverHappenException("NOT properly handled " + globalStatus);
            }
        } else {
            CompletableFuture.runAsync(() -> {
                SessionCondition searchCondition = new SessionCondition(GlobalStatus.UnKnown, GlobalStatus.Committed, GlobalStatus.Rollbacked, GlobalStatus.TimeoutRollbacked, GlobalStatus.Finished);
                searchCondition.setLazyLoadBranch(true);
                long now = System.currentTimeMillis();
                List<GlobalSession> errorStatusGlobalSessions = ROOT_SESSION_MANAGER.findGlobalSessions(searchCondition);
                while (!CollectionUtils.isEmpty(errorStatusGlobalSessions)) {
                    for (GlobalSession errorStatusGlobalSession : errorStatusGlobalSessions) {
                        if (errorStatusGlobalSession.getBeginTime() >= now) {
                            return;
                        }
                        SessionHolder.removeInErrorState(errorStatusGlobalSession);
                    }
                    errorStatusGlobalSessions = ROOT_SESSION_MANAGER.findGlobalSessions(searchCondition);
                }
            });
        }
    }

    private static void removeInErrorState(GlobalSession globalSession) {
        try {
            LOGGER.warn("The global session should NOT be {}, remove it. xid = {}", (Object)globalSession.getStatus(), (Object)globalSession.getXid());
            SessionHolder.getRootSessionManager().removeGlobalSession(globalSession);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Remove global session succeed, xid = {}, status = {}", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            }
        }
        catch (Exception e) {
            LOGGER.error("Remove global session failed, xid = {}, status = {}", new Object[]{globalSession.getXid(), globalSession.getStatus(), e});
        }
    }

    private static void lockBranchSessions(List<BranchSession> branchSessions) {
        branchSessions.forEach(branchSession -> {
            try {
                branchSession.lock();
            }
            catch (TransactionException e) {
                throw new ShouldNeverHappenException((Throwable)e);
            }
        });
    }

    public static SessionManager getRootSessionManager() {
        String group = SeataClusterContext.getGroup();
        return SessionHolder.getRootSessionManager(group);
    }

    public static SessionManager getRootSessionManager(String group) {
        return StringUtils.isNotBlank((String)group) && SESSION_MANAGER_MAP != null ? SESSION_MANAGER_MAP.computeIfAbsent(group, k -> ROOT_SESSION_MANAGER) : ROOT_SESSION_MANAGER;
    }

    public static GlobalSession findGlobalSession(String xid) {
        return SessionHolder.findGlobalSession(xid, true);
    }

    public static GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return SessionHolder.getRootSessionManager().findGlobalSession(xid, withBranchSessions);
    }

    public static <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        return SessionHolder.getRootSessionManager().lockAndExecute(globalSession, lockCallable);
    }

    public static boolean acquireDistributedLock(String lockKey) {
        return DISTRIBUTED_LOCKER.acquireLock(new DistributedLockDO(lockKey, XID.getIpAddressAndPort(), Long.valueOf(DISTRIBUTED_LOCK_EXPIRE_TIME)));
    }

    public static boolean releaseDistributedLock(String lockKey) {
        return DISTRIBUTED_LOCKER.releaseLock(new DistributedLockDO(lockKey, XID.getIpAddressAndPort(), Long.valueOf(DISTRIBUTED_LOCK_EXPIRE_TIME)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean distributedLockAndExecute(String key, NoArgsFunc func) {
        boolean lock = false;
        try {
            lock = SessionHolder.acquireDistributedLock(key);
            if (lock) {
                func.call();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception running function with key = {}", (Object)key, (Object)e);
        }
        finally {
            if (lock) {
                try {
                    SessionHolder.releaseDistributedLock(key);
                }
                catch (Exception ex) {
                    LOGGER.warn("release distribute lock failure, message = {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        return lock;
    }

    public static void destroy() {
        RaftServerFactory.getInstance().destroy();
        if (ROOT_SESSION_MANAGER != null) {
            ROOT_SESSION_MANAGER.destroy();
        }
        SESSION_MANAGER_MAP = null;
    }

    @FunctionalInterface
    public static interface NoArgsFunc {
        public void call();
    }
}

