/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.coordinator;

import io.seata.core.exception.AbstractExceptionHandler;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.protocol.transaction.AbstractTransactionRequest;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.rpc.RemotingServer;
import io.seata.server.cluster.listener.ClusterChangeEvent;
import io.seata.server.cluster.raft.context.SeataClusterContext;
import io.seata.server.coordinator.DefaultCoordinator;
import io.seata.server.store.StoreConfig;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationListener;

public class RaftCoordinator
extends DefaultCoordinator
implements ApplicationListener<ClusterChangeEvent> {
    protected static final Map<String, Boolean> GROUP_PREVENT = new ConcurrentHashMap<String, Boolean>();

    public RaftCoordinator(RemotingServer remotingServer) {
        super(remotingServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> void exceptionHandleTemplate(AbstractExceptionHandler.Callback<T, S> callback, T request, S response) {
        String group = SeataClusterContext.bindGroup();
        try {
            if (!this.isPass(group)) {
                throw new TransactionException(TransactionExceptionCode.NotRaftLeader, " The current TC is not a leader node, interrupt processing !");
            }
            super.exceptionHandleTemplate(callback, request, response);
        }
        catch (TransactionException tex) {
            LOGGER.error("Catch TransactionException while do RPC, request: {}", request, (Object)tex);
            callback.onTransactionException(request, response, tex);
        }
        finally {
            SeataClusterContext.unbindGroup();
        }
    }

    private boolean isPass(String group) {
        return Optional.ofNullable(GROUP_PREVENT.get(group)).orElse(false);
    }

    public static void setPrevent(String group, boolean prevent) {
        if (StoreConfig.getSessionMode() == StoreConfig.SessionMode.RAFT) {
            GROUP_PREVENT.put(group, prevent);
        }
    }

    public void onApplicationEvent(ClusterChangeEvent event) {
        RaftCoordinator.setPrevent(event.getGroup(), event.isLeader());
    }
}

