/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.redis;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.console.result.PageResult;
import io.seata.core.store.BranchTransactionDO;
import io.seata.server.console.service.BranchSessionService;
import io.seata.server.console.vo.BranchSessionVO;
import io.seata.server.storage.redis.store.RedisTransactionStoreManager;
import io.seata.server.storage.redis.store.RedisTransactionStoreManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'redis'.equals('${sessionMode}')}")
public class BranchSessionRedisServiceImpl
implements BranchSessionService {
    @Override
    public PageResult<BranchSessionVO> queryByXid(String xid) {
        if (StringUtils.isBlank((String)xid)) {
            return PageResult.success();
        }
        ArrayList<BranchSessionVO> branchSessionVos = new ArrayList<BranchSessionVO>();
        RedisTransactionStoreManager instance = RedisTransactionStoreManagerFactory.getInstance();
        List<BranchTransactionDO> branchSessionDos = instance.findBranchSessionByXid(xid);
        if (CollectionUtils.isNotEmpty(branchSessionDos)) {
            for (BranchTransactionDO branchSessionDo : branchSessionDos) {
                BranchSessionVO branchSessionVO = new BranchSessionVO();
                BeanUtils.copyProperties((Object)branchSessionDo, (Object)branchSessionVO);
                branchSessionVos.add(branchSessionVO);
            }
        }
        return PageResult.success(branchSessionVos, (Integer)branchSessionVos.size(), (Integer)0, (Integer)branchSessionVos.size());
    }
}

