/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.common.loader.LoadLevel;
import io.seata.core.serializer.Serializer;
import java.io.IOException;

@LoadLevel(name="JACKSON")
public class JacksonSerializer
implements Serializer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public <T> byte[] serialize(T t) {
        try {
            JsonInfo jsonInfo = new JsonInfo(this.objectMapper.writeValueAsBytes(t), t.getClass());
            return this.objectMapper.writeValueAsBytes((Object)jsonInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T deserialize(byte[] bytes) {
        try {
            JsonInfo jsonInfo = (JsonInfo)this.objectMapper.readValue(bytes, JsonInfo.class);
            return (T)this.objectMapper.readValue(jsonInfo.getObj(), jsonInfo.getClz());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class JsonInfo {
        byte[] obj;
        Class<?> clz;

        public JsonInfo() {
        }

        public JsonInfo(byte[] obj, Class<?> clz) {
            this.obj = obj;
            this.clz = clz;
        }

        public byte[] getObj() {
            return this.obj;
        }

        public void setObj(byte[] obj) {
            this.obj = obj;
        }

        public Class<?> getClz() {
            return this.clz;
        }

        public void setClz(Class<?> clz) {
            this.clz = clz;
        }
    }
}

