/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.execute.branch;

import io.seata.core.model.BranchStatus;
import io.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import io.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import io.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.raft.session.RaftSessionManager;

public class UpdateBranchSessionExecute
extends AbstractRaftMsgExecute {
    @Override
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession(sessionSyncMsg.getBranchSession().getXid());
        BranchSession branchSession = globalSession.getBranch(sessionSyncMsg.getBranchSession().getBranchId());
        BranchStatus status = BranchStatus.get((int)sessionSyncMsg.getBranchSession().getStatus());
        branchSession.setStatus(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update branch: {} , status: {}", (Object)branchSession.getBranchId(), (Object)branchSession.getStatus());
        }
        return true;
    }
}

