/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.metrics;

import com.google.common.eventbus.Subscribe;
import io.seata.core.event.GlobalTransactionEvent;
import io.seata.core.model.GlobalStatus;
import io.seata.metrics.registry.Registry;
import io.seata.server.event.EventBusManager;
import io.seata.server.metrics.MeterIdConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsSubscriber.class);
    private final Registry registry;
    private final Map<String, Consumer<GlobalTransactionEvent>> consumers;

    public MetricsSubscriber(Registry registry) {
        this.registry = registry;
        this.consumers = new HashMap<String, Consumer<GlobalTransactionEvent>>();
        this.consumers.put(GlobalStatus.Begin.name(), this::processGlobalStatusBegin);
        this.consumers.put(GlobalStatus.Committed.name(), this::processGlobalStatusCommitted);
        this.consumers.put(GlobalStatus.Rollbacked.name(), this::processGlobalStatusRollbacked);
        this.consumers.put(GlobalStatus.CommitFailed.name(), this::processGlobalStatusCommitFailed);
        this.consumers.put(GlobalStatus.RollbackFailed.name(), this::processGlobalStatusRollbackFailed);
        this.consumers.put(GlobalStatus.TimeoutRollbacked.name(), this::processGlobalStatusTimeoutRollbacked);
        this.consumers.put(GlobalStatus.TimeoutRollbackFailed.name(), this::processGlobalStatusTimeoutRollbackFailed);
        this.consumers.put(GlobalStatus.CommitRetryTimeout.name(), this::processGlobalStatusCommitRetryTimeout);
        this.consumers.put(GlobalStatus.RollbackRetryTimeout.name(), this::processGlobalStatusTimeoutRollbackRetryTimeout);
        this.consumers.put("AfterCommitted", this::processAfterGlobalCommitted);
        this.consumers.put("AfterRollbacked", this::processAfterGlobalRollbacked);
    }

    private void processGlobalStatusBegin(GlobalTransactionEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("accept new event,xid:{},event:{}", (Object)event.getId(), (Object)event);
            for (Object object : EventBusManager.get().getSubscribers()) {
                LOGGER.debug("subscribe:{},threadName:{}", (Object)object.toString(), (Object)Thread.currentThread().getName());
            }
        }
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
    }

    private void processGlobalStatusCommitted(GlobalTransactionEvent event) {
        if (event.isRetryGlobal()) {
            return;
        }
        this.decreaseActive(event);
        this.registry.getCounter(MeterIdConstants.COUNTER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getSummary(MeterIdConstants.SUMMARY_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processGlobalStatusRollbacked(GlobalTransactionEvent event) {
        if (event.isRetryGlobal()) {
            return;
        }
        this.decreaseActive(event);
        this.registry.getCounter(MeterIdConstants.COUNTER_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getSummary(MeterIdConstants.SUMMARY_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_ROLLBACK.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processAfterGlobalRollbacked(GlobalTransactionEvent event) {
        if (event.isRetryGlobal() && event.isRetryBranch()) {
            this.decreaseActive(event);
        }
        this.registry.getCounter(MeterIdConstants.COUNTER_AFTER_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getSummary(MeterIdConstants.SUMMARY_AFTER_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_AFTER_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processAfterGlobalCommitted(GlobalTransactionEvent event) {
        if (event.isRetryGlobal() && event.isRetryBranch()) {
            this.decreaseActive(event);
        }
        this.registry.getCounter(MeterIdConstants.COUNTER_AFTER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getSummary(MeterIdConstants.SUMMARY_AFTER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_AFTER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processGlobalStatusCommitFailed(GlobalTransactionEvent event) {
        this.decreaseActive(event);
        this.reportFailed(event);
    }

    private void processGlobalStatusRollbackFailed(GlobalTransactionEvent event) {
        this.decreaseActive(event);
        this.reportFailed(event);
    }

    private void processGlobalStatusTimeoutRollbacked(GlobalTransactionEvent event) {
        this.decreaseActive(event);
    }

    private void processGlobalStatusTimeoutRollbackFailed(GlobalTransactionEvent event) {
        this.decreaseActive(event);
        this.reportTwoPhaseTimeout(event);
    }

    private void processGlobalStatusCommitRetryTimeout(GlobalTransactionEvent event) {
        this.decreaseActive(event);
        this.reportTwoPhaseTimeout(event);
    }

    private void processGlobalStatusTimeoutRollbackRetryTimeout(GlobalTransactionEvent event) {
        this.decreaseActive(event);
    }

    private void decreaseActive(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
    }

    private void reportFailed(GlobalTransactionEvent event) {
        this.registry.getSummary(MeterIdConstants.SUMMARY_FAILED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_FAILED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void reportTwoPhaseTimeout(GlobalTransactionEvent event) {
        this.registry.getSummary(MeterIdConstants.SUMMARY_TWO_PHASE_TIMEOUT.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
    }

    @Subscribe
    public void recordGlobalTransactionEventForMetrics(GlobalTransactionEvent event) {
        if (this.registry != null && this.consumers.containsKey(event.getStatus())) {
            this.consumers.get(event.getStatus()).accept(event);
        }
    }

    public boolean equals(Object obj) {
        return this.getClass().getName().equals(obj.getClass().getName());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

