/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.file;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.console.result.PageResult;
import io.seata.core.lock.RowLock;
import io.seata.server.console.param.GlobalLockParam;
import io.seata.server.console.service.GlobalLockService;
import io.seata.server.console.vo.GlobalLockVO;
import io.seata.server.lock.LockerManagerFactory;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'file'.equals('${lockMode}')}")
public class GlobalLockFileServiceImpl
implements GlobalLockService {
    @Override
    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        this.checkParam(param);
        Collection<GlobalSession> allSessions = SessionHolder.getRootSessionManager().allSessions();
        AtomicInteger total = new AtomicInteger();
        List<RowLock> result = allSessions.parallelStream().filter(this.obtainGlobalSessionPredicate(param)).flatMap(globalSession -> globalSession.getBranchSessions().stream()).filter(this.obtainBranchSessionPredicate(param)).flatMap(branchSession -> this.filterAndMap(param, (BranchSession)branchSession)).peek(globalSession -> total.incrementAndGet()).collect(Collectors.toList());
        return PageResult.build(GlobalLockVO.convert(result), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private Stream<RowLock> filterAndMap(GlobalLockParam param, BranchSession branchSession) {
        if (CollectionUtils.isEmpty(branchSession.getLockHolder())) {
            return Stream.empty();
        }
        String tableName = param.getTableName();
        List<RowLock> rowLocks = LockerManagerFactory.getLockManager().collectRowLocks(branchSession);
        if (StringUtils.isNotBlank((String)tableName)) {
            return rowLocks.parallelStream().filter(rowLock -> rowLock.getTableName().contains(param.getTableName()));
        }
        return rowLocks.stream();
    }

    private void checkParam(GlobalLockParam param) {
        if (param.getPageSize() <= 0 || param.getPageNum() <= 0) {
            throw new IllegalArgumentException("wrong pageSize or pageNum");
        }
        try {
            Long.parseLong(param.getTransactionId());
        }
        catch (NumberFormatException e) {
            param.setTransactionId(null);
        }
        try {
            Long.parseLong(param.getBranchId());
        }
        catch (NumberFormatException e) {
            param.setBranchId(null);
        }
    }

    private Predicate<? super BranchSession> obtainBranchSessionPredicate(GlobalLockParam param) {
        return branchSession -> !(!StringUtils.isBlank((String)param.getTransactionId()) && !String.valueOf(branchSession.getTransactionId()).contains(param.getTransactionId()) || !StringUtils.isBlank((String)param.getBranchId()) && !String.valueOf(branchSession.getBranchId()).contains(param.getBranchId()));
    }

    private Predicate<? super GlobalSession> obtainGlobalSessionPredicate(GlobalLockParam param) {
        return globalSession -> !(!CollectionUtils.isNotEmpty(globalSession.getBranchSessions()) || !StringUtils.isBlank((String)param.getXid()) && !globalSession.getXid().contains(param.getXid()) || !Objects.isNull(param.getTimeStart()) && param.getTimeStart() > globalSession.getBeginTime() || !Objects.isNull(param.getTimeEnd()) && param.getTimeEnd() < globalSession.getBeginTime());
    }
}

