/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.handler.postgresql;

import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.sqlparser.EscapeHandler;
import io.seata.sqlparser.struct.ColumnMeta;
import io.seata.sqlparser.struct.TableMeta;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

@LoadLevel(name="postgresql")
public class PostgresqlEscapeHandler
implements EscapeHandler {
    private Set<String> keywordSet = Arrays.stream(PostgresqlKeyword.values()).map(Enum::name).collect(Collectors.toSet());

    public boolean checkIfKeyWords(String fieldOrTableName) {
        if (this.keywordSet.contains(fieldOrTableName)) {
            return true;
        }
        if (fieldOrTableName != null) {
            fieldOrTableName = fieldOrTableName.toUpperCase();
        }
        return this.keywordSet.contains(fieldOrTableName);
    }

    public boolean checkIfNeedEscape(String columnName, TableMeta tableMeta) {
        if (StringUtils.isBlank((String)columnName)) {
            return false;
        }
        if (this.containsEscape(columnName = columnName.trim())) {
            return false;
        }
        boolean isKeyWord = this.checkIfKeyWords(columnName);
        if (isKeyWord) {
            return true;
        }
        if (null != tableMeta) {
            ColumnMeta columnMeta = tableMeta.getColumnMeta(columnName);
            if (null != columnMeta) {
                return columnMeta.isCaseSensitive();
            }
        } else if (!PostgresqlEscapeHandler.containsUppercase(columnName)) {
            return false;
        }
        return true;
    }

    private static boolean containsUppercase(String colName) {
        char[] chars;
        if (colName == null) {
            return false;
        }
        for (char ch : chars = colName.toCharArray()) {
            if (ch < 'A' || ch > 'Z') continue;
            return true;
        }
        return false;
    }

    private static enum PostgresqlKeyword {
        ALL("ALL"),
        ANALYSE("ANALYSE"),
        ANALYZE("ANALYZE"),
        AND("AND"),
        ANY("ANY"),
        ARRAY("ARRAY"),
        AS("AS"),
        ASC("ASC"),
        ASYMMETRIC("ASYMMETRIC"),
        BOTH("BOTH"),
        CASE("CASE"),
        CAST("CAST"),
        CHECK("CHECK"),
        COLLATE("COLLATE"),
        COLUMN("COLUMN"),
        CONSTRAINT("CONSTRAINT"),
        CREATE("CREATE"),
        CURRENT_CATALOG("CURRENT_CATALOG"),
        CURRENT_DATE("CURRENT_DATE"),
        CURRENT_ROLE("CURRENT_ROLE"),
        CURRENT_TIME("CURRENT_TIME"),
        CURRENT_TIMESTAMP("CURRENT_TIMESTAMP"),
        CURRENT_USER("CURRENT_USER"),
        DEFAULT("DEFAULT"),
        DEFERRABLE("DEFERRABLE"),
        DESC("DESC"),
        DISTINCT("DISTINCT"),
        DO("DO"),
        ELSE("ELSE"),
        END("END"),
        EXCEPT("EXCEPT"),
        FALSE("FALSE"),
        FETCH("FETCH"),
        FOR("FOR"),
        FOREIGN("FOREIGN"),
        FROM("FROM"),
        GRANT("GRANT"),
        GROUP("GROUP"),
        HAVING("HAVING"),
        IN("IN"),
        INITIALLY("INITIALLY"),
        INTERSECT("INTERSECT"),
        INTO("INTO"),
        LATERAL("LATERAL"),
        LEADING("LEADING"),
        LIMIT("LIMIT"),
        LOCALTIME("LOCALTIME"),
        LOCALTIMESTAMP("LOCALTIMESTAMP"),
        NOT("NOT"),
        NULL("NULL"),
        OFFSET("OFFSET"),
        ON("ON"),
        ONLY("ONLY"),
        OR("OR"),
        ORDER("ORDER"),
        PLACING("PLACING"),
        PRIMARY("PRIMARY"),
        REFERENCES("REFERENCES"),
        RETURNING("RETURNING"),
        SELECT("SELECT"),
        SESSION_USER("SESSION_USER"),
        SOME("SOME"),
        SYMMETRIC("SYMMETRIC"),
        TABLE("TABLE"),
        THEN("THEN"),
        TO("TO"),
        TRAILING("TRAILING"),
        TRUE("TRUE"),
        UNION("UNION"),
        UNIQUE("UNIQUE"),
        USER("USER"),
        USING("USING"),
        VARIADIC("VARIADIC"),
        WHEN("WHEN"),
        WHERE("WHERE"),
        WINDOW("WINDOW"),
        WITH("WITH");

        public final String name;

        private PostgresqlKeyword(String name) {
            this.name = name;
        }
    }
}

