/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import io.protostuff.Input;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.WireFormat;
import io.protostuff.runtime.DefaultIdStrategy;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.RuntimeEnv;
import io.protostuff.runtime.RuntimeSchema;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

@LoadLevel(name="protostuff")
public class ProtostuffUndoLogParser
implements UndoLogParser {
    public static final String NAME = "protostuff";
    private static final DefaultIdStrategy ID_STRATEGY = (DefaultIdStrategy)RuntimeEnv.ID_STRATEGY;
    private static final Schema<BranchUndoLog> SCHEMA;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return this.encode(new BranchUndoLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray((Object)branchUndoLog, SCHEMA, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        if (bytes.length == 0) {
            return new BranchUndoLog();
        }
        BranchUndoLog fooParsed = (BranchUndoLog)SCHEMA.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)fooParsed, SCHEMA);
        return fooParsed;
    }

    static {
        ID_STRATEGY.registerDelegate((Delegate)new DateDelegate());
        ID_STRATEGY.registerDelegate((Delegate)new TimestampDelegate());
        ID_STRATEGY.registerDelegate((Delegate)new SqlDateDelegate());
        ID_STRATEGY.registerDelegate((Delegate)new TimeDelegate());
        SCHEMA = RuntimeSchema.getSchema(BranchUndoLog.class);
    }

    public static class DateDelegate
    implements Delegate<java.util.Date> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return java.util.Date.class;
        }

        public java.util.Date readFrom(Input input) throws IOException {
            return new java.util.Date(input.readFixed64());
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        public void writeTo(Output output, int number, java.util.Date value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }
    }

    public static class TimeDelegate
    implements Delegate<Time> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return Time.class;
        }

        public Time readFrom(Input input) throws IOException {
            return new Time(input.readFixed64());
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        public void writeTo(Output output, int number, Time value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }
    }

    public static class SqlDateDelegate
    implements Delegate<Date> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return Date.class;
        }

        public Date readFrom(Input input) throws IOException {
            return new Date(input.readFixed64());
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        public void writeTo(Output output, int number, Date value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }
    }

    public static class TimestampDelegate
    implements Delegate<Timestamp> {
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        public Class<?> typeClass() {
            return Timestamp.class;
        }

        public Timestamp readFrom(Input input) throws IOException {
            return new Timestamp(input.readFixed64());
        }

        public void writeTo(Output output, int number, Timestamp value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }

        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }
    }
}

