/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import io.seata.common.exception.NotSupportYetException;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.IndexMeta;
import io.seata.rm.datasource.sql.struct.IndexType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableMeta {
    private String tableName;
    private Map<String, ColumnMeta> allColumns = new HashMap<String, ColumnMeta>();
    private Map<String, IndexMeta> allIndexes = new HashMap<String, IndexMeta>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ColumnMeta getColumnMeta(String colName) {
        String s = colName;
        ColumnMeta col = this.allColumns.get(s);
        if (col == null) {
            col = colName.charAt(0) == '`' ? this.allColumns.get(s.substring(1, colName.length() - 1)) : this.allColumns.get("`" + s + "`");
        }
        return col;
    }

    public Map<String, ColumnMeta> getAllColumns() {
        return this.allColumns;
    }

    public Map<String, IndexMeta> getAllIndexes() {
        return this.allIndexes;
    }

    public ColumnMeta getAutoIncreaseColumn() {
        for (Map.Entry<String, ColumnMeta> entry : this.allColumns.entrySet()) {
            ColumnMeta col = entry.getValue();
            if (!"YES".equalsIgnoreCase(col.getIsAutoincrement())) continue;
            return col;
        }
        return null;
    }

    public Map<String, ColumnMeta> getPrimaryKeyMap() {
        HashMap<String, ColumnMeta> pk = new HashMap<String, ColumnMeta>();
        for (Map.Entry<String, IndexMeta> entry : this.allIndexes.entrySet()) {
            IndexMeta index = entry.getValue();
            if (index.getIndextype().value() != IndexType.PRIMARY.value()) continue;
            for (ColumnMeta col : index.getValues()) {
                pk.put(col.getColumnName(), col);
            }
        }
        if (pk.size() > 1) {
            throw new NotSupportYetException("Multi PK");
        }
        return pk;
    }

    public List<String> getPrimaryKeyOnlyName() {
        return new ArrayList<String>(){
            {
                for (Map.Entry<String, ColumnMeta> entry : TableMeta.this.getPrimaryKeyMap().entrySet()) {
                    this.add(entry.getKey());
                }
            }
        };
    }

    public String getPkName() {
        return this.getPrimaryKeyOnlyName().get(0);
    }

    public boolean containsPK(List<String> cols) {
        if (cols == null) {
            return false;
        }
        List<String> pk = this.getPrimaryKeyOnlyName();
        if (pk.isEmpty()) {
            return false;
        }
        return cols.containsAll(pk);
    }

    public String getCreateTableSQL() {
        StringBuilder sb = new StringBuilder("CREATE TABLE");
        sb.append(String.format(" `%s` ", this.getTableName()));
        sb.append("(");
        boolean flag = true;
        Map<String, ColumnMeta> allColumns = this.getAllColumns();
        for (Map.Entry<String, ColumnMeta> entry : allColumns.entrySet()) {
            if (flag) {
                flag = false;
            } else {
                sb.append(",");
            }
            ColumnMeta col = entry.getValue();
            sb.append(String.format(" `%s` ", col.getColumnName()));
            sb.append(col.getDataTypeName());
            if (col.getColumnSize() > 0) {
                sb.append(String.format("(%d)", col.getColumnSize()));
            }
            if (col.getColumnDef() != null && col.getColumnDef().length() > 0) {
                sb.append(String.format(" default '%s'", col.getColumnDef()));
            }
            if (col.getIsNullAble() == null || col.getIsNullAble().length() <= 0) continue;
            sb.append(" ");
            sb.append(col.getIsNullAble());
        }
        Map<String, IndexMeta> allIndexes = this.getAllIndexes();
        for (Map.Entry<String, IndexMeta> entry : allIndexes.entrySet()) {
            sb.append(", ");
            IndexMeta index = entry.getValue();
            switch (index.getIndextype()) {
                case FullText: {
                    break;
                }
                case Normal: {
                    sb.append(String.format("KEY `%s`", index.getIndexName()));
                    break;
                }
                case PRIMARY: {
                    sb.append(String.format("PRIMARY KEY", new Object[0]));
                    break;
                }
                case Unique: {
                    sb.append(String.format("UNIQUE KEY `%s`", index.getIndexName()));
                    break;
                }
            }
            sb.append(" (");
            boolean f = true;
            for (ColumnMeta c : index.getValues()) {
                if (f) {
                    f = false;
                } else {
                    sb.append(",");
                }
                sb.append(String.format("`%s`", c.getColumnName()));
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }
}

