/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.processor.server;

import io.netty.channel.ChannelHandlerContext;
import io.seata.core.protocol.HeartbeatMessage;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.rpc.RemotingServer;
import io.seata.core.rpc.processor.RemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHeartbeatProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerHeartbeatProcessor.class);
    private RemotingServer remotingServer;

    public ServerHeartbeatProcessor(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        try {
            this.remotingServer.sendAsyncResponse(rpcMessage, ctx.channel(), HeartbeatMessage.PONG);
        }
        catch (Throwable throwable) {
            LOGGER.error("send response error: {}", (Object)throwable.getMessage(), (Object)throwable);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("received PING from {}", (Object)ctx.channel().remoteAddress());
        }
    }
}

