/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.processor.client;

import io.netty.channel.ChannelHandlerContext;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.processor.RemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmUndoLogProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmUndoLogProcessor.class);
    private TransactionMessageHandler handler;

    public RmUndoLogProcessor(TransactionMessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public void process(ChannelHandlerContext ctx, RpcMessage rpcMessage) throws Exception {
        Object msg = rpcMessage.getBody();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("rm handle undo log process:" + msg);
        }
        this.handleUndoLogDelete((UndoLogDeleteRequest)msg);
    }

    private void handleUndoLogDelete(UndoLogDeleteRequest undoLogDeleteRequest) {
        try {
            this.handler.onRequest(undoLogDeleteRequest, null);
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete undo log by undoLogDeleteRequest on" + undoLogDeleteRequest.getResourceId());
        }
    }
}

