/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol;

import io.netty.buffer.ByteBuf;
import io.seata.codec.seata.MessageCodecFactory;
import io.seata.codec.seata.MessageSeataCodec;
import io.seata.codec.seata.protocol.AbstractMessageCodec;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.MergeResultMessage;
import java.nio.ByteBuffer;

public class MergeResultMessageCodec
extends AbstractMessageCodec {
    @Override
    public Class<?> getMessageClassType() {
        return MergeResultMessage.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        MergeResultMessage mergeResultMessage = (MergeResultMessage)t;
        AbstractResultMessage[] msgs = mergeResultMessage.getMsgs();
        int writeIndex = out.writerIndex();
        out.writeInt(0);
        out.writeShort((int)((short)msgs.length));
        for (AbstractResultMessage msg : msgs) {
            short typeCode = msg.getTypeCode();
            out.writeShort((int)typeCode);
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode);
            messageCodec.encode(msg, out);
        }
        int length = out.readableBytes() - 4;
        out.setInt(writeIndex, length);
        if (msgs.length > 20 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("msg in one services merge packet:" + msgs.length + ",buffer size:" + length);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        MergeResultMessage mergeResultMessage = (MergeResultMessage)t;
        if (in.remaining() < 4) {
            return;
        }
        int length = in.getInt();
        if (in.remaining() < length) {
            return;
        }
        byte[] buffer = new byte[length];
        in.get(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.decode(mergeResultMessage, byteBuffer);
    }

    protected void decode(MergeResultMessage mergeResultMessage, ByteBuffer byteBuffer) {
        int msgNum = byteBuffer.getShort();
        AbstractResultMessage[] msgs = new AbstractResultMessage[msgNum];
        for (int idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            AbstractMessage abstractResultMessage = MessageCodecFactory.getMessage(typeCode);
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode);
            messageCodec.decode(abstractResultMessage, byteBuffer);
            msgs[idx] = (AbstractResultMessage)abstractResultMessage;
        }
        mergeResultMessage.setMsgs(msgs);
    }
}

