/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices;

import com.google.gson.Gson;
import io.searchbox.AbstractAction;

public class Analyze
extends AbstractAction {
    private Object source;

    public Analyze(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.source = builder.source;
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_analyze");
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public Object getData(Gson gson) {
        return this.source;
    }

    public static class Builder
    extends AbstractAction.Builder<Analyze, Builder> {
        private String index;
        private Object source;

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder source(Object source) {
            this.source = source;
            return this;
        }

        public Builder analyzer(String analyzer) {
            return (Builder)this.setParameter("analyzer", analyzer);
        }

        public Builder field(String field) {
            return (Builder)this.setParameter("field", field);
        }

        public Builder tokenizer(String tokenizer) {
            return (Builder)this.setParameter("tokenizer", tokenizer);
        }

        public Builder filter(String filter) {
            return (Builder)this.setParameter("filters", filter);
        }

        public Builder format(String format) {
            return (Builder)this.setParameter("format", format);
        }

        @Override
        public Analyze build() {
            return new Analyze(this);
        }
    }
}

